/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.enterprise.cluster.webrtc;

import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.net.NetSocket;
import java.nio.ByteBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterPacketHandler
implements Handler<Buffer> {
    private static Logger logger = LoggerFactory.getLogger(ClusterPacketHandler.class);
    public static final String PACKET_HEADER_CLUSTER = "PACKET_HEADER_CLUSTER";
    private static final int HEADER_STRING_LENGTH = "PACKET_HEADER_CLUSTER".length();
    private ByteBuffer headerBuffer = ByteBuffer.allocate(HEADER_STRING_LENGTH + 4);
    private ByteBuffer packetBuffer;
    private IPacketReceiveListener listener;

    public ClusterPacketHandler(IPacketReceiveListener listener) {
        this.listener = listener;
    }

    public void handle(Buffer data) {
        int processedDataLength = 0;
        while (processedDataLength < data.length()) {
            if (this.headerBuffer.position() < this.headerBuffer.capacity()) {
                int missingHeaderData = this.headerBuffer.capacity() - this.headerBuffer.position();
                int appendableHeaderDataLength = Math.min(missingHeaderData, data.length() - processedDataLength);
                this.headerBuffer.put(data.getBytes(processedDataLength, processedDataLength + appendableHeaderDataLength));
                processedDataLength += appendableHeaderDataLength;
                if (this.headerBuffer.position() != this.headerBuffer.capacity()) continue;
                this.packetBuffer = ByteBuffer.allocate(this.headerBuffer.getInt(HEADER_STRING_LENGTH));
                continue;
            }
            int missingPacketData = this.packetBuffer.capacity() - this.packetBuffer.position();
            int appendablePacketDataLength = Math.min(missingPacketData, data.length() - processedDataLength);
            this.packetBuffer.put(data.getBytes(processedDataLength, processedDataLength + appendablePacketDataLength));
            processedDataLength += appendablePacketDataLength;
            if (this.packetBuffer.position() != this.packetBuffer.capacity()) continue;
            this.listener.packetReceived(this.packetBuffer.array());
            this.headerBuffer.clear();
        }
    }

    public static synchronized void sendPacket(byte[] rawData, NetSocket socket) {
        ClusterPacketHandler.sendHeaderPacket(rawData.length, socket);
        socket.write(Buffer.buffer((byte[])rawData));
    }

    public static void sendHeaderPacket(int dataLength, NetSocket socket) {
        socket.write(ClusterPacketHandler.getHeaderPacket(dataLength));
    }

    public static Buffer getHeaderPacket(int dataLength) {
        return Buffer.buffer((String)PACKET_HEADER_CLUSTER).appendInt(dataLength);
    }

    public static interface IPacketReceiveListener {
        public void packetReceived(byte[] var1);
    }
}

