/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.enterprise.cluster;

import io.antmedia.AppSettings;
import io.antmedia.IAppSettingsUpdateListener;
import io.antmedia.ICreateAppListener;
import io.antmedia.IDeleteAppListener;
import io.antmedia.cluster.ClusterNode;
import io.antmedia.cluster.IClusterNotifier;
import io.antmedia.cluster.IClusterStore;
import io.antmedia.settings.ServerSettings;
import io.antmedia.shutdown.AMSShutdownManager;
import io.antmedia.shutdown.IShutdownListener;
import io.vertx.core.Vertx;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.red5.server.Launcher;
import org.red5.spring.Red5ApplicationContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class TcpCluster
implements ApplicationContextAware,
IClusterNotifier,
IShutdownListener {
    public static final int DELETE_HLS_FILES_WAIT_DELAY = 30000;
    private Logger logger = LoggerFactory.getLogger(TcpCluster.class);
    private Vertx vertx;
    private IClusterStore clusterStore;
    private ClusterNode localNode;
    private ServerSettings serverSettings;
    private Map<String, IAppSettingsUpdateListener> settingsListenerMap = new ConcurrentHashMap<String, IAppSettingsUpdateListener>();
    private Map<String, Long> settingsUpdateTimeMap = new HashMap<String, Long>();
    private ICreateAppListener createApplistener;
    private IDeleteAppListener deleteApplistener;
    private long clusterSynchTimer;

    public TcpCluster() {
        AMSShutdownManager.getInstance().subscribe((IShutdownListener)this);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        Red5ApplicationContext red5Common = (Red5ApplicationContext)applicationContext.getBean("red5.common");
        this.vertx = (Vertx)red5Common.getBean("vertxCore");
        this.serverSettings = (ServerSettings)red5Common.getBean("ant.media.server.settings");
        this.initDBCluster();
    }

    public Vertx getVertx() {
        return this.vertx;
    }

    public void setVertx(Vertx vertx) {
        this.vertx = vertx;
    }

    public void initDBCluster() {
        this.logger.info("Initializing in Cluster mode with ip: {}", (Object)this.serverSettings.getHostAddress());
        this.localNode = new ClusterNode(this.serverSettings.getHostAddress(), Launcher.getInstanceId() + this.serverSettings.getHostAddress());
        this.getClusterStore().addOrUpdate(this.localNode);
        this.clusterSynchTimer = this.vertx.setPeriodic(5000L, l -> {
            this.localNode.setLastUpdateTime(System.currentTimeMillis());
            this.getClusterStore().addOrUpdate(this.localNode);
            this.logger.debug("checking mongodb for updated settings");
            this.checkAndUpdateAppSettings();
        });
    }

    public void checkAndUpdateAppSettings() {
        List allSettings = this.getClusterStore().getAllSettings();
        for (AppSettings settings : allSettings) {
            String appName = settings.getAppName();
            IAppSettingsUpdateListener appSettingsListener = this.settingsListenerMap.get(appName);
            if (settings.isToBeDeleted() && appSettingsListener != null && this.deleteApplistener != null) {
                this.logger.info("Deleting application:{} from the node notified by cluster ", (Object)appName);
                this.deleteApplistener.deleteApplication(appName);
                this.settingsListenerMap.remove(appName);
                continue;
            }
            if (!settings.isToBeDeleted()) {
                if (appSettingsListener != null) {
                    this.updateAppSettings(settings, appName, appSettingsListener);
                    continue;
                }
                if (this.createApplistener == null) continue;
                String appFolderName = "webapps/" + appName;
                File f = new File(appFolderName);
                if (!f.exists()) {
                    this.createApplistener.createApplication(appName);
                    continue;
                }
                this.logger.info("Not calling create application for {} because app folder {} already exist", (Object)appName, (Object)f.getAbsolutePath());
                continue;
            }
            this.logger.debug("App:{} is marked as to be deleted but app is not deleted. It may already be deleted AppSettingsListener(is null -> {}) or deleteApplistener(is null -> {}) are null", new Object[]{appName, appSettingsListener == null, this.deleteApplistener == null});
        }
    }

    private void updateAppSettings(AppSettings settings, String appName, IAppSettingsUpdateListener appSettingsListener) {
        Long lastUpdateTime = this.settingsUpdateTimeMap.get(appName);
        boolean updateRequired = false;
        if (lastUpdateTime == null || lastUpdateTime < settings.getUpdateTime()) {
            updateRequired = true;
        }
        if (updateRequired) {
            this.logger.info("Update settings from cluster for app:{}", (Object)appName);
            appSettingsListener.settingsUpdated(settings);
        }
        this.settingsUpdateTimeMap.put(appName, settings.getUpdateTime());
    }

    public IClusterStore getClusterStore() {
        return this.clusterStore;
    }

    public void setClusterStore(IClusterStore clusterStore) {
        this.clusterStore = clusterStore;
    }

    public void serverShuttingdown() {
        this.logger.info("Server is sutting down, node  with ip {} will be droped from Cluster DB", (Object)this.localNode.getIp());
        this.vertx.cancelTimer(this.clusterSynchTimer);
        this.getClusterStore().deleteNode(this.localNode.getId());
    }

    public ServerSettings getServerSettings() {
        return this.serverSettings;
    }

    public void setServerSettings(ServerSettings serverSettings) {
        this.serverSettings = serverSettings;
    }

    public void registerSettingUpdateListener(String appName, IAppSettingsUpdateListener listener) {
        this.settingsListenerMap.put(appName, listener);
    }

    public Map<String, IAppSettingsUpdateListener> getSettingsListenerMap() {
        return this.settingsListenerMap;
    }

    public Map<String, Long> getSettingsUpdateTimeMap() {
        return this.settingsUpdateTimeMap;
    }

    public void registerCreateAppListener(ICreateAppListener createApplistener) {
        this.createApplistener = createApplistener;
    }

    public void registerDeleteAppListener(IDeleteAppListener deleteApplistener) {
        this.deleteApplistener = deleteApplistener;
    }
}

