/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.enterprise.cluster;

public class RequestInfo {
    public static final int HLS_REQUEST = 0;
    public static final int TS_REQUEST = 1;
    public static final int PREVIEW_REQUEST = 2;
    public static final int OTHER_REQUEST = -1;
    public static final int DASH_REQUEST = 3;
    public static final int DASH_SEGMENT = 4;
    public static final String ADAPTIVE_REGEX = ".*_[0-9]+p[0-9]+kbps\\..*";
    public String reqURI;
    public int type;
    public String streamName;
    public String scopeName;
    private boolean isAdaptive;

    public RequestInfo(String reqURI) {
        this.reqURI = reqURI;
        this.isAdaptive = reqURI.matches(ADAPTIVE_REGEX);
        this.defineType();
        if (this.type == 0 || this.type == 1 || this.type == 2 || this.type == 4 || this.type == 3) {
            this.defineStreamName();
            this.defineScopeName();
        }
    }

    public boolean isStreamReq() {
        return this.type != -1;
    }

    private void defineType() {
        this.type = this.reqURI.endsWith(".m3u8") ? 0 : (this.reqURI.endsWith(".ts") ? 1 : (this.reqURI.endsWith(".m4s") ? 4 : (this.reqURI.endsWith(".mpd") ? 3 : (this.reqURI.endsWith(".png") && this.reqURI.contains("/previews/") ? 2 : -1))));
    }

    private void defineStreamName() {
        int startIndex = this.reqURI.lastIndexOf("/");
        int endIndex = -1;
        if (this.type == 0) {
            endIndex = this.reqURI.lastIndexOf("_adaptive.m3u8");
            if (endIndex == -1) {
                endIndex = this.reqURI.lastIndexOf(this.isAdaptive ? "_" : ".m3u8");
            }
        } else if (this.type == 1) {
            endIndex = this.reqURI.lastIndexOf("_");
        } else if (this.type == 2) {
            endIndex = this.reqURI.lastIndexOf(".png");
        } else if (this.type == 3) {
            endIndex = this.reqURI.lastIndexOf(".mpd");
        } else if (this.type == 4) {
            endIndex = this.reqURI.lastIndexOf("_");
        }
        if (endIndex != -1) {
            this.streamName = this.reqURI.substring(startIndex + 1, endIndex);
        }
    }

    private void defineScopeName() {
        int startIndex = this.reqURI.indexOf("/");
        if (startIndex == 0) {
            int endIndex = this.reqURI.indexOf("/", startIndex + 1);
            this.scopeName = this.reqURI.substring(startIndex + 1, endIndex);
        }
    }

    public String toString() {
        return "request uri:" + this.reqURI;
    }
}

