/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.enterprise.cluster;

import io.antmedia.datastore.db.IDataStoreFactory;
import io.antmedia.datastore.db.types.Broadcast;
import io.antmedia.enterprise.cluster.HLSFileDeletionManager;
import io.antmedia.enterprise.cluster.RequestInfo;
import io.antmedia.filter.TokenGenerator;
import io.antmedia.servlet.IChunkedCacheManager;
import io.antmedia.servlet.cmafutils.AtomParser;
import io.antmedia.servlet.cmafutils.IParser;
import io.antmedia.settings.ServerSettings;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import javax.servlet.ServletException;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.valves.ValveBase;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.http.client.CookieStore;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.ConfigurableWebApplicationContext;
import org.springframework.web.context.WebApplicationContext;

public class HttpLiveStreamValve
extends ValveBase {
    public static final String M4S_EXTENSION = ".m4s";
    public static final String M3U8_EXTENSION = ".m3u8";
    private static final String HOST_QUERY_PARAMETER = "hostAddress";
    private Logger logger = LoggerFactory.getLogger(HttpLiveStreamValve.class);
    private Map<String, Long> lastDownloadTimeMap = new ConcurrentHashMap<String, Long>();
    private List<String> downloadInProgress = Collections.synchronizedList(new LinkedList());
    private Map<String, ReentrantLock> lockMap = new ConcurrentHashMap<String, ReentrantLock>();
    private int httpPort = 5080;
    CookieStore cookieStore = new BasicCookieStore();
    HttpContext httpContext = new BasicHttpContext();
    private Map<String, Broadcast> broadcastMap = new ConcurrentHashMap<String, Broadcast>();
    private Map<String, Long> broadcastLastSynchTime = new ConcurrentHashMap<String, Long>();
    HLSFileDeletionManager deletionManager;
    private TokenGenerator tokenGenerator;
    public Object lock = new Object();

    protected synchronized void startInternal() throws LifecycleException {
        this.httpContext.setAttribute("http.cookie-store", (Object)this.cookieStore);
        super.startInternal();
    }

    public void invoke(Request request, Response response) throws IOException, ServletException {
        this.logger.trace("request uri:{}", (Object)request.getRequestURI());
        RequestInfo reqInfo = new RequestInfo(request.getRequestURI());
        if (!reqInfo.isStreamReq() || reqInfo.streamName == null) {
            this.getNext().invoke(request, response);
            return;
        }
        ConfigurableWebApplicationContext context = (ConfigurableWebApplicationContext)request.getServletContext().getAttribute(WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE);
        if (context == null || !context.isRunning()) {
            this.logger.error("Context is not ready yet for request: {}", (Object)request.getRequestURI());
            return;
        }
        if (context.containsBean("ant.media.server.settings")) {
            ServerSettings serverSettings = (ServerSettings)context.getBean("ant.media.server.settings");
            this.httpPort = serverSettings.getDefaultHttpPort();
        } else {
            this.logger.info("No ServerSettings bean for stream {}", (Object)request.getRequestURI());
        }
        String originAddress = this.getBroadcastOriginAddress(context, reqInfo.streamName);
        if (originAddress == null || originAddress.isEmpty()) {
            this.getNext().invoke(request, response);
            return;
        }
        String hostAddressQueryParameter = request.getParameter(HOST_QUERY_PARAMETER);
        if (originAddress.equals(request.getLocalAddr()) || originAddress.equals(ServerSettings.getLocalHostAddress()) || ServerSettings.getLocalHostAddress().equals(hostAddressQueryParameter)) {
            this.logger.debug("Request comes to origin stream:{} origin:{} local address:{} host query:{}", new Object[]{request.getRequestURI(), originAddress, ServerSettings.getLocalHostAddress(), hostAddressQueryParameter});
            request.setAttribute("ClusterToken", (Object)this.tokenGenerator.getGenetaredToken());
            this.getNext().invoke(request, response);
            return;
        }
        this.downloadRequestedFile(reqInfo, originAddress, (Vertx)context.getBean("vertxCore"), (IChunkedCacheManager)context.getBean("chunked.cache.manager"));
        this.getNext().invoke(request, response);
    }

    public String getBroadcastOriginAddress(ConfigurableWebApplicationContext context, String streamName) {
        Broadcast broadcast = this.broadcastMap.get(streamName);
        if (broadcast == null) {
            broadcast = this.getAndUpdateBroadcast(context, streamName);
        } else {
            Long lastSynchTime = this.broadcastLastSynchTime.get(streamName);
            if (System.currentTimeMillis() > lastSynchTime + 10000L) {
                broadcast = this.getAndUpdateBroadcast(context, streamName);
            }
            if (broadcast == null || !"broadcasting".equals(broadcast.getStatus())) {
                this.broadcastMap.remove(streamName);
                this.broadcastLastSynchTime.remove(streamName);
            }
        }
        return broadcast != null ? broadcast.getOriginAdress() : null;
    }

    private Broadcast getAndUpdateBroadcast(ConfigurableWebApplicationContext context, String streamName) {
        IDataStoreFactory dbFactory = (IDataStoreFactory)context.getBean("dataStoreFactory");
        Broadcast broadcast = dbFactory.getDataStore().get(streamName);
        if (broadcast != null) {
            this.broadcastMap.put(streamName, broadcast);
            this.broadcastLastSynchTime.put(streamName, System.currentTimeMillis());
        }
        return broadcast;
    }

    public String getURL(String hostName, String requestURI, String query) {
        return "http://" + hostName + ":" + this.httpPort + requestURI + "?" + query;
    }

    private void downloadRequestedFile(RequestInfo reqInfo, String hostName, Vertx vertx, IChunkedCacheManager iChunkedCacheManager) {
        File file = new File("webapps" + reqInfo.reqURI);
        if (!file.exists()) {
            String url = this.getURL(hostName, reqInfo.reqURI, "hostAddress=" + ServerSettings.getLocalHostAddress());
            this.downloadFile(vertx, url, file, reqInfo.reqURI, iChunkedCacheManager);
            this.setLastDownloadTime(reqInfo);
        } else {
            Long lastDownloadTime = this.getLastDownloadTime(reqInfo);
            long now = System.currentTimeMillis();
            if (lastDownloadTime == null || now - 1000L > lastDownloadTime) {
                String url = this.getURL(hostName, reqInfo.reqURI, "hostAddress=" + ServerSettings.getLocalHostAddress());
                this.downloadFile(vertx, url, file, reqInfo.reqURI, iChunkedCacheManager);
                this.setLastDownloadTime(reqInfo);
            } else {
                this.logger.trace("File({}) will not be downloaded because it's not expired last download time:{} current time: {}", new Object[]{file.getAbsolutePath(), lastDownloadTime, now});
            }
        }
        this.getDeletionManager(vertx).addNewFile(reqInfo.reqURI);
    }

    private void setLastDownloadTime(RequestInfo reqInfo) {
        this.lastDownloadTimeMap.put(reqInfo.reqURI, System.currentTimeMillis());
    }

    private Long getLastDownloadTime(RequestInfo reqInfo) {
        return this.lastDownloadTimeMap.get(reqInfo.reqURI);
    }

    public CloseableHttpClient getHttpClient() {
        return HttpClients.createDefault();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void downloadFile(Vertx vertx, String url, File file, String requestURI, IChunkedCacheManager iChunkedCacheManager) {
        Object object = this.lock;
        synchronized (object) {
            if (this.downloadInProgress.contains(requestURI)) {
                ReentrantLock reentrantLock = this.lockMap.get(requestURI);
                if (reentrantLock != null) {
                    long startTime = System.currentTimeMillis();
                    this.logger.info("Requesting a file to being downloaded: {} it'll wait until download has finished", (Object)requestURI);
                    reentrantLock.lock();
                    reentrantLock.unlock();
                    long waitTime = System.currentTimeMillis() - startTime;
                    this.logger.info("Total wait time for the download of {} is {}ms", (Object)requestURI, (Object)waitTime);
                }
                return;
            }
            this.downloadInProgress.add(requestURI);
            if (!file.getAbsolutePath().endsWith(M4S_EXTENSION)) {
                ReentrantLock reentrantLock = new ReentrantLock();
                this.lockMap.put(requestURI, reentrantLock);
                this.lockMap.get(requestURI).lock();
            }
        }
        if (file.getAbsolutePath().endsWith(M4S_EXTENSION)) {
            iChunkedCacheManager.addCache(file.getAbsolutePath());
            AtomParser atomparser = new AtomParser(completeChunk -> iChunkedCacheManager.append(file.getAbsolutePath(), completeChunk));
            vertx.executeBlocking(arg_0 -> this.lambda$downloadFile$1(url, file, (IParser)atomparser, iChunkedCacheManager, requestURI, arg_0), false, null);
        } else {
            this.handleHttpConnection(url, file, (IParser)new AtomParser.MockAtomParser());
            this.downloadInProgress.remove(requestURI);
        }
        if (this.lockMap.containsKey(requestURI)) {
            this.lockMap.get(requestURI).unlock();
            this.lockMap.remove(requestURI);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void handleHttpConnection(String url, File file, IParser atomparser) {
        File tmpFile;
        block35: {
            RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(5000).setSocketTimeout(8000).build();
            tmpFile = new File(file.getAbsolutePath() + ".tmp");
            try (CloseableHttpClient client = this.getHttpClient();){
                HttpGet httpGet = new HttpGet(url);
                this.logger.info("url to download {}", (Object)url);
                httpGet.setConfig(requestConfig);
                try (CloseableHttpResponse response = client.execute((HttpUriRequest)httpGet, this.httpContext);
                     InputStream inputStream = response.getEntity().getContent();){
                    if (response.getStatusLine().getStatusCode() < 400) {
                        tmpFile.getParentFile().mkdirs();
                        try (FileOutputStream fos = new FileOutputStream(tmpFile);){
                            byte[] data = new byte[2048];
                            int length = 0;
                            while ((length = inputStream.read(data, 0, data.length)) != -1) {
                                atomparser.parse(data, 0, length);
                                fos.write(data, 0, length);
                            }
                            break block35;
                        }
                    }
                    this.logger.warn("Response is {} for downloading file: {}", (Object)response.getStatusLine().getStatusCode(), (Object)url);
                }
            }
        }
        if (!tmpFile.exists()) return;
        try {
            Files.move(tmpFile.toPath(), file.toPath(), StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING);
            return;
        }
        catch (IOException e) {
            this.logger.error(e.getMessage());
        }
        return;
        catch (IOException e) {
            try {
                this.logger.error(e.getMessage());
                if (!tmpFile.exists()) return;
            }
            catch (Throwable throwable) {
                if (!tmpFile.exists()) throw throwable;
                try {
                    Files.move(tmpFile.toPath(), file.toPath(), StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING);
                    throw throwable;
                }
                catch (IOException e2) {
                    this.logger.error(e2.getMessage());
                }
                throw throwable;
            }
            try {
                Files.move(tmpFile.toPath(), file.toPath(), StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING);
                return;
            }
            catch (IOException e3) {
                this.logger.error(e3.getMessage());
            }
            return;
        }
    }

    public HLSFileDeletionManager getDeletionManager(Vertx vertx) {
        if (this.deletionManager == null) {
            this.deletionManager = new HLSFileDeletionManager(vertx);
        }
        return this.deletionManager;
    }

    public Map<String, Broadcast> getBroadcastMap() {
        return this.broadcastMap;
    }

    public Map<String, Long> getBroadcastLastSynchTime() {
        return this.broadcastLastSynchTime;
    }

    public TokenGenerator getTokenGenerator() {
        return this.tokenGenerator;
    }

    public void setTokenGenerator(TokenGenerator tokenGenerator) {
        this.tokenGenerator = tokenGenerator;
    }

    private /* synthetic */ void lambda$downloadFile$1(String url, File file, IParser atomparser, IChunkedCacheManager iChunkedCacheManager, String requestURI, Promise b) {
        try {
            this.handleHttpConnection(url, file, atomparser);
            iChunkedCacheManager.removeCache(file.getAbsolutePath());
            this.downloadInProgress.remove(requestURI);
        }
        catch (Exception e) {
            this.logger.error(ExceptionUtils.getStackTrace((Throwable)e));
        }
        b.complete();
    }
}

