/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.enterprise.cluster;

import io.vertx.core.Vertx;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.Iterator;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.tika.utils.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HLSFileDeletionManager {
    private static final int HLS_DELETE_TIMEOUT = 60000;
    protected static Logger logger = LoggerFactory.getLogger(HLSFileDeletionManager.class);
    private long taskId = -1L;
    Queue<String> downloadedFiles = new ConcurrentLinkedQueue<String>();
    private int taskPeriodMs = 30000;
    private Vertx vertx;

    public HLSFileDeletionManager(Vertx vertx) {
        this.vertx = vertx;
    }

    public void addNewFile(String requestURI) {
        if (!this.downloadedFiles.contains(requestURI)) {
            this.downloadedFiles.add(requestURI);
        }
        this.checkAndStartDeleter();
    }

    private void checkAndStartDeleter() {
        if (this.taskId == -1L) {
            this.taskId = this.getVertx().setPeriodic((long)this.taskPeriodMs, id -> {
                logger.info("checking expired downloaded files to delete");
                Iterator iterator = this.downloadedFiles.iterator();
                long now = System.currentTimeMillis();
                while (iterator.hasNext()) {
                    String requestURI = (String)iterator.next();
                    if (!this.deleteInvalidatedFile(requestURI, this.getHlsDeleteTimeout(), now)) continue;
                    iterator.remove();
                }
            });
        }
    }

    public int getHlsDeleteTimeout() {
        return 60000;
    }

    public Vertx getVertx() {
        return this.vertx;
    }

    public boolean deleteInvalidatedFile(String requestURI, int timeout, long currentTime) {
        File file = new File("webapps/" + requestURI);
        boolean deleted = false;
        if (file.exists()) {
            if (file.lastModified() + (long)timeout < currentTime) {
                try {
                    Files.deleteIfExists(file.toPath());
                }
                catch (IOException e) {
                    logger.error(ExceptionUtils.getStackTrace((Throwable)e));
                }
                deleted = true;
            }
        } else {
            deleted = true;
        }
        return deleted;
    }

    public long getTaskId() {
        return this.taskId;
    }

    public int getTaskPeriodMs() {
        return this.taskPeriodMs;
    }

    public void setTaskPeriodMs(int taskPeriodMs) {
        this.taskPeriodMs = taskPeriodMs;
    }

    public Queue<String> getDownloadedFiles() {
        return this.downloadedFiles;
    }
}

