/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.enterprise.cluster;

import com.mongodb.MongoClient;
import com.mongodb.MongoClientURI;
import com.mongodb.WriteResult;
import dev.morphia.Datastore;
import dev.morphia.Morphia;
import dev.morphia.query.FindOptions;
import dev.morphia.query.Query;
import dev.morphia.query.UpdateOperations;
import dev.morphia.query.UpdateResults;
import io.antmedia.AppSettings;
import io.antmedia.SystemUtils;
import io.antmedia.cluster.ClusterNode;
import io.antmedia.cluster.IClusterStore;
import io.antmedia.datastore.db.MongoStore;
import java.util.List;
import org.apache.tika.utils.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterStore
implements IClusterStore {
    private Morphia morphia;
    private Datastore clusterDatastore;
    private String dbHost;
    private String dbUser;
    private String dbPassword;
    protected static Logger logger = LoggerFactory.getLogger(ClusterStore.class);

    public ClusterStore(String dbHost, String dbUser, String dbPassword) {
        this(dbHost, dbUser, dbPassword, "clusterdb");
    }

    public ClusterStore(String dbHost, String dbUser, String dbPassword, String dbName) {
        this.dbHost = dbHost;
        this.dbUser = dbUser;
        this.dbPassword = dbPassword;
        String uri = MongoStore.getMongoConnectionUri((String)dbHost, (String)dbUser, (String)dbPassword);
        MongoClientURI mongoUri = new MongoClientURI(uri);
        MongoClient client = new MongoClient(mongoUri);
        this.morphia = new Morphia();
        this.morphia.map(new Class[]{ClusterNode.class, AppSettings.class});
        this.clusterDatastore = this.morphia.createDatastore(client, dbName);
        this.clusterDatastore.ensureIndexes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getNodeCount() {
        ClusterStore clusterStore = this;
        synchronized (clusterStore) {
            return this.clusterDatastore.find(ClusterNode.class).count();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ClusterNode> getClusterNodes(int offset, int size) {
        ClusterStore clusterStore = this;
        synchronized (clusterStore) {
            return this.clusterDatastore.find(ClusterNode.class).find(new FindOptions().skip(offset).limit(size)).toList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClusterNode getClusterNode(String nodeId) {
        ClusterStore clusterStore = this;
        synchronized (clusterStore) {
            return (ClusterNode)((Query)this.clusterDatastore.find(ClusterNode.class).field("id").equal((Object)nodeId)).first();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addNode(ClusterNode node) {
        ClusterStore clusterStore = this;
        synchronized (clusterStore) {
            this.clusterDatastore.save((Object)node);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateNode(String nodeId) {
        ClusterStore clusterStore = this;
        synchronized (clusterStore) {
            try {
                UpdateOperations ops;
                Query query;
                UpdateResults update;
                long usedMemory = 0L;
                if (SystemUtils.OS_TYPE == 1) {
                    usedMemory = SystemUtils.osTotalPhysicalMemory() - SystemUtils.osAvailableMemory();
                }
                boolean bl = (update = this.clusterDatastore.update(query = (Query)this.clusterDatastore.createQuery(ClusterNode.class).field("id").equal((Object)nodeId), ops = this.clusterDatastore.createUpdateOperations(ClusterNode.class).set("lastUpdateTime", (Object)System.currentTimeMillis()).set("memory", (Object)(SystemUtils.convertByteSize((Long)usedMemory, (String)"MB", (boolean)false) + "/" + SystemUtils.convertByteSize((Long)SystemUtils.osTotalPhysicalMemory(), (String)"MB", (boolean)false))).set("cpu", (Object)SystemUtils.getSystemCpuLoad()))).getUpdatedCount() == 1;
                return bl;
            }
            catch (Exception e) {
                logger.error(ExceptionUtils.getStackTrace((Throwable)e));
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteNode(String nodeId) {
        ClusterStore clusterStore = this;
        synchronized (clusterStore) {
            try {
                Query query = (Query)this.clusterDatastore.createQuery(ClusterNode.class).field("id").equal((Object)nodeId);
                WriteResult delete = this.clusterDatastore.delete(query);
                return delete.getN() == 1;
            }
            catch (Exception e) {
                logger.error(ExceptionUtils.getStackTrace((Throwable)e));
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addOrUpdate(ClusterNode node) {
        ClusterStore clusterStore = this;
        synchronized (clusterStore) {
            ClusterNode existingNode = (ClusterNode)((Query)this.clusterDatastore.find(ClusterNode.class).field("id").equal((Object)node.getId())).first();
            if (existingNode != null) {
                return this.updateNode(node.getId());
            }
            return this.addNode(node);
        }
    }

    public Datastore getClusterDatastore() {
        return this.clusterDatastore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int deleteSettings() {
        ClusterStore clusterStore = this;
        synchronized (clusterStore) {
            return this.clusterDatastore.delete(this.clusterDatastore.createQuery(AppSettings.class)).getN();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean saveSettings(AppSettings settings) {
        ClusterStore clusterStore = this;
        synchronized (clusterStore) {
            if (settings.getAppName() == null || settings.getAppName().isEmpty()) {
                logger.warn("App name is not defined so that does not save to db. App name:{}", (Object)settings.getAppName());
                return false;
            }
            Query query = (Query)this.clusterDatastore.createQuery(AppSettings.class).field("appName").equal((Object)settings.getAppName());
            WriteResult deleteResult = this.clusterDatastore.delete(query);
            if (deleteResult.getN() > 1) {
                logger.error("There is a problem in saving settings to datastore. Deleted records -> {} but it should be zero or one", (Object)deleteResult.getN());
            }
            return this.clusterDatastore.save((Object)settings) != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AppSettings getSettings(String appName) {
        ClusterStore clusterStore = this;
        synchronized (clusterStore) {
            return (AppSettings)((Query)this.clusterDatastore.find(AppSettings.class).field("appName").equal((Object)appName)).first();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<AppSettings> getAllSettings() {
        ClusterStore clusterStore = this;
        synchronized (clusterStore) {
            return this.clusterDatastore.find(AppSettings.class).find().toList();
        }
    }

    public String getDbHost() {
        return this.dbHost;
    }

    public String getDbUser() {
        return this.dbUser;
    }

    public String getDbPassword() {
        return this.dbPassword;
    }
}

