/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.enterprise.chunkedTransfer;

import io.antmedia.servlet.IChunkedCacheManager;
import io.antmedia.servlet.cmafutils.ICMAFChunkListener;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChunkedCacheManager
implements IChunkedCacheManager {
    protected static Logger logger = LoggerFactory.getLogger(ChunkedCacheManager.class);
    private Object lock = new Object();
    private Map<String, List<byte[]>> cache = new ConcurrentHashMap<String, List<byte[]>>();
    private Map<String, List<ICMAFChunkListener>> chunkListenerMap = new ConcurrentHashMap<String, List<ICMAFChunkListener>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCache(String key) {
        logger.trace("entering addCache: {}", (Object)key);
        Object object = this.lock;
        synchronized (object) {
            this.cache.put(key, new LinkedList());
            this.chunkListenerMap.put(key, new LinkedList());
        }
        logger.trace("leaving addCache: {}", (Object)key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCache(String key) {
        logger.trace("entering remove cache: {}", (Object)key);
        Object object = this.lock;
        synchronized (object) {
            this.cache.remove(key);
            List<ICMAFChunkListener> chunkListenerList = this.chunkListenerMap.get(key);
            if (chunkListenerList != null) {
                for (ICMAFChunkListener icmafChunkListener : chunkListenerList) {
                    icmafChunkListener.chunkCompleted(null);
                }
            } else {
                logger.warn("----------------------------------------------");
                logger.error("chunkListenerList is null for key: {}", (Object)key);
                logger.warn("----------------------------------------------");
            }
            this.chunkListenerMap.remove(key);
        }
        logger.trace("leaving remove cache: {}", (Object)key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void append(String key, byte[] data) {
        Object object = this.lock;
        synchronized (object) {
            this.cache.get(key).add(data);
            List<ICMAFChunkListener> chunkListenerList = this.chunkListenerMap.get(key);
            for (ICMAFChunkListener icmafChunkListener : chunkListenerList) {
                icmafChunkListener.chunkCompleted(data);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasCache(String key) {
        logger.trace("entering hasCache : {}", (Object)key);
        Object object = this.lock;
        synchronized (object) {
            return this.cache.containsKey(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerChunkListener(String key, ICMAFChunkListener icmafChunkListener) {
        logger.trace("entering registerChunkListener: {}", (Object)key);
        Object object = this.lock;
        synchronized (object) {
            List<ICMAFChunkListener> chunkListenerList = this.chunkListenerMap.get(key);
            chunkListenerList.add(icmafChunkListener);
            List<byte[]> list = this.cache.get(key);
            for (byte[] chunk : list) {
                icmafChunkListener.chunkCompleted(chunk);
            }
        }
        logger.trace("leaving registerChunkListener: {}", (Object)key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChunkListener(String key, ICMAFChunkListener icmafChunkListener) {
        logger.trace("entering removeChunkListener: {}", (Object)key);
        Object object = this.lock;
        synchronized (object) {
            List<ICMAFChunkListener> chunkListenerList = this.chunkListenerMap.get(key);
            if (chunkListenerList != null) {
                chunkListenerList.remove(icmafChunkListener);
            }
        }
        logger.trace("leaving removeChunkListener: {}", (Object)key);
    }
}

