/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.enterprise.adaptive.video;

import io.antmedia.AppSettings;
import io.antmedia.enterprise.adaptive.base.VideoEncoder;
import io.antmedia.muxer.Muxer;
import io.antmedia.webrtc.VideoCodec;
import org.bytedeco.ffmpeg.avcodec.AVCodecContext;
import org.bytedeco.ffmpeg.avcodec.AVCodecParameters;
import org.bytedeco.ffmpeg.avcodec.AVPacket;
import org.bytedeco.ffmpeg.avutil.AVDictionary;
import org.bytedeco.ffmpeg.avutil.AVFrame;
import org.bytedeco.ffmpeg.avutil.AVRational;
import org.bytedeco.ffmpeg.global.avcodec;
import org.bytedeco.ffmpeg.global.avutil;
import org.bytedeco.ffmpeg.global.swscale;
import org.bytedeco.ffmpeg.swscale.SwsContext;
import org.bytedeco.javacpp.DoublePointer;
import org.bytedeco.javacpp.IntPointer;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.PointerPointer;

public class VP8Encoder
extends VideoEncoder {
    public static final String SW_ENCODER_NAME = "libvpx";
    private static final String ERROR_ENCODER_DOES_CREATE_OUTPUT_FOR_LOW_LATENCY = "ERROR_ENCODER_DOES_CREATE_OUTPUT_FOR_LOW_LATENCY";
    private boolean lowLatencyEnabled = true;
    private long entranceTime;

    public VP8Encoder(int resolutionHeight, int bitrate, int osType, String streamId) {
        super(resolutionHeight, bitrate, streamId);
    }

    @Override
    protected void prepareCodecLocal(int width, int height, AVRational videoCodecTimebase, AVRational sampleAspectRatio, int gopSize, int streamIndex, boolean isAVC, AVCodecParameters codecpar) throws Exception {
        this.streamIndex = streamIndex;
        this.resolutionWidth = width * this.resolutionHeight / height;
        if (this.resolutionWidth % 2 == 1) {
            ++this.resolutionWidth;
        }
        this.logger.info("finding encoder for stream:{} width/height:{}/{} timebase:{}/{} sampleAspectRatio:{}/{} gopSize:{} bitrate:{}", new Object[]{this.streamId, width, height, videoCodecTimebase != null ? Integer.valueOf(videoCodecTimebase.num()) : null, videoCodecTimebase != null ? Integer.valueOf(videoCodecTimebase.den()) : null, sampleAspectRatio != null ? Integer.valueOf(sampleAspectRatio.num()) : null, sampleAspectRatio != null ? Integer.valueOf(sampleAspectRatio.den()) : null, gopSize, this.getBitrate()});
        boolean result = this.testEncoder(SW_ENCODER_NAME, this.resolutionWidth, this.resolutionHeight, videoCodecTimebase, sampleAspectRatio, gopSize, this.getBitrate());
        if (!result) {
            throw new IllegalArgumentException("Could not open video encoder for ");
        }
        this.logger.info("encoder name: {} for stream:{}", (Object)this.codec.name().getString(), (Object)this.streamId);
        this.prepareFrame();
        this.avpacket = new AVPacket();
        this.add2Muxers(streamIndex);
        this.running.set(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addMuxer(Muxer muxer) {
        Object object = this.lock;
        synchronized (object) {
            if (this.running.get()) {
                muxer.addStream(this.codec, this.videoCodecContext, this.streamIndex);
            }
            super.addMuxer(muxer);
        }
    }

    @Override
    public boolean writeFrameInternal(AVFrame frame, int streamIndex, long captureTimestampMS) throws Exception {
        this.entranceTime = System.nanoTime();
        if (!this.running.get()) {
            this.logger.warn("Encoder is not running right now for stream index {} for stream:{}", (Object)streamIndex, (Object)this.streamId);
            return false;
        }
        AVFrame tmpFrame = frame;
        if (this.isScalingRequired(frame)) {
            this.sws_ctx = swscale.sws_getCachedContext((SwsContext)this.sws_ctx, (int)frame.width(), (int)frame.height(), (int)frame.format(), (int)this.videoCodecContext.width(), (int)this.videoCodecContext.height(), (int)this.videoCodecContext.pix_fmt(), (int)2, null, null, (DoublePointer)null);
            swscale.sws_scale((SwsContext)this.sws_ctx, (PointerPointer)frame.data(), (IntPointer)frame.linesize(), (int)0, (int)frame.height(), (PointerPointer)this.picture.data(), (IntPointer)this.picture.linesize());
            this.picture.pts(frame.pts());
            tmpFrame = this.picture;
        }
        avcodec.av_init_packet((AVPacket)this.avpacket);
        this.avpacket.data(null);
        this.avpacket.size(0);
        boolean result = false;
        int[] gotOutput = new int[1];
        long t1 = System.currentTimeMillis();
        int ret = avcodec.avcodec_encode_video2((AVCodecContext)this.videoCodecContext, (AVPacket)this.avpacket, (AVFrame)tmpFrame, (int[])gotOutput);
        if (ret < 0) {
            avcodec.av_packet_unref((AVPacket)this.avpacket);
            byte[] data = new byte[2048];
            avutil.av_strerror((int)ret, (byte[])data, (long)data.length);
            if (this.logger.isErrorEnabled()) {
                this.logger.error("Cannot encode video frame for stream index {} error is {} for stream:{}", new Object[]{streamIndex, new String(data, 0, data.length), this.streamId});
            }
            return result;
        }
        if (gotOutput[0] != 0) {
            this.avpacket.stream_index(streamIndex);
            for (Muxer muxer : this.muxerList) {
                muxer.writePacket(this.avpacket, this.videoCodecContext);
            }
            result = true;
        } else {
            this.logger.warn("There is no video output at this time for stream index {} for stream:{}", (Object)streamIndex, (Object)this.streamId);
            if (this.lowLatencyEnabled && frame != null) {
                this.setError(ERROR_ENCODER_DOES_CREATE_OUTPUT_FOR_LOW_LATENCY);
            }
        }
        avcodec.av_packet_unref((AVPacket)this.avpacket);
        this.totalProcessingTime += System.nanoTime() - this.entranceTime;
        ++this.encodedPacketCount;
        return result;
    }

    public boolean testEncoder(String name, int width, int height, AVRational timeBase, AVRational sampleAspectRatio, int gopSize, int bitrate) {
        boolean result = this.getVideoCodecContext(name, width, height, timeBase, sampleAspectRatio, gopSize, 0);
        if (!result) {
            this.logger.warn("video codec context cannot be initialized for stream Id:{} width:{} height:{}", new Object[]{this.streamId, width, height});
            return false;
        }
        AVDictionary dict = new AVDictionary(null);
        avutil.av_opt_set((Pointer)this.videoCodecContext.priv_data(), (String)"crf", (String)this.appSettings.getConstantRateFactor(), (int)0);
        if (name.equals(SW_ENCODER_NAME)) {
            int targetMaxRate = bitrate * 2;
            this.videoCodecContext.rc_max_rate((long)targetMaxRate);
            this.videoCodecContext.rc_buffer_size(targetMaxRate);
        }
        this.videoCodecContext.bit_rate((long)bitrate);
        this.videoCodecContext.thread_count(this.appSettings.getVp8EncoderThreadCount());
        avutil.av_opt_set((Pointer)this.videoCodecContext.priv_data(), (String)"deadline", (String)this.appSettings.getVp8EncoderDeadline(), (int)0);
        avutil.av_opt_set((Pointer)this.videoCodecContext.priv_data(), (String)"speed", (String)("" + this.appSettings.getVp8EncoderSpeed()), (int)0);
        return this.openEncoder(dict);
    }

    @Override
    public String getCodecName() {
        return this.codecName;
    }

    public void setAppSettings(AppSettings appSettings) {
        this.appSettings = appSettings;
    }

    @Override
    public VideoCodec getCodec() {
        return VideoCodec.VP8;
    }
}

