/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.enterprise.adaptive.video;

import io.antmedia.enterprise.adaptive.IEncoderListener;
import io.antmedia.enterprise.adaptive.base.VideoEncoder;
import io.antmedia.muxer.Muxer;
import io.antmedia.webrtc.VideoCodec;
import org.bytedeco.ffmpeg.avcodec.AVCodecParameters;
import org.bytedeco.ffmpeg.avutil.AVFrame;
import org.bytedeco.ffmpeg.avutil.AVRational;

public class SFUForwarder
extends VideoEncoder {
    private IEncoderListener encoderListener;
    int codecId = -1;
    private VideoCodec videoCodec;

    public SFUForwarder(int resolutionHeight, int bitrate, IEncoderListener encoderListener, String streamId) {
        super(resolutionHeight, bitrate, streamId);
        this.encoderListener = encoderListener;
    }

    @Override
    protected void prepareCodecLocal(int sourceWidth, int sourceHeight, AVRational videoCodecTimebase, AVRational sampleAspectRatio, int gopSize, int streamIndex, boolean isAVC, AVCodecParameters codecpar) throws Exception {
        this.streamIndex = streamIndex;
        this.resolutionWidth = sourceWidth;
        this.resolutionHeight = sourceHeight;
        this.videoCodecTimebase = videoCodecTimebase;
        this.isAVC = isAVC;
        this.codecpar = codecpar;
        for (Muxer muxer : this.muxerList) {
            muxer.addVideoStream(this.resolutionWidth, this.resolutionHeight, videoCodecTimebase, this.codecId, streamIndex, isAVC, codecpar);
        }
        if (this.encoderListener != null) {
            this.encoderListener.encoderIsReady();
        }
        this.running.set(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addMuxer(Muxer muxer) {
        Object object = this.lock;
        synchronized (object) {
            if (this.running.get()) {
                muxer.addVideoStream(this.resolutionWidth, this.resolutionHeight, this.videoCodecTimebase, this.codecId, this.streamIndex, this.isAVC, this.codecpar);
            }
            super.addMuxer(muxer);
        }
    }

    @Override
    public boolean writeFrameInternal(AVFrame frame, int streamIndex, long captureTimeMS) throws Exception {
        ++this.encodedPacketCount;
        return false;
    }

    @Override
    public String getCodecName() {
        return this.getClass().getSimpleName();
    }

    public int getCodecId() {
        return this.codecId;
    }

    public void setCodecId(int codecId) {
        this.codecId = codecId;
    }

    @Override
    public VideoCodec getCodec() {
        return this.videoCodec;
    }

    public void setVideoCodec(VideoCodec codec) {
        this.videoCodec = codec;
        if (codec == VideoCodec.H264) {
            this.codecId = 27;
        } else if (codec == VideoCodec.VP8) {
            this.codecId = 139;
        } else if (codec == VideoCodec.H265) {
            this.codecId = 173;
        } else {
            this.logger.error("Unsupported codec({}) is set", (Object)codec);
        }
    }
}

