/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.enterprise.adaptive.video;

import io.antmedia.enterprise.adaptive.video.H264Encoder;
import io.antmedia.webrtc.VideoCodec;
import java.util.HashMap;
import java.util.Map;

public class H265Encoder
extends H264Encoder {
    public static final String SW_HEVC_ENCODER_NAME = "libx265";
    public static final String HW_MACOS_ENCODER_NAME = "h265_videotoolbox";
    public static final String HW_NVIDIA_HEVC_ENCODER_NAME = "hevc_nvenc";
    public static final String ERROR_ENCODER_DOES_CREATE_OUTPUT_FOR_LOW_LATENCY = "ERROR_ENCODER_DOES_CREATE_OUTPUT_FOR_LOW_LATENCY";

    public H265Encoder(int resolutionHeight, int bitrate, int osType, String streamId) {
        super(resolutionHeight, bitrate, osType, streamId);
    }

    @Override
    public Map<String, String> getOptions(String encoderName, int gopSize) {
        HashMap<String, String> options = new HashMap<String, String>();
        if (encoderName.equals(SW_HEVC_ENCODER_NAME)) {
            options.put("crf", this.appSettings.getConstantRateFactor());
            if (this.appSettings.getH265EncoderProfile() != null && !this.appSettings.getH265EncoderProfile().isEmpty()) {
                options.put("profile", this.appSettings.getH265EncoderProfile());
            } else {
                options.put("profile", "main");
            }
            if (this.appSettings.getH265EncoderPreset() != null && !this.appSettings.getH265EncoderPreset().isEmpty()) {
                options.put("preset", this.appSettings.getH265EncoderPreset());
            } else {
                options.put("preset", "veryfast");
            }
            if (this.appSettings.getH265EncoderLevel() != null && !this.appSettings.getH265EncoderLevel().isEmpty()) {
                options.put("level", this.appSettings.getH265EncoderLevel());
            }
            String encoderSpecific = "";
            if (this.appSettings.getH265EncoderSpecific() != null && !this.appSettings.getH265EncoderSpecific().isEmpty()) {
                encoderSpecific = this.appSettings.getH265EncoderSpecific();
            }
            options.put("x265-params", "keyint=" + gopSize + ":min-keyint=" + gopSize + ":" + encoderSpecific);
            options.put("tune", "zerolatency");
        } else if (encoderName.equals(HW_NVIDIA_HEVC_ENCODER_NAME)) {
            if (this.appSettings.getH265EncoderPreset() != null && !this.appSettings.getH265EncoderPreset().isEmpty()) {
                options.put("preset", this.appSettings.getH265EncoderPreset());
            } else {
                options.put("preset", "ll");
            }
            if (this.appSettings.getH265EncoderProfile() != null && !this.appSettings.getH265EncoderProfile().isEmpty()) {
                options.put("profile", this.appSettings.getH265EncoderProfile());
            } else {
                options.put("profile", "baseline");
            }
            if (this.appSettings.getH265EncoderRc() != null && !this.appSettings.getH265EncoderRc().isEmpty()) {
                options.put("rc", this.appSettings.getH265EncoderRc());
            } else {
                options.put("rc", "cbr");
            }
            if (this.appSettings.getH265EncoderLevel() != null && !this.appSettings.getH265EncoderLevel().isEmpty()) {
                options.put("level", this.appSettings.getH265EncoderLevel());
            }
            options.put("cbr", "true");
            if (this.getGpuDeviceCount() > 0) {
                options.put("gpu", "" + this.getNextGPUIndex());
            }
        }
        return options;
    }

    @Override
    public VideoCodec getCodec() {
        return VideoCodec.H265;
    }

    @Override
    public String getSoftwareCodecName() {
        return SW_HEVC_ENCODER_NAME;
    }

    @Override
    public String getHardwareCodecName() {
        return HW_NVIDIA_HEVC_ENCODER_NAME;
    }
}

