/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.enterprise.adaptive.video;

import io.antmedia.AppSettings;
import io.antmedia.enterprise.adaptive.base.VideoEncoder;
import io.antmedia.muxer.Muxer;
import io.antmedia.statistic.GPUUtils;
import io.antmedia.webrtc.VideoCodec;
import java.util.HashMap;
import java.util.Map;
import org.bytedeco.ffmpeg.avcodec.AVCodecContext;
import org.bytedeco.ffmpeg.avcodec.AVCodecParameters;
import org.bytedeco.ffmpeg.avcodec.AVPacket;
import org.bytedeco.ffmpeg.avutil.AVBufferRef;
import org.bytedeco.ffmpeg.avutil.AVDictionary;
import org.bytedeco.ffmpeg.avutil.AVFrame;
import org.bytedeco.ffmpeg.avutil.AVHWFramesContext;
import org.bytedeco.ffmpeg.avutil.AVRational;
import org.bytedeco.ffmpeg.global.avcodec;
import org.bytedeco.ffmpeg.global.avutil;
import org.bytedeco.javacpp.Pointer;

public class H264Encoder
extends VideoEncoder {
    public static final String SW_ENCODER_NAME = "libx264";
    public static final String HW_QSV_ENCODER_NAME = "h264_qsv";
    public static final String SW_LIBOPENH264_NAME = "libopenh264";
    public static final String HW_MACOS_ENCODER_NAME = "h264_videotoolbox";
    public static final String HW_NVIDIA_ENCODER_NAME = "h264_nvenc";
    protected int osType;
    private static final String ERROR_ENCODER_DOES_CREATE_OUTPUT_FOR_LOW_LATENCY = "ERROR_ENCODER_DOES_CREATE_OUTPUT_FOR_LOW_LATENCY";
    private long entranceTime;
    private static int gpuIndex = -1;
    private int gpuDeviceCount;
    private AVBufferRef hardwareDeviceContext;
    private AVBufferRef hardwareFramesReference;
    public static final String USE_ONLY_GPU = "only_gpu";
    public static final String USE_GPU_AND_CPU = "gpu_and_cpu";
    private static final Object gpuIndexLock = new Object();

    public H264Encoder(int resolutionHeight, int bitrate, int osType, String streamId) {
        super(resolutionHeight, bitrate, streamId);
        this.osType = osType;
        this.setGpuDeviceCount(GPUUtils.getInstance().getDeviceCount());
    }

    public void calculateAspectRatioResolution(int sourceWidth, int sourceHeight) {
        int initialHeight = this.resolutionHeight;
        int initialWidth = sourceWidth * this.resolutionHeight / sourceHeight;
        float widthFloat = sourceWidth;
        float heightFloat = sourceHeight;
        float resolutionWidthFloat = widthFloat / heightFloat * (float)this.resolutionHeight;
        while (resolutionWidthFloat != (float)Math.round(resolutionWidthFloat) || Math.round(resolutionWidthFloat) % 2 != 0) {
            --this.resolutionHeight;
            if (this.resolutionHeight % 2 == 1) continue;
            resolutionWidthFloat = widthFloat / heightFloat * (float)this.resolutionHeight;
        }
        this.resolutionWidth = (int)resolutionWidthFloat;
        if (Math.abs(initialHeight - this.resolutionHeight) > 50 || Math.abs(initialWidth - this.resolutionWidth) > 50) {
            this.resolutionWidth = initialWidth;
            this.resolutionHeight = initialHeight;
        }
        if (this.resolutionWidth % 2 == 1) {
            ++this.resolutionWidth;
        }
    }

    @Override
    protected void prepareCodecLocal(int width, int height, AVRational videoCodecTimebase, AVRational sampleAspectRatio, int gopSize, int streamIndex, boolean isAVC, AVCodecParameters codecpar) throws Exception {
        this.streamIndex = streamIndex;
        this.logger.info("incoming widthxheight:{}x{}", (Object)width, (Object)height);
        if (this.appSettings.isForceAspectRatioInTranscoding()) {
            this.calculateAspectRatioResolution(width, height);
        } else {
            this.resolutionWidth = width * this.resolutionHeight / height;
            if (this.resolutionWidth % 2 == 1) {
                ++this.resolutionWidth;
            }
        }
        boolean result = this.findEncoder(this.resolutionWidth, this.resolutionHeight, videoCodecTimebase, sampleAspectRatio, gopSize, this.getBitrate());
        if (!result) {
            throw new IllegalArgumentException("Could not open video encoder for ");
        }
        this.prepareFrame();
        this.avpacket = new AVPacket();
        this.add2Muxers(streamIndex);
        this.running.set(true);
    }

    @Override
    public boolean writeFrameInternal(AVFrame frame, int streamIndex, long captureTimestampMS) throws Exception {
        this.entranceTime = System.nanoTime();
        if (!this.running.get()) {
            this.logger.warn("Encoder is not running right now for stream index {} for stream:{}", (Object)streamIndex, (Object)this.streamId);
            return false;
        }
        AVFrame tmpFrame = this.scaleVideoIfRequrired(frame);
        this.initPacket();
        boolean result = false;
        int ret = this.sendPacket2Encoder(streamIndex, tmpFrame);
        this.totalVideoEncoderTime += System.currentTimeMillis() - captureTimestampMS;
        this.totalProcessingTime += System.nanoTime() - this.entranceTime;
        if (ret >= 0) {
            result = this.receiveAndWritePacket(streamIndex);
        }
        if (!result) {
            this.logger.warn("There is no video output at this time for stream index {} for stream:{}", (Object)streamIndex, (Object)this.streamId);
            if (frame != null) {
                this.setError(ERROR_ENCODER_DOES_CREATE_OUTPUT_FOR_LOW_LATENCY);
            }
        }
        avcodec.av_packet_unref((AVPacket)this.avpacket);
        ++this.encodedPacketCount;
        return result;
    }

    public boolean findEncoder(int width, int height, AVRational timeBase, AVRational sampleAspectRatio, int gopSize, int bitrate) {
        String encoderName = null;
        this.logger.info("finding encoder for stream:{} width/height:{}/{} timebase:{}/{} sampleAspectRatio:{}/{} gopSize:{} bitrate:{}", new Object[]{this.streamId, width, height, timeBase != null ? Integer.valueOf(timeBase.num()) : null, timeBase != null ? Integer.valueOf(timeBase.den()) : null, sampleAspectRatio != null ? Integer.valueOf(sampleAspectRatio.num()) : null, sampleAspectRatio != null ? Integer.valueOf(sampleAspectRatio.den()) : null, gopSize, bitrate});
        if (this.appSettings.getEncoderName() != null && !this.appSettings.getEncoderName().isEmpty()) {
            encoderName = this.appSettings.getEncoderName();
        }
        if (encoderName == null && this.getGpuDeviceCount() > 0 && (this.osType == 1 || this.osType == 2)) {
            encoderName = HW_NVIDIA_ENCODER_NAME;
        } else if (this.osType == 0) {
            // empty if block
        }
        boolean result = false;
        if (encoderName != null) {
            result = this.testEncoder(encoderName, width, height, timeBase, sampleAspectRatio, gopSize, bitrate);
        }
        if (!result) {
            if (!USE_ONLY_GPU.equals(this.appSettings.getEncoderSelectionPreference())) {
                result = this.testEncoder(this.getSoftwareCodecName(), width, height, timeBase, sampleAspectRatio, gopSize, bitrate);
            } else {
                this.logger.info("Software encoder is not being tried to open because setting is only use GPU for stream:{} ", (Object)this.streamId);
            }
        }
        if (result) {
            this.logger.info("encoder name: {} for stream:{}", (Object)this.codec.name().getString(), (Object)this.streamId);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addMuxer(Muxer muxer) {
        Object object = this.lock;
        synchronized (object) {
            if (this.running.get()) {
                muxer.addStream(this.codec, this.videoCodecContext, this.streamIndex);
            }
            super.addMuxer(muxer);
        }
    }

    public boolean testEncoder(String name, int width, int height, AVRational timeBase, AVRational sampleAspectRatio, int gopSize, int bitrate) {
        boolean result = this.getVideoCodecContext(name, width, height, timeBase, sampleAspectRatio, gopSize);
        if (!result) {
            this.logger.warn("video codec context cannot be initialized for stream Id:{} width:{} height:{}", new Object[]{this.streamId, width, height});
            return false;
        }
        this.videoCodecContext.profile(578);
        AVDictionary dict = new AVDictionary(null);
        Map<String, String> options = this.getOptions(name, gopSize);
        if (name.equals(this.getSoftwareCodecName())) {
            int targetMaxRate = bitrate;
            this.videoCodecContext.rc_max_rate((long)targetMaxRate);
            this.videoCodecContext.rc_buffer_size(targetMaxRate);
            this.videoCodecContext.thread_count(this.appSettings.getEncoderThreadCount());
            this.videoCodecContext.thread_type(this.appSettings.getEncoderThreadType());
        }
        this.videoCodecContext.bit_rate((long)bitrate);
        this.videoCodecContext.strict_std_compliance(0);
        if (options != null) {
            for (Map.Entry<String, String> entry : options.entrySet()) {
                avutil.av_opt_set((Pointer)this.videoCodecContext.priv_data(), (String)entry.getKey(), (String)entry.getValue(), (int)0);
            }
        }
        this.videoCodecContext.flags(this.videoCodecContext.flags() | 0x400000);
        return this.openEncoder(dict);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNextGPUIndex() {
        Object object = gpuIndexLock;
        synchronized (object) {
            gpuIndex = (gpuIndex + 1) % this.getGpuDeviceCount();
        }
        return gpuIndex;
    }

    @Override
    public String getCodecName() {
        return this.codecName;
    }

    public int getGpuDeviceCount() {
        return this.gpuDeviceCount;
    }

    public void setGpuDeviceCount(int gpuDeviceCount) {
        this.gpuDeviceCount = gpuDeviceCount;
    }

    public void setAppSettings(AppSettings appSettings) {
        this.appSettings = appSettings;
    }

    public Map<String, String> getOptions(String encoderName, int gopSize) {
        HashMap<String, String> options = new HashMap<String, String>();
        if (encoderName.equals(this.getSoftwareCodecName())) {
            options.put("crf", this.appSettings.getConstantRateFactor());
            if (this.appSettings.getEncoderPreset() != null && !this.appSettings.getEncoderPreset().isEmpty()) {
                options.put("preset", this.appSettings.getEncoderPreset());
            } else {
                options.put("preset", "faster");
            }
            if (this.appSettings.getEncoderLevel() != null && !this.appSettings.getEncoderLevel().isEmpty()) {
                options.put("level", this.appSettings.getEncoderLevel());
            }
            if (this.appSettings.getEncoderSpecific() != null && !this.appSettings.getEncoderSpecific().isEmpty()) {
                options.put("x264-params", this.appSettings.getEncoderSpecific());
            }
            options.put("tune", "zerolatency");
        } else if (encoderName.equals(this.getHardwareCodecName())) {
            if (this.appSettings.getEncoderPreset() != null && !this.appSettings.getEncoderPreset().isEmpty()) {
                options.put("preset", this.appSettings.getEncoderPreset());
            } else {
                options.put("preset", "ll");
            }
            if (this.appSettings.getEncoderRc() != null && !this.appSettings.getEncoderRc().isEmpty()) {
                options.put("rc", this.appSettings.getEncoderRc());
            } else {
                options.put("rc", "cbr");
            }
            if (this.appSettings.getEncoderLevel() != null && !this.appSettings.getEncoderLevel().isEmpty()) {
                options.put("level", this.appSettings.getEncoderLevel());
            }
            options.put("cbr", "true");
            if (this.getGpuDeviceCount() > 0) {
                options.put("gpu", "" + this.getNextGPUIndex());
            }
        } else if (SW_LIBOPENH264_NAME.equals(encoderName)) {
            options.put("rc_mode", "bitrate");
            options.put("profile", "constrained_baseline");
        } else if (HW_QSV_ENCODER_NAME.equals(encoderName)) {
            if (this.appSettings.getEncoderPreset() != null && !this.appSettings.getEncoderPreset().isEmpty()) {
                options.put("preset", this.appSettings.getEncoderPreset());
            } else {
                options.put("preset", "medium");
            }
        }
        if (this.appSettings.getEncoderProfile() != null && !this.appSettings.getEncoderProfile().isEmpty()) {
            options.put("profile", this.appSettings.getEncoderProfile());
        } else {
            options.put("profile", "baseline");
        }
        return options;
    }

    public static int getGpuIndex() {
        return gpuIndex;
    }

    @Override
    public VideoCodec getCodec() {
        return VideoCodec.H264;
    }

    public String getSoftwareCodecName() {
        return SW_ENCODER_NAME;
    }

    public String getHardwareCodecName() {
        return HW_NVIDIA_ENCODER_NAME;
    }

    @Override
    public int getTargetPixelFormat() {
        if (HW_QSV_ENCODER_NAME.equals(this.codecName)) {
            return 23;
        }
        return super.getTargetPixelFormat();
    }

    public boolean getVideoCodecContext(String name, int width, int height, AVRational timeBase, AVRational sampleAspectRatio, int gopSize) {
        int pixelFormat = 0;
        if (HW_QSV_ENCODER_NAME.equals(name)) {
            pixelFormat = 116;
        }
        boolean contextCreated = this.getVideoCodecContext(name, width, height, timeBase, sampleAspectRatio, gopSize, pixelFormat);
        boolean hardwareInitialized = true;
        if (contextCreated && HW_QSV_ENCODER_NAME.equals(name)) {
            hardwareInitialized = false;
            if (this.createHardwareDevice()) {
                this.hardwareFramesReference = avutil.av_hwframe_ctx_alloc((AVBufferRef)this.hardwareDeviceContext);
                if (this.initHardwareFrameContext(this.hardwareFramesReference, width, height)) {
                    this.videoCodecContext.hw_frames_ctx(avutil.av_buffer_ref((AVBufferRef)this.hardwareFramesReference));
                    hardwareInitialized = true;
                }
                avutil.av_buffer_unref((AVBufferRef)this.hardwareFramesReference);
            }
        }
        return contextCreated && hardwareInitialized;
    }

    public boolean createHardwareDevice() {
        this.hardwareDeviceContext = new AVBufferRef();
        int result = this.avHwDeviceCtxCreate(this.hardwareDeviceContext);
        if (result < 0) {
            this.logger.error("Failed to create a QSV device. Error code: {}", (Object)this.getErrorDefinition(result));
            this.hardwareDeviceContext = null;
            return false;
        }
        return true;
    }

    public int avHwDeviceCtxCreate(AVBufferRef bufferReference) {
        return avutil.av_hwdevice_ctx_create((AVBufferRef)bufferReference, (int)5, (String)"auto", null, (int)0);
    }

    public boolean initHardwareFrameContext(AVBufferRef frameReference, int width, int height) {
        AVHWFramesContext framesContext = new AVHWFramesContext((Pointer)frameReference.data());
        framesContext.format(116);
        framesContext.sw_format(23);
        framesContext.width(width);
        framesContext.height(height);
        framesContext.initial_pool_size(32);
        int err = 0;
        err = this.avHWFrameCtxInit(frameReference);
        if (err < 0) {
            this.logger.error("Failed to initialize QSV frame context Error code: {}", (Object)this.getErrorDefinition(err));
            return false;
        }
        return true;
    }

    public int avHWFrameCtxInit(AVBufferRef frameReference) {
        return avutil.av_hwframe_ctx_init((AVBufferRef)frameReference);
    }

    @Override
    public void writeTrailer() {
        super.writeTrailer();
        if (this.hardwareDeviceContext != null) {
            avutil.av_buffer_unref((AVBufferRef)this.hardwareDeviceContext);
            this.hardwareDeviceContext = null;
        }
    }

    @Override
    public int sendPacket2Encoder(int streamIndex, AVFrame tmpFrame) {
        int ret;
        AVFrame hardwareFrame = null;
        if (HW_QSV_ENCODER_NAME.equals(this.codecName) && tmpFrame != null) {
            tmpFrame = hardwareFrame = this.getHardwareFrame(tmpFrame);
        }
        if ((ret = this.avCodecSendFrame(tmpFrame)) < 0) {
            this.logger.error("Cannot encode video frame for stream index {} error is {} for stream:{}", new Object[]{streamIndex, this.getErrorDefinition(ret), this.streamId});
        }
        this.freeFrame(hardwareFrame);
        return ret;
    }

    public int avCodecSendFrame(AVFrame frame) {
        return avcodec.avcodec_send_frame((AVCodecContext)this.videoCodecContext, (AVFrame)frame);
    }

    public void freeFrame(AVFrame frame) {
        if (frame != null) {
            avutil.av_frame_free((AVFrame)frame);
        }
    }

    public AVFrame getHardwareFrame(AVFrame tmpFrame) {
        AVFrame hardwareFrame = avutil.av_frame_alloc();
        int err = this.avHWFrameGetBuffer(hardwareFrame);
        if (err < 0) {
            this.logger.info("Cannot get av_hwframe_get_buffer. Error is {} for stream:{} ", (Object)this.getErrorDefinition(err), (Object)this.streamId);
            return null;
        }
        err = this.avHwFrameTransferData(hardwareFrame, tmpFrame);
        if (err < 0) {
            this.logger.info("Error while transferring frame data to surface Error code: {} ", (Object)this.getErrorDefinition(err));
            return null;
        }
        hardwareFrame.pts(tmpFrame.pts());
        return hardwareFrame;
    }

    public int avHWFrameGetBuffer(AVFrame frame) {
        return avutil.av_hwframe_get_buffer((AVBufferRef)this.videoCodecContext.hw_frames_ctx(), (AVFrame)frame, (int)0);
    }

    public int avHwFrameTransferData(AVFrame hardwareFrame, AVFrame tmpFrame) {
        return avutil.av_hwframe_transfer_data((AVFrame)hardwareFrame, (AVFrame)tmpFrame, (int)0);
    }
}

