/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.enterprise.adaptive.base;

import io.antmedia.AppSettings;
import io.antmedia.enterprise.adaptive.base.Encoder;
import io.antmedia.muxer.Muxer;
import io.antmedia.webrtc.VideoCodec;
import java.nio.ByteBuffer;
import org.bytedeco.ffmpeg.avcodec.AVCodec;
import org.bytedeco.ffmpeg.avcodec.AVCodecContext;
import org.bytedeco.ffmpeg.avcodec.AVCodecParameters;
import org.bytedeco.ffmpeg.avcodec.AVPacket;
import org.bytedeco.ffmpeg.avutil.AVDictionary;
import org.bytedeco.ffmpeg.avutil.AVFrame;
import org.bytedeco.ffmpeg.avutil.AVRational;
import org.bytedeco.ffmpeg.global.avcodec;
import org.bytedeco.ffmpeg.global.avutil;
import org.bytedeco.ffmpeg.global.swscale;
import org.bytedeco.ffmpeg.swscale.SwsContext;
import org.bytedeco.javacpp.BytePointer;
import org.bytedeco.javacpp.DoublePointer;
import org.bytedeco.javacpp.IntPointer;
import org.bytedeco.javacpp.PointerPointer;

public abstract class VideoEncoder
extends Encoder {
    protected int resolutionHeight;
    protected int resolutionWidth;
    protected AVCodecContext videoCodecContext = null;
    protected SwsContext sws_ctx = null;
    protected AVCodec codec = null;
    protected BytePointer picture_bufptr;
    protected AVFrame picture;
    private String error;
    protected AVPacket avpacket;
    protected int sourceWidth;
    protected int sourceHeight;
    protected AVRational videoCodecTimebase;
    protected AVRational sampleAspectRatio;
    protected int gopSize;
    protected int streamIndex;
    protected boolean isAVC;
    protected AVCodecParameters codecpar;
    protected long totalVideoEncoderTime;
    private long totalVideoEncodeQueueTime;
    protected AppSettings appSettings;
    protected String codecName;

    public VideoEncoder(int resolutionHeight, int bitrate, String streamId) {
        super(bitrate, streamId);
        this.resolutionHeight = resolutionHeight;
    }

    public int getTargetPixelFormat() {
        return this.videoCodecContext.pix_fmt();
    }

    public boolean isScalingRequired(AVFrame frame) {
        return frame != null && (frame.width() != this.videoCodecContext.width() || frame.height() != this.videoCodecContext.height() || frame.format() != this.getTargetPixelFormat());
    }

    public void prepareFrame() {
        this.picture = avutil.av_frame_alloc();
        int size = avutil.av_image_get_buffer_size((int)this.getTargetPixelFormat(), (int)this.videoCodecContext.width(), (int)this.videoCodecContext.height(), (int)32);
        this.picture_bufptr = new BytePointer((long)size);
        avutil.av_image_fill_arrays((PointerPointer)this.picture.data(), (IntPointer)this.picture.linesize(), (BytePointer)this.picture_bufptr, (int)this.getTargetPixelFormat(), (int)this.videoCodecContext.width(), (int)this.videoCodecContext.height(), (int)32);
        this.picture.format(this.getTargetPixelFormat());
        this.picture.width(this.videoCodecContext.width());
        this.picture.height(this.videoCodecContext.height());
    }

    public AVCodecParameters getCodecParameters() {
        AVCodecParameters codecParameter = new AVCodecParameters();
        int ret = avcodec.avcodec_parameters_from_context((AVCodecParameters)codecParameter, (AVCodecContext)this.videoCodecContext);
        if (ret < 0) {
            this.logger.warn("Cannot get codec parameters for stream: {}", (Object)this.streamId);
        }
        return codecParameter;
    }

    public void add2Muxers(int streamIndex) {
        for (Muxer muxer : this.muxerList) {
            muxer.addStream(this.codec, this.videoCodecContext, streamIndex);
        }
    }

    public boolean receiveAndWritePacket(int streamIndex) {
        int ret = 0;
        boolean result = false;
        while (ret >= 0) {
            ret = avcodec.avcodec_receive_packet((AVCodecContext)this.videoCodecContext, (AVPacket)this.avpacket);
            if (ret < 0) continue;
            this.avpacket.stream_index(streamIndex);
            for (Muxer muxer : this.muxerList) {
                muxer.writePacket(this.avpacket, this.videoCodecContext);
            }
            result = true;
        }
        return result;
    }

    public void initPacket() {
        avcodec.av_init_packet((AVPacket)this.avpacket);
        this.avpacket.data(null);
        this.avpacket.size(0);
    }

    public int sendPacket2Encoder(int streamIndex, AVFrame tmpFrame) {
        int ret = avcodec.avcodec_send_frame((AVCodecContext)this.videoCodecContext, (AVFrame)tmpFrame);
        if (ret < 0) {
            if (this.logger.isErrorEnabled()) {
                this.logger.error("Cannot encode video frame for stream index {} error is {} for stream:{}", new Object[]{streamIndex, this.getErrorDefinition(ret), this.streamId});
            }
            return ret;
        }
        return ret;
    }

    public String getErrorDefinition(int errorCode) {
        byte[] data = new byte[128];
        avutil.av_strerror((int)errorCode, (byte[])data, (long)data.length);
        return new String(data, 0, data.length);
    }

    public AVFrame scaleVideoIfRequrired(AVFrame frame) {
        if (this.isScalingRequired(frame)) {
            this.sws_ctx = swscale.sws_getCachedContext((SwsContext)this.sws_ctx, (int)frame.width(), (int)frame.height(), (int)frame.format(), (int)this.videoCodecContext.width(), (int)this.videoCodecContext.height(), (int)this.getTargetPixelFormat(), (int)262146, null, null, (DoublePointer)null);
            swscale.sws_scale((SwsContext)this.sws_ctx, (PointerPointer)frame.data(), (IntPointer)frame.linesize(), (int)0, (int)frame.height(), (PointerPointer)this.picture.data(), (IntPointer)this.picture.linesize());
            this.picture.pts(frame.pts());
            return this.picture;
        }
        return frame;
    }

    public boolean openEncoder(AVDictionary dict) {
        int ret = avcodec.avcodec_open2((AVCodecContext)this.videoCodecContext, (AVCodec)this.codec, (AVDictionary)dict);
        if (ret < 0) {
            avcodec.avcodec_free_context((AVCodecContext)this.videoCodecContext);
            this.logger.warn("quick native video codec({}) cannot be opened for stream id:{}", (Object)this.codecName, (Object)this.streamId);
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("Codec cannot be opened for {} reason: {} for stream:{}", new Object[]{this.codecName, this.getErrorDefinition(ret), this.streamId});
            }
            this.videoCodecContext = null;
        } else {
            this.logger.info("Video codec opened. Context gop size: {}  keyint mint {} extradata size: {} video codec timebase: {}/{}  codecName: {} for stream: {}", new Object[]{this.videoCodecContext.gop_size(), this.videoCodecContext.keyint_min(), this.videoCodecContext.extradata_size(), this.videoCodecContext.time_base().num(), this.videoCodecContext.time_base().den(), this.codecName, this.streamId});
        }
        avutil.av_dict_free((AVDictionary)dict);
        return ret == 0;
    }

    public boolean getVideoCodecContext(String name, int width, int height, AVRational timeBase, AVRational sampleAspectRatio, int gopSize, int pixelFormat) {
        this.codec = avcodec.avcodec_find_encoder_by_name((String)name);
        if (this.codec == null) {
            this.logger.error("codec({}) cannot be find for stream:{} ", (Object)name, (Object)this.streamId);
            return false;
        }
        this.codecName = this.codec.name().getString();
        this.videoCodecContext = avcodec.avcodec_alloc_context3((AVCodec)this.codec);
        if (this.videoCodecContext == null) {
            this.logger.info("Video codec context ({}) cannot be allocated for stream:{}", (Object)name, (Object)this.streamId);
            return false;
        }
        this.videoCodecContext.width(width);
        this.videoCodecContext.height(height);
        this.videoCodecContext.time_base(timeBase);
        this.videoCodecContext.pix_fmt(pixelFormat);
        this.videoCodecContext.sample_aspect_ratio(sampleAspectRatio);
        if (this.appSettings.getGopSize() != 0) {
            this.videoCodecContext.gop_size(this.appSettings.getGopSize());
        } else {
            if (gopSize > 100) {
                gopSize = 100;
            } else if (gopSize <= 0) {
                gopSize = 60;
            }
            this.videoCodecContext.gop_size(gopSize);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepareCodec(int sourceWidth, int sourceHeight, AVRational videoCodecTimebase, AVRational sampleAspectRatio, int gopSize, int streamIndex, boolean isAVC, AVCodecParameters codecpar) throws Exception {
        Object object = this.lock;
        synchronized (object) {
            if (this.isStopped.get()) {
                this.logger.info("Codec is stopped before it's prepared for stream:{}", (Object)this.streamId);
                return;
            }
            this.prepareCodecLocal(sourceWidth, sourceHeight, videoCodecTimebase, sampleAspectRatio, gopSize, streamIndex, isAVC, codecpar);
        }
    }

    protected abstract void prepareCodecLocal(int var1, int var2, AVRational var3, AVRational var4, int var5, int var6, boolean var7, AVCodecParameters var8) throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean writeFrame(AVFrame frame, int streamIndex, long captureTimestampMS) throws Exception {
        Object object = this.lock;
        synchronized (object) {
            this.totalVideoEncodeQueueTime += System.currentTimeMillis() - captureTimestampMS;
            return this.writeFrameInternal(frame, streamIndex, captureTimestampMS);
        }
    }

    public abstract boolean writeFrameInternal(AVFrame var1, int var2, long var3) throws Exception;

    protected void freeEncoderRelatedResources() {
        if (this.videoCodecContext != null) {
            avcodec.avcodec_free_context((AVCodecContext)this.videoCodecContext);
            this.videoCodecContext.close();
            this.videoCodecContext = null;
        }
        if (this.sws_ctx != null) {
            swscale.sws_freeContext((SwsContext)this.sws_ctx);
            this.sws_ctx.close();
            this.sws_ctx = null;
        }
        if (this.picture_bufptr != null) {
            this.picture_bufptr.close();
            this.picture_bufptr = null;
        }
        if (this.picture != null) {
            avutil.av_frame_free((AVFrame)this.picture);
            this.picture.close();
            this.picture = null;
        }
        if (this.avpacket != null) {
            this.avpacket.close();
            this.avpacket = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeTrailer() {
        this.isStopped.set(true);
        Object object = this.lock;
        synchronized (object) {
            this.running.set(false);
            for (Muxer muxer : this.muxerList) {
                muxer.writeTrailer();
            }
            this.freeEncoderRelatedResources();
            this.logger.info("Video codec writing trailer name: {} height:{} for stream:{}", new Object[]{this.getCodecName(), this.getResolutionHeight(), this.streamId});
            if (this.encodedPacketCount > 0L) {
                long avarageProcessing = this.totalProcessingTime / this.encodedPacketCount;
                this.logger.info("Total processing time {} ms Average processing time {} ms per frame for stream:{}", new Object[]{(int)((double)this.totalProcessingTime / 1000000.0), (int)((double)avarageProcessing / 1000000.0), this.streamId});
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeVideoBuffer(ByteBuffer encodedVideoFrame, long dts, int frameRotation, int streamIndex, boolean isKeyFrame, long firstFrameTimeStamp, long pts) {
        Object object = this.lock;
        synchronized (object) {
            for (Muxer muxer : this.muxerList) {
                muxer.writeVideoBuffer(encodedVideoFrame, dts, frameRotation, streamIndex, isKeyFrame, firstFrameTimeStamp, pts);
            }
        }
    }

    public int getResolutionWidth() {
        return this.resolutionWidth;
    }

    public int getResolutionHeight() {
        return this.resolutionHeight;
    }

    public AVRational getTimebase() {
        if (this.videoCodecContext != null) {
            return this.videoCodecContext.time_base();
        }
        return null;
    }

    public String getError() {
        return this.error;
    }

    public void setError(String error) {
        this.error = error;
    }

    public long getTotalVideoEncoderTime() {
        return this.totalVideoEncoderTime;
    }

    public long getTotalVideoEncodeQueueTime() {
        return this.totalVideoEncodeQueueTime;
    }

    public void setCodecName(String codecName) {
        this.codecName = codecName;
    }

    public abstract VideoCodec getCodec();
}

