/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.enterprise.adaptive.base;

import io.antmedia.muxer.Muxer;
import io.antmedia.muxer.RtmpMuxer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.bytedeco.ffmpeg.avutil.AVFrame;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Encoder {
    protected List<Muxer> muxerList = new ArrayList<Muxer>();
    protected long totalProcessingTime = 0L;
    protected long encodedPacketCount = 0L;
    protected AtomicBoolean isStopped = new AtomicBoolean(false);
    protected AtomicBoolean running = new AtomicBoolean(false);
    private int bitrate;
    protected Logger logger;
    protected String streamId;
    protected Object lock = new Object();

    public Encoder(int bitrate, String streamId) {
        this.bitrate = bitrate;
        this.logger = LoggerFactory.getLogger(this.getClass());
        this.streamId = streamId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMuxer(Muxer m) {
        Object object = this.lock;
        synchronized (object) {
            this.muxerList.add(m);
        }
    }

    public List<Muxer> getMuxerList() {
        return this.muxerList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepareIO() {
        Object object = this.lock;
        synchronized (object) {
            for (Muxer muxer : this.muxerList) {
                muxer.prepareIO();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeMuxer(Muxer m) {
        Object object = this.lock;
        synchronized (object) {
            return this.muxerList.remove(m);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RtmpMuxer getRtmpMuxer(String rtmpUrl) {
        Object object = this.lock;
        synchronized (object) {
            for (Muxer muxer : this.muxerList) {
                if (!(muxer instanceof RtmpMuxer) || !((RtmpMuxer)muxer).getURL().equals(rtmpUrl)) continue;
                return (RtmpMuxer)muxer;
            }
        }
        return null;
    }

    public abstract void writeTrailer();

    public abstract boolean writeFrame(AVFrame var1, int var2, long var3) throws Exception;

    public abstract String getCodecName();

    public int getBitrate() {
        return this.bitrate;
    }

    public void setBitrate(int bitrate) {
        this.bitrate = bitrate;
    }

    public long getEncodedPacketCount() {
        return this.encodedPacketCount;
    }

    public long getTotalProcessingTime() {
        return this.totalProcessingTime;
    }

    public boolean isRunning() {
        return this.running.get();
    }
}

