/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.enterprise.adaptive.base;

import io.antmedia.enterprise.adaptive.base.Encoder;
import io.antmedia.muxer.Muxer;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import org.bytedeco.ffmpeg.avcodec.AVCodec;
import org.bytedeco.ffmpeg.avcodec.AVCodecContext;
import org.bytedeco.ffmpeg.avcodec.AVPacket;
import org.bytedeco.ffmpeg.avutil.AVFrame;
import org.bytedeco.ffmpeg.avutil.AVRational;
import org.bytedeco.ffmpeg.global.avcodec;
import org.bytedeco.ffmpeg.global.avutil;
import org.bytedeco.ffmpeg.global.swresample;
import org.bytedeco.ffmpeg.swresample.SwrContext;
import org.bytedeco.javacpp.BytePointer;
import org.bytedeco.javacpp.DoublePointer;
import org.bytedeco.javacpp.FloatPointer;
import org.bytedeco.javacpp.IntPointer;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.PointerPointer;
import org.bytedeco.javacpp.ShortPointer;

public abstract class AudioEncoder
extends Encoder {
    protected Pointer[] samplesIn;
    protected PointerPointer samplesInPtr;
    protected BytePointer[] samplesOut;
    protected SwrContext samplesConvertCtx = null;
    protected int samplesChannels = -1;
    protected int samplesFormat = -1;
    protected int samplesRate = -1;
    protected PointerPointer samplesOutPtr;
    protected AVFrame outputFrame;
    protected AVCodec audioCodec;
    protected AVCodecContext audioCodecContext;
    protected AVPacket avpacket;
    long pts = 0L;
    private long tmpTimestampMS;
    private long totalResamplingTime;
    private long entranceTime;

    public AudioEncoder(int bitrate, String streamId) {
        super(bitrate, streamId);
    }

    public int getSampleRate() {
        if (this.audioCodecContext != null) {
            return this.audioCodecContext.sample_rate();
        }
        this.logger.error("Audio codec is not initialized. Call prepareCodec first. HashCode:{}", (Object)this.hashCode());
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepareCodec(int sampleRate, int channelLayout, int streamIndex) throws Exception {
        if (this.isStopped.get()) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            this.prepareCodecLocal(sampleRate, channelLayout, streamIndex);
        }
    }

    protected abstract void prepareCodecLocal(int var1, int var2, int var3) throws Exception;

    private boolean resampleAndEncode(long framePTS, int audioChannels, int sampleRate, int streamIndex, AVCodecContext audioContext, Buffer[] samples, long timestampMS) throws Exception {
        int ret;
        Buffer b;
        int i;
        boolean result = false;
        int inputSize = samples != null ? samples[0].limit() - samples[0].position() : 0;
        int inputFormat = -1;
        int inputChannels = samples != null && samples.length > 1 ? 1 : audioChannels;
        int inputDepth = 0;
        int outputFormat = audioContext.sample_fmt();
        int outputChannels = this.samplesOut.length > 1 ? 1 : audioContext.channels();
        int outputDepth = avutil.av_get_bytes_per_sample((int)outputFormat);
        if (this.tmpTimestampMS == 0L) {
            this.tmpTimestampMS = timestampMS;
        }
        if (samples != null && samples[0] instanceof ByteBuffer) {
            inputFormat = samples.length > 1 ? 5 : 0;
            inputDepth = 1;
            for (i = 0; i < samples.length; ++i) {
                b = (ByteBuffer)samples[i];
                if (this.samplesIn[i] instanceof BytePointer && this.samplesIn[i].capacity() >= (long)inputSize && ((ByteBuffer)b).hasArray()) {
                    ((BytePointer)this.samplesIn[i]).position(0L).put(((ByteBuffer)b).array(), b.position(), inputSize);
                    continue;
                }
                this.samplesIn[i] = new BytePointer((ByteBuffer)b);
            }
        } else if (samples != null && samples[0] instanceof ShortBuffer) {
            inputFormat = samples.length > 1 ? 6 : 1;
            inputDepth = 2;
            for (i = 0; i < samples.length; ++i) {
                b = (ShortBuffer)samples[i];
                if (this.samplesIn[i] instanceof ShortPointer && this.samplesIn[i].capacity() >= (long)inputSize && ((ShortBuffer)b).hasArray()) {
                    ((ShortPointer)this.samplesIn[i]).position(0L).put(((ShortBuffer)b).array(), samples[i].position(), inputSize);
                    continue;
                }
                this.samplesIn[i] = new ShortPointer((ShortBuffer)b);
            }
        } else if (samples != null && samples[0] instanceof IntBuffer) {
            inputFormat = samples.length > 1 ? 7 : 2;
            inputDepth = 4;
            for (i = 0; i < samples.length; ++i) {
                b = (IntBuffer)samples[i];
                if (this.samplesIn[i] instanceof IntPointer && this.samplesIn[i].capacity() >= (long)inputSize && ((IntBuffer)b).hasArray()) {
                    ((IntPointer)this.samplesIn[i]).position(0L).put(((IntBuffer)b).array(), samples[i].position(), inputSize);
                    continue;
                }
                this.samplesIn[i] = new IntPointer((IntBuffer)b);
            }
        } else if (samples != null && samples[0] instanceof FloatBuffer) {
            inputFormat = samples.length > 1 ? 8 : 3;
            inputDepth = 4;
            for (i = 0; i < samples.length; ++i) {
                b = (FloatBuffer)samples[i];
                if (this.samplesIn[i] instanceof FloatPointer && this.samplesIn[i].capacity() >= (long)inputSize && ((FloatBuffer)b).hasArray()) {
                    ((FloatPointer)this.samplesIn[i]).position(0L).put(((FloatBuffer)b).array(), b.position(), inputSize);
                    continue;
                }
                this.samplesIn[i] = new FloatPointer((FloatBuffer)b);
            }
        } else if (samples != null && samples[0] instanceof DoubleBuffer) {
            inputFormat = samples.length > 1 ? 9 : 4;
            inputDepth = 8;
            for (i = 0; i < samples.length; ++i) {
                b = (DoubleBuffer)samples[i];
                if (this.samplesIn[i] instanceof DoublePointer && this.samplesIn[i].capacity() >= (long)inputSize && ((DoubleBuffer)b).hasArray()) {
                    ((DoublePointer)this.samplesIn[i]).position(0L).put(((DoubleBuffer)b).array(), b.position(), inputSize);
                    continue;
                }
                this.samplesIn[i] = new DoublePointer((DoubleBuffer)b);
            }
        } else if (samples != null) {
            throw new IllegalStateException("Audio samples Buffer has unsupported type: " + samples);
        }
        if (this.samplesConvertCtx == null || this.samplesChannels != audioChannels || this.samplesFormat != inputFormat || this.samplesRate != sampleRate) {
            this.samplesConvertCtx = swresample.swr_alloc_set_opts((SwrContext)this.samplesConvertCtx, (long)audioContext.channel_layout(), (int)outputFormat, (int)audioContext.sample_rate(), (long)avutil.av_get_default_channel_layout((int)audioChannels), (int)inputFormat, (int)sampleRate, (int)0, null);
            if (this.samplesConvertCtx == null) {
                throw new NullPointerException("swr_alloc_set_opts() error: Cannot allocate the conversion context. output channel layout: " + audioContext.channel_layout() + " output format: " + outputFormat + " output sample rate: " + audioContext.sample_rate() + " input challen layout " + avutil.av_get_default_channel_layout((int)audioChannels) + " input format: " + inputFormat + " input sample rate: " + sampleRate + " class: " + this.getClass().getSimpleName());
            }
            ret = swresample.swr_init((SwrContext)this.samplesConvertCtx);
            if (ret < 0) {
                throw new IllegalStateException("swr_init() error " + ret + ": Cannot initialize the conversion context. output channel layout: " + audioContext.channel_layout() + " output format: " + outputFormat + " output sample rate: " + audioContext.sample_rate() + " input challen layout " + avutil.av_get_default_channel_layout((int)audioChannels) + " input format: " + inputFormat + " input sample rate: " + sampleRate + " class: " + this.getClass().getSimpleName());
            }
            this.samplesChannels = audioChannels;
            this.samplesFormat = inputFormat;
            this.samplesRate = sampleRate;
        }
        for (i = 0; samples != null && i < samples.length; ++i) {
            this.samplesIn[i].position(this.samplesIn[i].position() * (long)inputDepth).limit((this.samplesIn[i].position() + (long)inputSize) * (long)inputDepth);
        }
        while (true) {
            int i2;
            int inputCount = (int)Math.min(samples != null ? (this.samplesIn[0].limit() - this.samplesIn[0].position()) / (long)(inputChannels * inputDepth) : 0L, Integer.MAX_VALUE);
            int outputCount = (int)Math.min((this.samplesOut[0].limit() - this.samplesOut[0].position()) / (long)(outputChannels * outputDepth), Integer.MAX_VALUE);
            inputCount = Math.min(inputCount, (outputCount * sampleRate + audioContext.sample_rate() - 1) / audioContext.sample_rate());
            for (i2 = 0; samples != null && i2 < samples.length; ++i2) {
                this.samplesInPtr.put((long)i2, this.samplesIn[i2]);
            }
            for (i2 = 0; i2 < this.samplesOut.length; ++i2) {
                this.samplesOutPtr.put((long)i2, (Pointer)this.samplesOut[i2]);
            }
            ret = swresample.swr_convert((SwrContext)this.samplesConvertCtx, (PointerPointer)this.samplesOutPtr, (int)outputCount, (PointerPointer)this.samplesInPtr, (int)inputCount);
            if (ret < 0) {
                throw new IllegalStateException("swr_convert() error " + ret + ": Cannot convert audio samples.");
            }
            if (ret == 0) break;
            for (i2 = 0; samples != null && i2 < samples.length; ++i2) {
                this.samplesIn[i2].position(this.samplesIn[i2].position() + (long)(inputCount * inputChannels * inputDepth));
            }
            for (i2 = 0; i2 < this.samplesOut.length; ++i2) {
                this.samplesOut[i2].position(this.samplesOut[i2].position() + (long)(ret * outputChannels * outputDepth));
            }
            if (samples != null && this.samplesOut[0].position() < this.samplesOut[0].limit()) continue;
            this.outputFrame.nb_samples(audioContext.frame_size());
            avcodec.avcodec_fill_audio_frame((AVFrame)this.outputFrame, (int)audioContext.channels(), (int)outputFormat, (BytePointer)this.samplesOut[0], (int)((int)Math.min(this.samplesOut[0].limit(), Integer.MAX_VALUE)), (int)0);
            for (i2 = 0; i2 < this.samplesOut.length; ++i2) {
                this.outputFrame.data(i2, this.samplesOut[i2].position(0L));
                this.outputFrame.linesize(i2, (int)Math.min(this.samplesOut[i2].limit(), Integer.MAX_VALUE));
            }
            this.outputFrame.quality(audioContext.global_quality());
            this.outputFrame.pts(this.pts);
            this.outputFrame.sample_rate(audioContext.sample_rate());
            this.pts += (long)this.outputFrame.nb_samples();
            this.encode(this.outputFrame, streamIndex, this.tmpTimestampMS);
            this.tmpTimestampMS = 0L;
            result = true;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean writeFrame(AVFrame frame, int streamIndex, long timestampMS) throws Exception {
        Object object = this.lock;
        synchronized (object) {
            this.entranceTime = System.nanoTime();
            boolean result = false;
            if (!this.running.get()) {
                this.logger.warn("Audio Encoder is not running right now. hashCode: {} for stream:{}", (Object)this.hashCode(), (Object)this.streamId);
                return false;
            }
            if (frame == null) {
                return this.encode(frame, streamIndex, timestampMS);
            }
            if (frame.format() != this.audioCodecContext.sample_fmt() || frame.sample_rate() != this.audioCodecContext.sample_rate() || frame.channels() != this.audioCodecContext.channels() || frame.nb_samples() != this.audioCodecContext.frame_size()) {
                int sampleFormat = frame.format();
                int planes = avutil.av_sample_fmt_is_planar((int)sampleFormat) != 0 ? frame.channels() : 1;
                int dataSize = avutil.av_samples_get_buffer_size((IntPointer)null, (int)frame.channels(), (int)frame.nb_samples(), (int)frame.format(), (int)1) / planes;
                if (dataSize < 0) {
                    throw new IllegalStateException("Cannot get buffer size correctly, channel count: " + frame.channels() + " number of samples: " + frame.nb_samples() + " frame format: " + frame.format());
                }
                Buffer[] samplesBuf = new Buffer[planes];
                for (int i = 0; i < planes; ++i) {
                    BytePointer p = frame.data(i);
                    p.capacity((long)dataSize);
                    ByteBuffer b = p.asBuffer();
                    switch (sampleFormat) {
                        case 0: 
                        case 5: {
                            samplesBuf[i] = b;
                            break;
                        }
                        case 1: 
                        case 6: {
                            samplesBuf[i] = b.asShortBuffer();
                            break;
                        }
                        case 2: 
                        case 7: {
                            samplesBuf[i] = b.asIntBuffer();
                            break;
                        }
                        case 3: 
                        case 8: {
                            samplesBuf[i] = b.asFloatBuffer();
                            break;
                        }
                        case 4: 
                        case 9: {
                            samplesBuf[i] = b.asDoubleBuffer();
                            break;
                        }
                        default: {
                            this.logger.error("Unrecognized sample format : {}", (Object)sampleFormat);
                        }
                    }
                    samplesBuf[i].position(0).limit(frame.nb_samples());
                }
                result = this.resampleAndEncode(frame.pts(), frame.channels(), frame.sample_rate(), streamIndex, this.audioCodecContext, samplesBuf, timestampMS);
            } else {
                result = this.encode(frame, streamIndex, timestampMS);
            }
            this.totalProcessingTime += System.nanoTime() - this.entranceTime;
            ++this.encodedPacketCount;
            return result;
        }
    }

    public abstract boolean encode(AVFrame var1, int var2, long var3) throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeTrailer() {
        this.isStopped.set(true);
        Object object = this.lock;
        synchronized (object) {
            this.running.set(false);
            for (Muxer muxer : this.muxerList) {
                muxer.writeTrailer();
            }
            if (this.audioCodecContext != null) {
                avcodec.avcodec_free_context((AVCodecContext)this.audioCodecContext);
                this.audioCodecContext.close();
                this.audioCodecContext = null;
            }
            if (this.outputFrame != null) {
                avutil.av_frame_free((AVFrame)this.outputFrame);
                this.outputFrame.close();
                this.outputFrame = null;
            }
            if (this.samplesConvertCtx != null) {
                swresample.swr_free((SwrContext)this.samplesConvertCtx);
                this.samplesConvertCtx.close();
                this.samplesConvertCtx = null;
            }
            if (this.samplesOut != null) {
                for (int i = 0; i < this.samplesOut.length; ++i) {
                    avutil.av_free((Pointer)this.samplesOut[i].position(0L));
                    this.samplesOut[i].close();
                }
                this.samplesOut = null;
            }
            this.logger.info("writing trailer codec name: {} bitrate:{} for stream:{}", new Object[]{this.getCodecName(), this.getBitrate(), this.streamId});
            if (this.encodedPacketCount > 0L) {
                long avarageProcessingTime = this.totalProcessingTime / this.encodedPacketCount;
                this.logger.info("Total processing time {}, Average processing time {} ms per frame on average for stream:{}", new Object[]{(int)((double)this.totalProcessingTime / 1000000.0), (int)((double)avarageProcessingTime / 1000000.0), this.streamId});
            }
            if (this.avpacket != null) {
                this.avpacket.close();
                this.avpacket = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeAudioBuffer(ByteBuffer data, int index, long timestamp) {
        Object object = this.lock;
        synchronized (object) {
            for (Muxer muxer : this.muxerList) {
                muxer.writeAudioBuffer(data, index, timestamp);
            }
        }
    }

    public AVRational getTimebase() {
        if (this.audioCodecContext != null) {
            return this.audioCodecContext.time_base();
        }
        return null;
    }

    @Override
    public String getCodecName() {
        if (this.audioCodec != null) {
            return this.audioCodec.name().getString();
        }
        return null;
    }
}

