/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.enterprise.adaptive.base;

import org.bytedeco.ffmpeg.avcodec.AVCodec;
import org.bytedeco.ffmpeg.avcodec.AVCodecContext;
import org.bytedeco.ffmpeg.avcodec.AVCodecParameters;
import org.bytedeco.ffmpeg.avutil.AVDictionary;
import org.bytedeco.ffmpeg.avutil.AVFrame;
import org.bytedeco.ffmpeg.avutil.AVRational;
import org.bytedeco.ffmpeg.global.avcodec;
import org.bytedeco.ffmpeg.global.avutil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AudioDecoder {
    protected AVCodecContext audioContext;
    protected String streamId;
    protected AVFrame samplesFrame;
    protected int[] gotFrame;
    protected AVRational audioTimeBase;
    private Logger logger = LoggerFactory.getLogger(AudioDecoder.class);

    public void prepareAudioDecoder(AVCodecParameters audioCodecParameters) {
        AVCodec codec = avcodec.avcodec_find_decoder((int)audioCodecParameters.codec_id());
        if (codec == null) {
            throw new IllegalArgumentException("avcodec_find_decoder() error: Unsupported video format or codec not found: " + audioCodecParameters.codec_id() + ".");
        }
        this.logger.info("audio decoder name:  {} for {} sample rate:{}", new Object[]{codec.name().getString(), this.streamId, audioCodecParameters.sample_rate()});
        this.audioContext = avcodec.avcodec_alloc_context3((AVCodec)codec);
        if (this.audioContext == null) {
            throw new IllegalArgumentException("avcodec_alloc_context3() error: Could not allocate video decoding context.");
        }
        if (avcodec.avcodec_parameters_to_context((AVCodecContext)this.audioContext, (AVCodecParameters)audioCodecParameters) < 0) {
            throw new IllegalArgumentException("avcodec_parameters_to_context() error: Could not copy the audio stream parameters.");
        }
        int ret = avcodec.avcodec_open2((AVCodecContext)this.audioContext, (AVCodec)codec, (AVDictionary)null);
        if (ret < 0) {
            throw new IllegalArgumentException("avcodec_open2() error " + ret + ": Could not open audio codec.");
        }
        this.samplesFrame = avutil.av_frame_alloc();
        if (this.samplesFrame == null) {
            throw new NullPointerException("av_frame_alloc() error: Could not allocate audio frame.");
        }
        codec.close();
    }

    public void stop() {
        if (this.samplesFrame != null) {
            avutil.av_frame_free((AVFrame)this.samplesFrame);
            this.samplesFrame.close();
            this.samplesFrame = null;
        }
        if (this.audioContext != null) {
            avcodec.avcodec_free_context((AVCodecContext)this.audioContext);
            this.audioContext.close();
            this.audioContext = null;
        }
    }
}

