/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.enterprise.adaptive.audio;

import io.antmedia.enterprise.adaptive.base.AudioEncoder;
import io.antmedia.muxer.Muxer;
import org.bytedeco.ffmpeg.avutil.AVFrame;
import org.bytedeco.ffmpeg.avutil.AVRational;

public class OpusForwarder
extends AudioEncoder {
    private static final int SAMPLE_RATE = 48000;
    private int streamIndex;
    private int sampleRate;
    private int channelLayout;
    private AVRational timebase = new AVRational();

    public OpusForwarder(int bitrate, String streamId) {
        super(bitrate, streamId);
        this.timebase.num(1).den(48000);
    }

    @Override
    protected void prepareCodecLocal(int sampleRate, int channelLayout, int streamIndex) throws Exception {
        this.sampleRate = 48000;
        this.channelLayout = channelLayout;
        this.streamIndex = streamIndex;
        for (Muxer muxer : this.muxerList) {
            muxer.addAudioStream(48000, channelLayout, 86076, streamIndex);
        }
        this.running.set(true);
    }

    @Override
    public boolean encode(AVFrame audioFrame, int streamIndex, long captureTimestampMS) throws Exception {
        return audioFrame != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addMuxer(Muxer muxer) {
        Object object = this.lock;
        synchronized (object) {
            if (this.running.get()) {
                muxer.addAudioStream(48000, this.channelLayout, 86076, this.streamIndex);
            }
            super.addMuxer(muxer);
        }
    }

    @Override
    public String getCodecName() {
        return "opusforwarder";
    }

    public int getStreamIndex() {
        return this.streamIndex;
    }

    @Override
    public AVRational getTimebase() {
        return this.timebase;
    }

    @Override
    public void writeTrailer() {
        super.writeTrailer();
        this.timebase.close();
    }
}

