/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.enterprise.adaptive.audio;

import io.antmedia.enterprise.adaptive.base.AudioDecoder;
import io.antmedia.muxer.MuxAdaptor;
import java.nio.ByteBuffer;
import org.bytedeco.ffmpeg.avcodec.AVCodecContext;
import org.bytedeco.ffmpeg.avcodec.AVCodecParameters;
import org.bytedeco.ffmpeg.avcodec.AVPacket;
import org.bytedeco.ffmpeg.avutil.AVFrame;
import org.bytedeco.ffmpeg.avutil.AVRational;
import org.bytedeco.ffmpeg.global.avcodec;
import org.bytedeco.ffmpeg.global.avutil;
import org.bytedeco.javacpp.BytePointer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpusDecoder
extends AudioDecoder {
    private Logger logger = LoggerFactory.getLogger(OpusDecoder.class);
    private AVPacket avpacket;

    public void prepare(String streamId) {
        this.avpacket = avcodec.av_packet_alloc();
        avcodec.av_init_packet((AVPacket)this.avpacket);
        this.audioTimeBase = new AVRational();
        this.audioTimeBase.num(1).den(48000);
        this.gotFrame = new int[1];
        this.streamId = streamId;
        AVCodecParameters audioCodecParameters = new AVCodecParameters();
        audioCodecParameters.sample_rate(48000);
        audioCodecParameters.codec_id(86076);
        audioCodecParameters.codec_type(1);
        audioCodecParameters.channel_layout(3L);
        audioCodecParameters.channels(2);
        audioCodecParameters.format(8);
        byte[] extraData = new byte[]{79, 112, 117, 115, 72, 101, 97, 100, 1, 2, 120, 0, -128, -69, 0, 0, 0, 0, 0};
        BytePointer audioExtraDataPointer = new BytePointer(avutil.av_malloc((long)extraData.length)).capacity((long)extraData.length);
        audioExtraDataPointer.position(0L).put(extraData);
        audioCodecParameters.extradata(audioExtraDataPointer);
        audioCodecParameters.extradata_size(extraData.length);
        this.prepareAudioDecoder(audioCodecParameters);
    }

    public AVFrame decode(ByteBuffer data, long timestamp) {
        this.avpacket.stream_index(0);
        this.avpacket.pts(timestamp);
        this.avpacket.dts(timestamp);
        this.avpacket.flags(this.avpacket.flags() | 1);
        data.rewind();
        this.avpacket.data(new BytePointer(data));
        this.avpacket.size(data.limit());
        this.avpacket.position(0L);
        this.avpacket.pts(avutil.av_rescale_q_rnd((long)this.avpacket.pts(), (AVRational)this.audioTimeBase, (AVRational)MuxAdaptor.TIME_BASE_FOR_MS, (int)8197));
        this.avpacket.dts(avutil.av_rescale_q_rnd((long)this.avpacket.dts(), (AVRational)this.audioTimeBase, (AVRational)MuxAdaptor.TIME_BASE_FOR_MS, (int)8197));
        this.avpacket.duration(avutil.av_rescale_q((long)this.avpacket.duration(), (AVRational)this.audioTimeBase, (AVRational)MuxAdaptor.TIME_BASE_FOR_MS));
        this.avpacket.pos(-1L);
        Object frameData = null;
        int len = avcodec.avcodec_decode_audio4((AVCodecContext)this.audioContext, (AVFrame)this.samplesFrame, (int[])this.gotFrame, (AVPacket)this.avpacket);
        if (len >= 0 && this.gotFrame[0] != 0) {
            this.samplesFrame.pts(this.samplesFrame.best_effort_timestamp());
        } else {
            this.logger.error("Cannot decode opus frame for stream:{} length:{} gotFrame:{}", new Object[]{this.streamId, len, this.gotFrame[0]});
        }
        avcodec.av_packet_unref((AVPacket)this.avpacket);
        return this.samplesFrame;
    }
}

