/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.enterprise.adaptive.audio;

import io.antmedia.enterprise.adaptive.base.AudioEncoder;
import io.antmedia.muxer.Muxer;
import org.bytedeco.ffmpeg.avcodec.AVCodec;
import org.bytedeco.ffmpeg.avcodec.AVCodecContext;
import org.bytedeco.ffmpeg.avcodec.AVPacket;
import org.bytedeco.ffmpeg.avutil.AVDictionary;
import org.bytedeco.ffmpeg.avutil.AVFrame;
import org.bytedeco.ffmpeg.global.avcodec;
import org.bytedeco.ffmpeg.global.avutil;
import org.bytedeco.javacpp.BytePointer;
import org.bytedeco.javacpp.IntPointer;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.PointerPointer;

public class AACEncoder
extends AudioEncoder {
    private static int sampleFormat = 8;
    private int streamIndex;

    public AACEncoder(int bitrate, String streamId) {
        super(bitrate, streamId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addMuxer(Muxer muxer) {
        Object object = this.lock;
        synchronized (object) {
            if (this.running.get()) {
                muxer.addStream(this.audioCodec, this.audioCodecContext, this.streamIndex);
            }
            super.addMuxer(muxer);
        }
    }

    @Override
    protected void prepareCodecLocal(int sampleRate, int channelLayout, int streamIndex) throws Exception {
        this.audioCodec = avcodec.avcodec_find_encoder((int)86018);
        this.streamIndex = streamIndex;
        if (channelLayout == 0) {
            channelLayout = 4;
        }
        if (this.audioCodec == null) {
            throw new NullPointerException("Could not find encoder 86018");
        }
        BytePointer namePointer = this.audioCodec.name();
        this.logger.info("name : {} ", (Object)namePointer.getString());
        namePointer.close();
        this.audioCodecContext = avcodec.avcodec_alloc_context3((AVCodec)this.audioCodec);
        if (this.audioCodecContext == null) {
            throw new NullPointerException("Could not allocate codec context: AV_CODEC_ID_AAC");
        }
        this.audioCodecContext.sample_rate(sampleRate);
        this.audioCodecContext.channel_layout((long)channelLayout);
        this.audioCodecContext.channels(avutil.av_get_channel_layout_nb_channels((long)channelLayout));
        this.audioCodecContext.sample_fmt(sampleFormat);
        this.audioCodecContext.time_base().num(1);
        this.audioCodecContext.time_base().den(sampleRate);
        this.audioCodecContext.bit_rate((long)this.getBitrate());
        int ret = avcodec.avcodec_open2((AVCodecContext)this.audioCodecContext, (AVCodec)this.audioCodec, (AVDictionary)null);
        if (ret < 0) {
            avcodec.avcodec_free_context((AVCodecContext)this.audioCodecContext);
            this.audioCodecContext.close();
            this.audioCodecContext = null;
            byte[] data = new byte[2048];
            avutil.av_strerror((int)ret, (byte[])data, (long)data.length);
            throw new IllegalStateException("Could not allocate codec context: AV_CODEC_ID_AAC. Error is " + new String(data, 0, data.length));
        }
        int planes = avutil.av_sample_fmt_is_planar((int)this.audioCodecContext.sample_fmt()) != 0 ? this.audioCodecContext.channels() : 1;
        int dataSize = avutil.av_samples_get_buffer_size((IntPointer)null, (int)this.audioCodecContext.channels(), (int)this.audioCodecContext.frame_size(), (int)this.audioCodecContext.sample_fmt(), (int)1) / planes;
        this.samplesOut = new BytePointer[planes];
        for (int j = 0; j < this.samplesOut.length; ++j) {
            this.samplesOut[j] = new BytePointer(avutil.av_malloc((long)dataSize)).capacity((long)dataSize);
        }
        this.samplesIn = new Pointer[8];
        this.samplesInPtr = new PointerPointer(8L);
        this.samplesOutPtr = new PointerPointer(8L);
        this.outputFrame = avutil.av_frame_alloc();
        this.outputFrame.pts(0L);
        this.avpacket = new AVPacket();
        for (Muxer muxer : this.muxerList) {
            muxer.addStream(this.audioCodec, this.audioCodecContext, streamIndex);
        }
        this.running.set(true);
    }

    @Override
    public boolean encode(AVFrame frame, int streamIndex, long timestampMS) throws Exception {
        avcodec.av_init_packet((AVPacket)this.avpacket);
        this.avpacket.data(null);
        this.avpacket.size(0);
        int[] gotOutput = new int[1];
        int ret = avcodec.avcodec_encode_audio2((AVCodecContext)this.audioCodecContext, (AVPacket)this.avpacket, (AVFrame)frame, (int[])gotOutput);
        if (ret < 0) {
            avcodec.av_packet_unref((AVPacket)this.avpacket);
            throw new IllegalStateException("Cannot encode audio frame");
        }
        boolean result = false;
        if (gotOutput[0] != 0) {
            this.avpacket.stream_index(streamIndex);
            for (Muxer muxer : this.muxerList) {
                muxer.writePacket(this.avpacket, this.audioCodecContext);
            }
            result = true;
        }
        avcodec.av_packet_unref((AVPacket)this.avpacket);
        return result;
    }

    public int getSampleFormat() {
        return sampleFormat;
    }

    public void setSampleFormat(int format) {
        sampleFormat = format;
    }
}

