/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.enterprise.adaptive;

import io.antmedia.AppSettings;
import io.antmedia.enterprise.adaptive.StreamAdaptor;
import io.antmedia.enterprise.adaptive.WebRTCEncoderAdaptor;
import io.antmedia.enterprise.adaptive.audio.AACEncoder;
import io.antmedia.enterprise.adaptive.audio.OpusEncoder;
import io.antmedia.enterprise.adaptive.audio.OpusForwarder;
import io.antmedia.enterprise.adaptive.base.AudioEncoder;
import io.antmedia.enterprise.adaptive.base.VideoEncoder;
import io.antmedia.enterprise.adaptive.video.SFUForwarder;
import io.antmedia.enterprise.cluster.TcpCluster;
import io.antmedia.enterprise.webrtc.WebRTCMuxer;
import io.antmedia.enterprise.webrtc.codec.VirtualVideoEncoderFactory;
import io.antmedia.webrtc.VideoCodec;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.bytedeco.ffmpeg.avcodec.AVCodecParameters;
import org.red5.server.stream.ClientBroadcastStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.webrtc.EncodedImage;
import org.webrtc.H264Utils;
import org.webrtc.Logging;
import org.webrtc.MediaStream;
import org.webrtc.VideoCodecInfo;
import org.webrtc.VideoCodecStatus;
import org.webrtc.VideoCodecType;
import org.webrtc.VideoDecoder;
import org.webrtc.VideoDecoderFactory;

public class WebRTCVideoForwarder
extends WebRTCEncoderAdaptor
implements VideoDecoderFactory {
    private SFUForwarder sfuForwarder;
    private VirtualVideoDecoder virtualVideoDecoder;
    private static Logger logger = LoggerFactory.getLogger(WebRTCVideoForwarder.class);
    private List<VideoCodec> videoCodecList;
    private WebRTCMuxer webRTCMuxer;
    private AudioEncoder opusEncoder;
    private IAudioSender webRTCAudioSender;
    private int firstFrameWidth;
    private int firstFrameHeight;
    private ConcurrentLinkedQueue<EncodedVideoFrame> encodedVideoFrameQueue = new ConcurrentLinkedQueue();
    private AtomicBoolean writeVideoBufferRunning = new AtomicBoolean(false);

    public void writeVideoBuffer() {
        if (this.writeVideoBufferRunning.compareAndSet(false, true)) {
            EncodedVideoFrame encodedFrame = null;
            while ((encodedFrame = this.encodedVideoFrameQueue.poll()) != null) {
                this.packetFeeder.writeVideoBuffer(encodedFrame.buffer, encodedFrame.videoTimeMs, encodedFrame.rotation, this.getVideoStreamIndex(), encodedFrame.isKeyFrame, encodedFrame.firstFrameTimeMs, encodedFrame.videoTimeMs);
                this.sfuForwarder.writeVideoBuffer(encodedFrame.buffer, encodedFrame.videoTimeMs, encodedFrame.rotation, this.getVideoStreamIndex(), encodedFrame.isKeyFrame, encodedFrame.firstFrameTimeMs, encodedFrame.videoTimeMs);
            }
            this.writeVideoBufferRunning.compareAndSet(true, false);
        }
    }

    public WebRTCVideoForwarder(ClientBroadcastStream clientBroadcastStream, TcpCluster clusterNotifier, AppSettings appSettings, Logging.Severity logLevel) {
        super(clientBroadcastStream, clusterNotifier, logLevel);
        this.appSettings = appSettings;
        this.webRTCAudioSender = (audioPacket, streamIndex, timestamp) -> {};
    }

    @Override
    public VideoDecoderFactory getVideoDecoderFactory() {
        return this;
    }

    @Override
    public void buildOnlyAudioEncoders(boolean encode) {
        StreamAdaptor streamAdaptor = new StreamAdaptor(true, this.vertx, this.streamId);
        if (this.isAACEncodingRequired()) {
            AACEncoder aacEncoder = new AACEncoder(this.appSettings.getAudioBitrateSFU(), this.streamId);
            this.initMp4Muxer(0, null, aacEncoder, this.streamId);
            this.initHLSMuxer(0, null, aacEncoder);
            this.initDASHMuxer(0, null, aacEncoder);
            streamAdaptor.addAudioEncoder(aacEncoder);
        }
        this.webRTCMuxer = this.getWebRTCMuxer(0, encode);
        this.webRTCMuxer.setCodec(VideoCodec.NOVIDEO);
        this.webRTCMuxer.init(this.scope, this.streamId, 0, this.getBroadcast().getSubFolder(), 0);
        this.opusEncoder = this.isAACEncodingRequired() ? new OpusEncoder(this.appSettings.getAudioBitrateSFU(), this.streamId) : new OpusForwarder(this.appSettings.getAudioBitrateSFU(), this.streamId);
        this.opusEncoder.addMuxer(this.webRTCMuxer);
        this.initWebMMuxer(0, null, this.opusEncoder);
        streamAdaptor.addAudioEncoder(this.opusEncoder);
        this.videoCodecList = new ArrayList<VideoCodec>();
        this.videoCodecList.add(VideoCodec.H264);
        this.streamAdaptorList.add(streamAdaptor);
        streamAdaptor.start();
        this.enableWebRTCAudioSender();
    }

    @Override
    public void buildEncoders(int sourceHeight, boolean transcodeVideo) {
        try {
            this.setVideoStreamIndex(1);
            this.sfuForwarder = new SFUForwarder(0, 0, this::startIOandNotify, this.streamId);
            this.virtualVideoDecoder = new VirtualVideoDecoder(this.sfuForwarder);
            this.opusEncoder = this.isAACEncodingRequired() ? new OpusEncoder(this.appSettings.getAudioBitrateSFU(), this.streamId) : new OpusForwarder(this.appSettings.getAudioBitrateSFU(), this.streamId);
            this.webRTCMuxer = this.getWebRTCMuxer(0, false);
            this.webRTCMuxer.init(this.scope, this.streamId, 0, this.getBroadcast().getSubFolder(), 0);
            this.sfuForwarder.addMuxer(this.webRTCMuxer);
            this.opusEncoder.addMuxer(this.webRTCMuxer);
            StreamAdaptor streamAdaptor = new StreamAdaptor(true, this.vertx, this.streamId);
            this.videoCodecList = new ArrayList<VideoCodec>();
            if (this.getRemoteDescription().description.contains(VideoCodec.H264.toString()) && this.getAppSettings().isH264Enabled()) {
                this.webRTCMuxer.setCodec(VideoCodec.H264);
                this.sfuForwarder.setVideoCodec(VideoCodec.H264);
                if (this.isAACEncodingRequired()) {
                    AACEncoder aacEncoder = new AACEncoder(this.appSettings.getAudioBitrateSFU(), this.streamId);
                    this.initMp4Muxer(0, this.sfuForwarder, aacEncoder, this.streamId);
                    this.initHLSMuxer(0, this.sfuForwarder, aacEncoder);
                    this.initDASHMuxer(0, this.sfuForwarder, aacEncoder);
                    streamAdaptor.addAudioEncoder(aacEncoder);
                }
                this.videoCodecList.add(VideoCodec.H264);
            } else if (this.getRemoteDescription().description.contains(VideoCodec.VP8.toString()) && this.getAppSettings().isVp8Enabled()) {
                this.webRTCMuxer.setCodec(VideoCodec.VP8);
                this.sfuForwarder.setVideoCodec(VideoCodec.VP8);
                this.videoCodecList.add(VideoCodec.VP8);
                this.initWebMMuxer(0, this.sfuForwarder, this.opusEncoder);
            } else {
                this.webRTCMuxer.setCodec(VideoCodec.H265);
                this.sfuForwarder.setVideoCodec(VideoCodec.H265);
                this.videoCodecList.add(VideoCodec.H265);
                if (this.isAACEncodingRequired()) {
                    AACEncoder aacEncoder = new AACEncoder(this.appSettings.getAudioBitrateSFU(), this.streamId);
                    this.initMp4Muxer(0, this.sfuForwarder, aacEncoder, this.streamId);
                    this.initHLSMuxer(0, this.sfuForwarder, aacEncoder);
                    this.initDASHMuxer(0, this.sfuForwarder, aacEncoder);
                    streamAdaptor.addAudioEncoder(aacEncoder);
                }
            }
            streamAdaptor.addVideoEncoder(this.sfuForwarder);
            streamAdaptor.addAudioEncoder(this.opusEncoder);
            this.streamAdaptorList.add(streamAdaptor);
            streamAdaptor.start();
            this.enableWebRTCAudioSender();
        }
        catch (Exception e) {
            logger.error(ExceptionUtils.getStackTrace((Throwable)e));
        }
    }

    public void enableWebRTCAudioSender() {
        this.webRTCAudioSender = (audioPacket, streamIndex, timestamp) -> this.opusEncoder.writeAudioBuffer(audioPacket, streamIndex, timestamp);
    }

    @Override
    public void onAddStream(MediaStream stream) {
        logger.info("onAddStream for streamId {}", (Object)this.streamId);
    }

    public VideoDecoder createDecoder(VideoCodecInfo info) {
        logger.info("create decoder for name:{} and params: {}", (Object)info.name, (Object)info.params);
        return this.virtualVideoDecoder;
    }

    public VideoCodecInfo[] getSupportedCodecs() {
        ArrayList<VideoCodecInfo> supportedCodecInfos = new ArrayList<VideoCodecInfo>();
        if (this.appSettings.isH264Enabled()) {
            supportedCodecInfos.add(new VideoCodecInfo(VideoCodecType.H264.name(), H264Utils.getDefaultH264Params((boolean)false)));
        }
        if (this.appSettings.isVp8Enabled()) {
            supportedCodecInfos.add(new VideoCodecInfo(VideoCodecType.VP8.name(), new HashMap()));
        }
        return supportedCodecInfos.toArray(new VideoCodecInfo[supportedCodecInfos.size()]);
    }

    @Override
    public VirtualVideoEncoderFactory getVideoEncoderFactory() {
        return new VirtualVideoEncoderFactory(this.streamId, new ArrayList<String>(), this.videoCodecList);
    }

    public VirtualVideoDecoder getVirtualVideoDecoder() {
        return this.virtualVideoDecoder;
    }

    public SFUForwarder getSfuForwarder() {
        return this.sfuForwarder;
    }

    @Override
    protected boolean isSFU() {
        return !this.isAACEncodingRequired();
    }

    @Override
    public synchronized void onOpusPacket(ByteBuffer data, long timestamp) {
        this.webRTCAudioSender.sendAudio(data, this.getAudioStreamIndex(), timestamp);
    }

    public AudioEncoder getSfuAudioForwarder() {
        return this.opusEncoder;
    }

    public void setSfuAudioForwarder(OpusForwarder opusForwarder) {
        this.opusEncoder = opusForwarder;
    }

    public void setWebRTCMuxer(WebRTCMuxer webRTCMuxer) {
        this.webRTCMuxer = webRTCMuxer;
    }

    @Override
    public long getVideoTime(long timestampMS) {
        return this.isAACEncodingRequired() ? super.getVideoTime(timestampMS) : timestampMS;
    }

    @Override
    public AVCodecParameters getVideoCodecParameters() {
        int codecId = this.getRemoteDescription().description.contains(VideoCodec.VP8.toString()) && this.getAppSettings().isVp8Enabled() ? 139 : 27;
        AVCodecParameters videoCodecParameters = super.getVideoCodecParameters();
        videoCodecParameters.width(this.getFirstFrameWidth());
        videoCodecParameters.height(this.getFirstFrameHeight());
        videoCodecParameters.format(0);
        videoCodecParameters.codec_tag(0);
        videoCodecParameters.codec_id(codecId);
        return videoCodecParameters;
    }

    public int getFirstFrameWidth() {
        return this.firstFrameWidth;
    }

    public void setFirstFrameWidth(int firstFrameWidth) {
        this.firstFrameWidth = firstFrameWidth;
    }

    public int getFirstFrameHeight() {
        return this.firstFrameHeight;
    }

    public void setFirstFrameHeight(int firstFrameHeight) {
        this.firstFrameHeight = firstFrameHeight;
    }

    public class VirtualVideoDecoder
    implements VideoDecoder {
        private VideoEncoder videoEncoder;
        private long lastKeyFrameRequestTimeMs = 0L;
        private long firstFrameTimeMs = 0L;
        private long lastFrameTimeMs = -1L;
        private VideoCodecInfo codecInfo;
        private volatile boolean dropVideoFrameUntilKeyFrame = false;
        public static final int VIDEO_STREAM_INDEX = 1;

        public VirtualVideoDecoder(VideoEncoder videoEncoder) {
            this.videoEncoder = videoEncoder;
        }

        public VideoCodecStatus initDecode(VideoDecoder.Settings settings, VideoDecoder.Callback decodeCallback) {
            logger.info("initDecode width:{} height:{} ", (Object)settings.width, (Object)settings.height);
            if (!WebRTCVideoForwarder.this.ready.get() && !WebRTCVideoForwarder.this.isRestored()) {
                try {
                    this.videoEncoder.prepareCodec(settings.width, settings.height, null, null, 0, WebRTCVideoForwarder.this.getVideoStreamIndex(), false, null);
                }
                catch (Exception e) {
                    logger.error(ExceptionUtils.getStackTrace((Throwable)e));
                }
            }
            return VideoCodecStatus.OK;
        }

        public VideoCodecStatus release() {
            logger.info("release decode {}", (Object)this);
            return VideoCodecStatus.OK;
        }

        public VideoCodecStatus decode(EncodedImage frame, VideoDecoder.DecodeInfo info) {
            try {
                long videoTimeMs;
                WebRTCVideoForwarder.this.initializeVideoPacketTime(frame.captureTimeNs);
                long tmpNow = System.currentTimeMillis();
                if (this.firstFrameTimeMs == 0L) {
                    this.firstFrameTimeMs = WebRTCVideoForwarder.this.firstVideoTimestampMs + WebRTCVideoForwarder.this.videoTimeOffsetMS;
                    WebRTCVideoForwarder.this.setFirstFrameWidth(frame.encodedWidth);
                    WebRTCVideoForwarder.this.setFirstFrameHeight(frame.encodedHeight);
                }
                long frameTimestampMs = frame.captureTimeNs / 1000000L - WebRTCVideoForwarder.this.firstVideoTimestampMs + WebRTCVideoForwarder.this.videoTimeOffsetMS;
                logger.trace("video capture timeNS: {} in MS: {} frame normalized timestamp:{} audio frame count: {}", new Object[]{frame.captureTimeNs, frame.captureTimeMs, frameTimestampMs, WebRTCVideoForwarder.this.receivedAudioFrameCount});
                if (this.dropVideoFrameUntilKeyFrame && frame.frameType == EncodedImage.FrameType.VideoFrameKey) {
                    this.dropVideoFrameUntilKeyFrame = false;
                }
                if ((videoTimeMs = WebRTCVideoForwarder.this.getVideoTime(frameTimestampMs)) >= this.lastFrameTimeMs && !this.dropVideoFrameUntilKeyFrame) {
                    this.lastFrameTimeMs = videoTimeMs;
                    logger.trace("video time:{} audio frame count:{} video frame type: {}", new Object[]{frameTimestampMs, WebRTCVideoForwarder.this.receivedAudioFrameCount, frame.frameType});
                    boolean isKeyFrame = frame.frameType == EncodedImage.FrameType.VideoFrameKey;
                    frame.buffer.rewind();
                    ByteBuffer buffer = ByteBuffer.allocateDirect(frame.buffer.limit());
                    buffer.put(frame.buffer);
                    buffer.rewind();
                    WebRTCVideoForwarder.this.encodedVideoFrameQueue.add(new EncodedVideoFrame(buffer, videoTimeMs, frame.rotation, isKeyFrame, WebRTCVideoForwarder.this.firstVideoTimestampMs));
                    WebRTCVideoForwarder.this.webRTCVertx.executeBlocking(h -> {
                        WebRTCVideoForwarder.this.writeVideoBuffer();
                        h.complete();
                    }, null);
                } else {
                    this.dropVideoFrameUntilKeyFrame = true;
                    ++WebRTCVideoForwarder.this.droppedVideoFrameCount;
                    ++WebRTCVideoForwarder.this.log2DropVideoFrame;
                    if (WebRTCVideoForwarder.this.log2DropVideoFrame % 20 == 0) {
                        WebRTCVideoForwarder.this.log2DropVideoFrame = 0;
                        logger.info("Dropping video frame for stream:{}. Video/audio enabled:{} videoTimeMS: {} audio duration:{} total frame drop count:{} dropVideoFrameUntilKeyFrame:{}", new Object[]{WebRTCVideoForwarder.this.streamId, WebRTCVideoForwarder.this.enableVideo, WebRTCVideoForwarder.this.enableAudio, frameTimestampMs, WebRTCVideoForwarder.this.getAudioDurationMs(), WebRTCVideoForwarder.this.droppedVideoFrameCount, this.dropVideoFrameUntilKeyFrame});
                    }
                }
                if (tmpNow - this.lastKeyFrameRequestTimeMs > (long)WebRTCVideoForwarder.this.appSettings.getWebRTCKeyframeTime() || this.dropVideoFrameUntilKeyFrame) {
                    logger.trace("requesting key frame for {}", (Object)this);
                    this.lastKeyFrameRequestTimeMs = tmpNow;
                    return VideoCodecStatus.REQUEST_KEY_FRAME;
                }
            }
            catch (Exception e) {
                logger.error(ExceptionUtils.getStackTrace((Throwable)e));
            }
            return VideoCodecStatus.OK;
        }

        public boolean getPrefersLateDecoding() {
            return false;
        }

        public String getImplementationName() {
            return this.getClass().getSimpleName();
        }

        public void setCodecInfo(VideoCodecInfo info) {
            this.codecInfo = info;
        }

        public VideoCodecInfo getCodecInfo() {
            return this.codecInfo;
        }
    }

    public static interface IAudioSender {
        public void sendAudio(ByteBuffer var1, int var2, long var3);
    }

    private class EncodedVideoFrame {
        public final ByteBuffer buffer;
        public final long videoTimeMs;
        public final int rotation;
        public final boolean isKeyFrame;
        public final long firstFrameTimeMs;

        public EncodedVideoFrame(ByteBuffer buffer, long videoTimeMs, int rotation, boolean isKeyFrame, long firstFrameTimeMs) {
            this.buffer = buffer;
            this.videoTimeMs = videoTimeMs;
            this.rotation = rotation;
            this.isKeyFrame = isKeyFrame;
            this.firstFrameTimeMs = firstFrameTimeMs;
        }
    }
}

