/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.enterprise.adaptive;

import io.antmedia.datastore.db.types.Broadcast;
import io.antmedia.datastore.db.types.Endpoint;
import io.antmedia.enterprise.adaptive.DecodedStreamsEncoderAdaptor;
import io.antmedia.enterprise.adaptive.StreamAdaptor;
import io.antmedia.enterprise.adaptive.audio.AACEncoder;
import io.antmedia.enterprise.adaptive.base.AudioEncoder;
import io.antmedia.enterprise.adaptive.base.VideoEncoder;
import io.antmedia.enterprise.adaptive.video.H264Encoder;
import io.antmedia.enterprise.adaptive.video.SFUForwarder;
import io.antmedia.enterprise.cluster.TcpCluster;
import io.antmedia.enterprise.webrtc.DataChannelRouter;
import io.antmedia.enterprise.webrtc.WebRTCStreamInfoListener;
import io.antmedia.enterprise.webrtc.codec.VirtualVideoEncoderFactory;
import io.antmedia.muxer.IEndpointStatusListener;
import io.antmedia.muxer.MuxAdaptor;
import io.antmedia.muxer.Muxer;
import io.antmedia.muxer.RtmpMuxer;
import io.antmedia.plugin.FrameFeeder;
import io.antmedia.plugin.PacketFeeder;
import io.antmedia.statistic.type.WebRTCAudioReceiveStats;
import io.antmedia.statistic.type.WebRTCVideoReceiveStats;
import io.antmedia.webrtc.AudioFrameContext;
import io.antmedia.webrtc.VideoCodec;
import io.antmedia.webrtc.VideoFrameContext;
import io.antmedia.webrtc.api.IAudioTrackListener;
import io.vertx.core.Context;
import io.vertx.core.Vertx;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import net.sf.ehcache.util.NamedThreadFactory;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.bytedeco.ffmpeg.avcodec.AVCodecParameters;
import org.bytedeco.ffmpeg.avutil.AVFrame;
import org.bytedeco.ffmpeg.avutil.AVRational;
import org.bytedeco.ffmpeg.global.avcodec;
import org.bytedeco.ffmpeg.global.avutil;
import org.bytedeco.javacpp.BytePointer;
import org.bytedeco.javacpp.IntPointer;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.PointerPointer;
import org.red5.server.api.scope.IScope;
import org.red5.server.stream.ClientBroadcastStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.webrtc.AudioDecoderFactoryFactory;
import org.webrtc.BuiltinAudioDecoderFactoryFactory;
import org.webrtc.DataChannel;
import org.webrtc.IceCandidate;
import org.webrtc.Logging;
import org.webrtc.MediaConstraints;
import org.webrtc.MediaStream;
import org.webrtc.PeerConnection;
import org.webrtc.PeerConnectionFactory;
import org.webrtc.RTCStats;
import org.webrtc.RTCStatsReport;
import org.webrtc.RtpReceiver;
import org.webrtc.SdpObserver;
import org.webrtc.SessionDescription;
import org.webrtc.VideoDecoderFactory;
import org.webrtc.VideoEncoderFactory;
import org.webrtc.VideoFrame;
import org.webrtc.VideoSink;
import org.webrtc.VideoTrack;
import org.webrtc.WrappedNativeI420Buffer;
import org.webrtc.audio.AudioDeviceModule;
import org.webrtc.audio.JavaAudioDeviceModule;
import org.webrtc.audio.WebRtcAudioTrack;

public class WebRTCEncoderAdaptor
extends DecodedStreamsEncoderAdaptor
implements PeerConnection.Observer,
SdpObserver {
    private static final int STAT_COLLECTION_PERIOD_MS = 10000;
    private static final String KIND = "kind";
    private static final String AUDIO = "audio";
    private static final String FRAMES_RECEIVED = "framesReceived";
    private static final String TRACK = "track";
    private static final String NACK_COUNT = "nackCount";
    private static final String PLI_COUNT = "pliCount";
    private static final String FIR_COUNT = "firCount";
    private static final String VIDEO = "video";
    private static final String FRACTION_LOST = "fractionLost";
    private static final String JITTER = "jitter";
    private static final String PACKETS_LOST = "packetsLost";
    private static final String BYTES_RECEIVED = "bytesReceived";
    private static final String PACKETS_RECEIVED = "packetsReceived";
    private static final String MEDIA_TYPE = "mediaType";
    private static final String INBOUND_RTP = "inbound-rtp";
    private static final String TRANSPORT = "transport";
    private static final String SELECTED_CANDIDATE_PAIR_ID = "selectedCandidatePairId";
    private static final String REMOTE_CANDIDATE_ID = "remoteCandidateId";
    protected WebRtcAudioTrack webRtcAudioTrack;
    private PeerConnectionFactory peerConnectionFactory;
    private PeerConnection peerConnection;
    private MediaConstraints sdpMediaConstraints;
    protected static Logger logger = LoggerFactory.getLogger(WebRTCEncoderAdaptor.class);
    private int maxQueueVideoFrameSize;
    protected AtomicInteger audioFrameProcessedCount = new AtomicInteger(0);
    private int maxQueueAudioFrameSize;
    private Object lock = new Object();
    private AtomicBoolean restored = new AtomicBoolean(false);
    private Logging.Severity webrtcLogLevel = Logging.Severity.LS_WARNING;
    private int audioFrameLogCounter = 0;
    private long lasttAudioTimeStamp = 0L;
    private long totalAudioFrameInterval = 0L;
    private ConcurrentLinkedQueue<VideoFrameContext> videoFrameQueue = new ConcurrentLinkedQueue();
    private AtomicBoolean videoEncoderRunning = new AtomicBoolean(false);
    private ConcurrentLinkedQueue<AudioFrameContext> audioFrameQueue = new ConcurrentLinkedQueue();
    protected AtomicBoolean audioEncoderRunning = new AtomicBoolean(false);
    protected AtomicBoolean ready = new AtomicBoolean(false);
    protected AtomicBoolean isStopped = new AtomicBoolean(false);
    protected volatile long firstVideoPacketReceivedTime;
    protected volatile long firstVideoTimestampMs;
    private long debugStartFuntionCalledTime;
    protected WebRTCStreamInfoListener infoListener;
    private VideoSink videoSink;
    protected AtomicInteger receivedAudioFrameCount = new AtomicInteger(0);
    private int receivedVideoFrameCount = 0;
    protected int droppedVideoFrameCount = 0;
    private int droppedAudioFrameCount = 0;
    private volatile long lastFrameNumber = -1L;
    private VideoTrack videoTrack;
    private AtomicInteger videoFramePending = new AtomicInteger(0);
    private AtomicInteger audioFramePending = new AtomicInteger(0);
    private String stunServerUri = "stun:stun1.l.google.com:19302";
    private List<Endpoint> rtmpEndpointList;
    private ScheduledFuture<?> audioTrackFuture = null;
    private long videoEncoderExecutorSchedule = -1L;
    private long audioEncoderExecutorFuture = -1L;
    private long streamingStopTimeMs = -1L;
    private long streamingStartTimeMs;
    private volatile boolean remoteDescriptionSet = false;
    private Queue<IceCandidate> iceCandidateQueue = new ConcurrentLinkedQueue<IceCandidate>();
    protected boolean localDescriptionSet = false;
    private static Object staticLock = new Object();
    protected int readyTimeoutSeconds = 20;
    private BigInteger lastKnownAudioBytesReceived = BigInteger.ZERO;
    private long lastKnownAudioPacketsReceived;
    private long lastKnownVideoPacketsReceived;
    private BigInteger lastKnownVideoBytesReceived = BigInteger.ZERO;
    private long lastKnownVideoFramesReceived;
    private double lastKnownStatsTimeStampMs = 0.0;
    private volatile long videoEncodeStartTime;
    private volatile long audioEncodeStartTime;
    private long encoderHealthCheckerId = -1L;
    private WebRTCAudioReceiveStats audioReceivedStats = new WebRTCAudioReceiveStats();
    private WebRTCVideoReceiveStats videoReceivedStats = new WebRTCVideoReceiveStats();
    private JavaAudioDeviceModule adm;
    private boolean replaceCandidateAddressWithServerAddress = false;
    private String serverAddress;
    private String remoteIp;
    private long totalVideoEncoderTime;
    protected DataChannel dataChannel;
    private DataChannelRouter dataChannelRouter;
    private SessionDescription remoteDescription;
    protected Context signallingContext;
    private long statTimer = -1L;
    public static final String IPV4_REGEX = "\\b\\d+\\.\\d+\\.\\d+\\.\\d+\\b";
    protected int log2DropVideoFrame = 0;
    private byte[] frameData;
    private volatile long firstAudioPacketReceivedTime = 0L;
    protected volatile long firstAudioTimeStamp = 0L;
    protected AVFrame rawVideoFrame;
    private BytePointer rawVideoBuffer;
    protected AVFrame rawAudioFrame;
    private BytePointer rawAudioBuffer;
    private int rawVideoWidth;
    private int rawVideoHeight;
    private AVRational videoTimeBase;
    protected volatile long audioTimeOffsetInSampleRate = 0L;
    protected long videoTimeOffsetMS = 0L;
    public static final AVRational AUDIO_SAMPLE_RATE_TIMEBASE = new AVRational();
    public static final long NUM_NANO_SEC_IN_MS = 1000000L;
    private ScheduledExecutorService audioPollerExecutor;
    private String userAgent;
    private long shutdownCompletelyTimer = -1L;

    protected void initializeVideoPacketTime(long timestampNs) {
        if (this.firstVideoPacketReceivedTime == 0L) {
            this.firstVideoPacketReceivedTime = System.currentTimeMillis();
            this.firstVideoTimestampMs = timestampNs / 1000000L;
            if (this.firstVideoPacketReceivedTime > this.firstAudioPacketReceivedTime && this.firstAudioPacketReceivedTime > 0L) {
                this.videoTimeOffsetMS = this.firstVideoPacketReceivedTime - this.firstAudioPacketReceivedTime;
            }
            logger.info("start time set in renderFrame  {} for stream: {} videoTimeOffsetMS: {}", new Object[]{this.firstVideoPacketReceivedTime, this.streamId, this.videoTimeOffsetMS});
        }
    }

    private void logDropVideoFrameInfo(long frameNumber) {
        ++this.log2DropVideoFrame;
        if (this.log2DropVideoFrame % 20 == 0) {
            logger.info("Dropping video frame. Pending Frame:{}, Frame number: {} Last Frame Number: {} Max Frame Queue Size: {} Received Audio Frame Count: {} Drop video frame count: {} for stream: {}", new Object[]{this.videoFramePending, frameNumber, this.lastFrameNumber, this.maxQueueVideoFrameSize, this.receivedAudioFrameCount.get(), this.droppedVideoFrameCount, this.streamId});
        }
    }

    private void encodeVideoRunner() {
        if (this.videoEncoderRunning.compareAndSet(false, true)) {
            VideoFrameContext videoFrameContext = null;
            while ((videoFrameContext = this.videoFrameQueue.poll()) != null) {
                if (!this.isStopped.get()) {
                    long frameNumber = this.getVideoFrameNumber(videoFrameContext.timestampMS);
                    if (frameNumber > this.lastFrameNumber && this.videoFramePending.get() < this.maxQueueVideoFrameSize) {
                        this.lastFrameNumber = frameNumber;
                        VideoFrame.Buffer buffer = videoFrameContext.videoFrame.getBuffer();
                        this.setVideoEncodeStartTime(System.currentTimeMillis());
                        this.prepareAndEncodeBuffer(videoFrameContext.timestampMS, frameNumber, buffer);
                        this.totalVideoEncoderTime += System.currentTimeMillis() - this.getVideoEncodeStartTime();
                        this.setVideoEncodeStartTime(0L);
                    } else {
                        this.logDropVideoFrameInfo(frameNumber);
                        ++this.droppedVideoFrameCount;
                    }
                }
                videoFrameContext.videoFrame.release();
                this.videoFramePending.decrementAndGet();
                ++this.videoFrameCount;
            }
            this.videoEncoderRunning.compareAndSet(true, false);
        }
    }

    public long getAudioDurationMs() {
        return (long)this.audioFrameProcessedCount.get() * 10L;
    }

    public long getVideoFrameNumber(long timestampMS) {
        long frameNumber = 0L;
        frameNumber = this.enableAudio ? this.getAudioDurationMs() * (long)this.getFrameRate() / 1000L : timestampMS * (long)this.getFrameRate() / 1000L;
        return frameNumber;
    }

    public long getVideoTime(long timestampMS) {
        return this.enableAudio ? this.getAudioDurationMs() : timestampMS;
    }

    public void prepareAndEncodeBuffer(long timestampMS, long frameNumber, VideoFrame.Buffer buffer) {
        try {
            if (buffer instanceof WrappedNativeI420Buffer) {
                WrappedNativeI420Buffer wrappedBuffer = (WrappedNativeI420Buffer)buffer;
                ByteBuffer[] yuvPlanes = new ByteBuffer[]{wrappedBuffer.getDataY(), wrappedBuffer.getDataU(), wrappedBuffer.getDataV()};
                int[] yuvStrides = new int[]{wrappedBuffer.getStrideY(), wrappedBuffer.getStrideU(), wrappedBuffer.getStrideV()};
                this.writeYuvPlanes(yuvPlanes, yuvStrides, buffer.getWidth(), buffer.getHeight(), frameNumber, timestampMS);
            }
        }
        catch (Exception e) {
            logger.error(ExceptionUtils.getStackTrace((Throwable)e));
        }
    }

    public void writeYuvPlanes(ByteBuffer[] yuvPlanes, int[] yuvStrides, int width, int height, long frameNumber, long captureTimeMS) {
        int totalSize = yuvPlanes[0].limit() + yuvPlanes[1].limit() + yuvPlanes[2].limit();
        if (this.frameData == null || this.frameData.length < totalSize) {
            this.frameData = new byte[totalSize];
        }
        yuvPlanes[0].get(this.frameData, 0, yuvPlanes[0].limit());
        int pos = yuvPlanes[0].limit();
        yuvPlanes[1].get(this.frameData, pos, yuvPlanes[1].limit());
        yuvPlanes[2].get(this.frameData, pos += yuvPlanes[1].limit(), yuvPlanes[2].limit());
        this.writeRawVideo(this.frameData, yuvStrides, totalSize, width, height, frameNumber, captureTimeMS);
    }

    public WebRTCEncoderAdaptor(ClientBroadcastStream clientBroadcastStream, TcpCluster clusterNotifier, Logging.Severity logLevel) {
        super(clientBroadcastStream);
        this.enableVideo = true;
        this.enableAudio = true;
        this.webrtcLogLevel = logLevel;
    }

    public void writeRawAudio(int numberOfFrames, int sampleRate, int numberOfChannels, byte[] audioData, long timestampMS) {
        AVFrame frame = this.createAudioFrame(numberOfFrames, sampleRate, numberOfChannels, audioData, timestampMS);
        if (!this.ready.get()) {
            logger.info("writeRawAudio returning because encoder adaptor is not ready {}", (Object)this.streamId);
            return;
        }
        FrameFeeder feeder = ((StreamAdaptor)this.streamAdaptorList.get(0)).getFrameFeeder();
        AVFrame processedFrame = feeder.onAudioFrame(frame);
        if (processedFrame != null) {
            for (StreamAdaptor streamAdaptor : this.streamAdaptorList) {
                for (AudioEncoder encoder : streamAdaptor.getAudioEncoderList()) {
                    try {
                        encoder.writeFrame(frame, this.getAudioStreamIndex(), timestampMS);
                    }
                    catch (Exception e) {
                        logger.error(ExceptionUtils.getStackTrace((Throwable)e));
                    }
                }
            }
        }
    }

    public AVFrame createAudioFrame(int numberOfFrames, int sampleRate, int channelCount, byte[] data, long timestampMS) {
        int ret;
        if (this.rawAudioFrame == null) {
            this.rawAudioFrame = avutil.av_frame_alloc();
            this.rawAudioFrame.pts(0L);
        }
        this.rawAudioFrame.nb_samples(numberOfFrames);
        this.rawAudioFrame.sample_rate(sampleRate);
        this.rawAudioFrame.format(1);
        this.rawAudioFrame.channels(channelCount);
        long localPts = timestampMS * (long)sampleRate / 1000L;
        this.rawAudioFrame.pts(localPts);
        this.rawAudioFrame.channel_layout(avutil.av_get_default_channel_layout((int)channelCount));
        int bufferSize = avutil.av_samples_get_buffer_size((IntPointer)null, (int)channelCount, (int)numberOfFrames, (int)1, (int)0);
        if (this.rawAudioBuffer == null || this.rawAudioBuffer.limit() < (long)bufferSize) {
            if (this.rawAudioBuffer != null) {
                avutil.av_free((Pointer)this.rawAudioBuffer);
            }
            this.rawAudioBuffer = new BytePointer(avutil.av_malloc((long)bufferSize)).capacity((long)bufferSize);
        }
        if ((ret = avcodec.avcodec_fill_audio_frame((AVFrame)this.rawAudioFrame, (int)channelCount, (int)1, (BytePointer)this.rawAudioBuffer, (int)bufferSize, (int)0)) < 0) {
            throw new IllegalStateException("avcodec_fill_audio_frame does not return successfully");
        }
        this.rawAudioBuffer.put(data, 0, data.length);
        this.rawAudioFrame.data(0, this.rawAudioBuffer);
        this.rawAudioFrame.linesize(0, numberOfFrames);
        return this.rawAudioFrame;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeRawVideo(byte[] frameData, int[] yuvStrides, int size, int width, int height, long frameNumber, long captureTimeMS) {
        if (!this.ready.get() && !this.restored.get()) {
            if (this.isStopped.get()) {
                logger.info("Streaming has stopped before it's prepared for stream: {}", (Object)this.streamId);
                return;
            }
            logger.info("preparing video encoder for stream {}", (Object)this.streamId);
            Object object = staticLock;
            synchronized (object) {
                this.prepareVideoEncoders(width, height);
            }
            object = this.lock;
            synchronized (object) {
                if (!this.isStopped.get()) {
                    this.startIOandNotify();
                }
            }
        }
        try {
            AVFrame frame = this.createVideoFrame(frameData, size, yuvStrides, width, height, frameNumber);
            FrameFeeder feeder = ((StreamAdaptor)this.streamAdaptorList.get(0)).getFrameFeeder();
            AVFrame processedFrame = feeder.onVideoFrame(frame);
            if (processedFrame != null) {
                for (StreamAdaptor streamAdaptor : this.streamAdaptorList) {
                    for (VideoEncoder encoder : streamAdaptor.getVideoEncoderList()) {
                        if (encoder.writeFrame(processedFrame, this.getVideoStreamIndex(), captureTimeMS)) continue;
                        logger.trace("Cannot encode video frame for stream:{} data size:{} strides:{},{},{} encoder:{}", new Object[]{this.streamId, size, yuvStrides[0], yuvStrides[1], yuvStrides[2], encoder.getCodecName()});
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error(ExceptionUtils.getStackTrace((Throwable)e));
        }
    }

    private void initializeRawBuffer(int size, int[] yuvStrides, int width, int height) {
        this.rawVideoBuffer = new BytePointer(avutil.av_malloc((long)size));
        this.rawVideoFrame.linesize(0, yuvStrides[0]);
        this.rawVideoFrame.linesize(1, yuvStrides[1]);
        this.rawVideoFrame.linesize(2, yuvStrides[2]);
        avutil.av_image_fill_pointers((PointerPointer)new PointerPointer((Pointer)this.rawVideoFrame), (int)0, (int)height, (BytePointer)this.rawVideoBuffer, (IntPointer)this.rawVideoFrame.linesize());
        this.rawVideoWidth = width;
        this.rawVideoHeight = height;
    }

    public synchronized AVFrame createVideoFrame(byte[] frameData, int size, int[] yuvStrides, int width, int height, long frameNumber) throws Exception {
        if (this.rawVideoFrame == null) {
            this.rawVideoFrame = avutil.av_frame_alloc();
            this.initializeRawBuffer(size, yuvStrides, width, height);
        }
        if (this.rawVideoWidth != width || this.rawVideoHeight != height) {
            avutil.av_free((Pointer)this.rawVideoBuffer);
            this.rawVideoBuffer = null;
            avutil.av_frame_free((AVFrame)this.rawVideoFrame);
            this.rawVideoFrame = null;
            this.rawVideoFrame = avutil.av_frame_alloc();
            this.initializeRawBuffer(size, yuvStrides, width, height);
        }
        this.rawVideoFrame.width(width);
        this.rawVideoFrame.height(height);
        this.rawVideoFrame.format(0);
        this.rawVideoFrame.pts(frameNumber);
        this.rawVideoBuffer.position(0L);
        this.rawVideoBuffer.put(frameData, 0, size);
        return this.rawVideoFrame;
    }

    @Override
    public boolean prepare() throws Exception {
        this.setFrameRateAndQueueSizes();
        if (!this.enableVideo) {
            this.buildOnlyAudioEncoders(true);
        } else {
            this.buildEncoders(0, true);
        }
        this.setupRtmpEndpoints();
        this.prepareAudioEncoder();
        if (!this.enableVideo) {
            this.startIOandNotify();
        }
        return true;
    }

    private void setFrameRateAndQueueSizes() {
        this.maxQueueVideoFrameSize = this.frameRate = this.getAppSettings().getWebRTCFrameRate();
        this.maxQueueAudioFrameSize = 1000 / this.getFrameRate() * this.maxQueueVideoFrameSize / 10;
    }

    protected void getWebRTCPublisherStats(RTCStatsReport report) {
        WebRTCAudioReceiveStats tmpAudioStats = new WebRTCAudioReceiveStats();
        WebRTCVideoReceiveStats tmpVideoStats = new WebRTCVideoReceiveStats();
        Map statsMap = report.getStatsMap();
        double timeMs = 0.0;
        for (Map.Entry entry : statsMap.entrySet()) {
            RTCStats remoteCandidate;
            String remoteCandidateId;
            RTCStats selectedPair;
            String selectedCandidatePairId;
            RTCStats value = (RTCStats)entry.getValue();
            if (INBOUND_RTP.equals(value.getType())) {
                timeMs = value.getTimestampUs() / 1000.0;
                long timeDiffSeconds = (long)((timeMs - this.lastKnownStatsTimeStampMs) / 1000.0);
                if (timeDiffSeconds == 0L) {
                    logger.error("Time difference in stats collecting is 0 in seconds and time difference {} in ms", (Object)(timeMs - this.lastKnownStatsTimeStampMs));
                    return;
                }
                if (AUDIO.equals(value.getMembers().get(MEDIA_TYPE))) {
                    long packetsReceived = (Long)value.getMembers().get(PACKETS_RECEIVED);
                    long packetsReceivedDiff = packetsReceived - this.lastKnownAudioPacketsReceived;
                    tmpAudioStats.setAudioPacketsReceived(packetsReceivedDiff);
                    tmpAudioStats.setAudioPacketsReceivedPerSecond(packetsReceivedDiff / timeDiffSeconds);
                    this.lastKnownAudioPacketsReceived = packetsReceived;
                    BigInteger bytesReceived = (BigInteger)value.getMembers().get(BYTES_RECEIVED);
                    BigInteger bytesReceivedDiff = bytesReceived.subtract(this.lastKnownAudioBytesReceived);
                    tmpAudioStats.setAudioBytesReceived(bytesReceived);
                    tmpAudioStats.setAudioBytesReceivedPerSecond(bytesReceivedDiff.divide(BigInteger.valueOf(timeDiffSeconds)));
                    this.lastKnownAudioBytesReceived = bytesReceived;
                    int packetsLost = (Integer)value.getMembers().get(PACKETS_LOST);
                    tmpAudioStats.setAudioPacketsLost(packetsLost);
                    double jitter = (Double)value.getMembers().get(JITTER);
                    tmpAudioStats.setAudioJitter(jitter);
                    logger.debug("audio stats: {}", (Object)value);
                    continue;
                }
                if (!VIDEO.equals(value.getMembers().get(MEDIA_TYPE))) continue;
                long firCount = (Long)value.getMembers().get(FIR_COUNT);
                tmpVideoStats.setVideoFirCount(firCount);
                long pliCount = (Long)value.getMembers().get(PLI_COUNT);
                tmpVideoStats.setVideoPliCount(pliCount);
                long nackCount = (Long)value.getMembers().get(NACK_COUNT);
                tmpVideoStats.setVideoNackCount(nackCount);
                long packetsReceived = (Long)value.getMembers().get(PACKETS_RECEIVED);
                long packetsReceivedDiff = packetsReceived - this.lastKnownVideoPacketsReceived;
                tmpVideoStats.setVideoPacketsReceived(packetsReceived);
                tmpVideoStats.setVideoPacketsReceivedPerSecond(packetsReceivedDiff / timeDiffSeconds);
                this.lastKnownVideoPacketsReceived = packetsReceived;
                BigInteger bytesReceived = (BigInteger)value.getMembers().get(BYTES_RECEIVED);
                BigInteger bytesReceivedDiff = bytesReceived.subtract(this.lastKnownVideoBytesReceived);
                tmpVideoStats.setVideoBytesReceived(bytesReceived);
                tmpVideoStats.setVideoBytesReceivedPerSecond(bytesReceivedDiff.divide(BigInteger.valueOf(timeDiffSeconds)));
                this.lastKnownVideoBytesReceived = bytesReceived;
                int packetsLost = (Integer)value.getMembers().get(PACKETS_LOST);
                tmpVideoStats.setVideoPacketsLost(packetsLost);
                logger.debug("video stats: {}", (Object)value);
                continue;
            }
            if (TRACK.equals(value.getType()) && VIDEO.equals(value.getMembers().get(KIND))) {
                timeMs = value.getTimestampUs() / 1000.0;
                long timeDiffSeconds = (long)((timeMs - this.lastKnownStatsTimeStampMs) / 1000.0);
                long framesReceived = (Long)value.getMembers().get(FRAMES_RECEIVED);
                long frameReceivedDiff = framesReceived - this.lastKnownVideoFramesReceived;
                tmpVideoStats.setVideoFrameReceived(framesReceived);
                tmpVideoStats.setVideoFrameReceivedPerSecond(frameReceivedDiff / timeDiffSeconds);
                this.lastKnownVideoFramesReceived = framesReceived;
                continue;
            }
            if (!TRANSPORT.equals(value.getType()) || (selectedCandidatePairId = (String)value.getMembers().get(SELECTED_CANDIDATE_PAIR_ID)) == null || (selectedPair = (RTCStats)statsMap.get(selectedCandidatePairId)) == null || (remoteCandidateId = (String)selectedPair.getMembers().get(REMOTE_CANDIDATE_ID)) == null || (remoteCandidate = (RTCStats)statsMap.get(remoteCandidateId)) == null) continue;
            this.remoteIp = (String)remoteCandidate.getMembers().get("ip");
        }
        this.videoReceivedStats = tmpVideoStats;
        this.audioReceivedStats = tmpAudioStats;
        this.lastKnownStatsTimeStampMs = timeMs;
        this.infoListener.avgBitrateMeasurement(this.streamId, tmpVideoStats.getVideoBytesReceivedPerSecond(), tmpAudioStats.getAudioBytesReceivedPerSecond());
    }

    protected void startIOandNotify() {
        this.prepareIO();
        this.streamingStartTimeMs = System.currentTimeMillis();
        this.infoListener.streamingStarted(this.getStreamId());
        this.startAdaptiveHLS();
        this.startOriginIfRequired();
        this.ready.set(true);
    }

    private void logTheStats(boolean writeToDatastore) {
        Broadcast broadcastLocal;
        long now = System.currentTimeMillis();
        long duration = now - this.streamingStartTimeMs;
        long totalByte = this.lastKnownVideoBytesReceived.longValue() + this.lastKnownAudioBytesReceived.longValue();
        long bitrate = totalByte / duration;
        logger.info("Publish Stats StreamId: {} TransferedByte: {} Stream Duration: {} Bitrate: {} Source IP: {} User-Agent: {}", new Object[]{this.streamId, totalByte, duration, bitrate, this.remoteIp, this.userAgent});
        if (writeToDatastore && (broadcastLocal = this.getDataStore().get(this.streamId)) != null) {
            broadcastLocal.setReceivedBytes(totalByte);
            broadcastLocal.setDuration(Long.valueOf(duration));
            broadcastLocal.setBitrate(bitrate);
            broadcastLocal.setIpAddr(this.remoteIp);
            broadcastLocal.setUserAgent(this.userAgent);
            this.getDataStore().updateBroadcastFields(this.streamId, broadcastLocal);
        }
    }

    public void setupRtmpEndpoints() {
        if (this.rtmpEndpointList != null && !this.rtmpEndpointList.isEmpty()) {
            StreamAdaptor rtmpStreamAdaptor = this.getStreamAdaptor(VideoCodec.H264, 0);
            if (rtmpStreamAdaptor != null) {
                this.addRtmpMuxer2Encoders(rtmpStreamAdaptor);
            } else {
                logger.warn("Rtmp endpoint cannot be added to stream:{}", (Object)this.streamId);
            }
        }
    }

    public void addRtmpMuxer2Encoders(StreamAdaptor rtmpStreamAdaptor) {
        VideoEncoder selectedVideoEncoder = null;
        for (VideoEncoder videoEncoder : rtmpStreamAdaptor.getVideoEncoderList()) {
            if (!(videoEncoder instanceof H264Encoder) && (!(videoEncoder instanceof SFUForwarder) || ((SFUForwarder)videoEncoder).getCodec() != VideoCodec.H264)) continue;
            selectedVideoEncoder = videoEncoder;
            break;
        }
        AudioEncoder selectedAudioEncoder = null;
        for (AudioEncoder audioEncoder : rtmpStreamAdaptor.getAudioEncoderList()) {
            if (!(audioEncoder instanceof AACEncoder)) continue;
            selectedAudioEncoder = audioEncoder;
            break;
        }
        this.addRtmpEndpoints(selectedVideoEncoder, selectedAudioEncoder);
    }

    public void addRtmpEndpoints(VideoEncoder videoEncoder, AudioEncoder audioEncoder) {
        logger.info("Adding rtmp endpoints to stream {} video encoder: {} audio encoder:{}", new Object[]{this.streamId, videoEncoder != null ? videoEncoder.getCodecName() : null, audioEncoder != null ? audioEncoder.getCodecName() : null});
        for (Endpoint endpoint : this.rtmpEndpointList) {
            List<Muxer> muxerList;
            RtmpMuxer rtmpMuxer = new RtmpMuxer(endpoint.getRtmpUrl(), this.vertx);
            rtmpMuxer.setStatusListener((IEndpointStatusListener)this);
            rtmpMuxer.init(this.scope, this.streamId, videoEncoder != null ? videoEncoder.getResolutionHeight() : 0, this.getBroadcast().getSubFolder(), videoEncoder != null ? videoEncoder.getBitrate() : 0);
            if (videoEncoder != null) {
                muxerList = videoEncoder.getMuxerList();
                if (muxerList instanceof ArrayList && muxerList.size() >= 2) {
                    muxerList.add(1, (Muxer)rtmpMuxer);
                } else {
                    videoEncoder.addMuxer((Muxer)rtmpMuxer);
                }
            }
            if (audioEncoder == null) continue;
            muxerList = audioEncoder.getMuxerList();
            if (muxerList instanceof ArrayList && muxerList.size() >= 2) {
                muxerList.add(1, (Muxer)rtmpMuxer);
                continue;
            }
            audioEncoder.addMuxer((Muxer)rtmpMuxer);
        }
    }

    private void prepareVideoEncoders(int width, int height) {
        logger.info("prepare video encoders with source width:{} source height:{}", (Object)width, (Object)height);
        try {
            for (StreamAdaptor streamAdaptor : this.streamAdaptorList) {
                for (VideoEncoder encoder : streamAdaptor.getVideoEncoderList()) {
                    try (AVRational videoCodecTimebase = new AVRational();){
                        videoCodecTimebase.num(1);
                        videoCodecTimebase.den(this.getFrameRate());
                        int gopSize = this.getFrameRate();
                        this.setVideoStreamIndex(1);
                        try (AVRational sampleAspectRatio = new AVRational();){
                            sampleAspectRatio.num(0);
                            sampleAspectRatio.den(0);
                            encoder.prepareCodec(width, height, videoCodecTimebase, sampleAspectRatio, gopSize, this.getVideoStreamIndex(), false, null);
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            this.infoListener.encoderNotOpenedError(this.streamId);
            this.stop(true);
            logger.error(ExceptionUtils.getStackTrace((Throwable)e));
        }
    }

    protected void prepareAudioEncoder() {
        for (StreamAdaptor streamAdaptor : this.streamAdaptorList) {
            for (AudioEncoder encoder : streamAdaptor.getAudioEncoderList()) {
                try {
                    this.setAudioStreamIndex(0);
                    encoder.prepareCodec(44100, (int)avutil.av_get_default_channel_layout((int)2), this.getAudioStreamIndex());
                }
                catch (Exception e) {
                    logger.error(ExceptionUtils.getStackTrace((Throwable)e));
                }
            }
        }
    }

    @Override
    public boolean init(IScope scope, String streamId, boolean isAppend) {
        this.packetFeeder = new PacketFeeder(streamId);
        this.scope = scope;
        this.setStreamId(streamId);
        this.enableSettings();
        this.initStorageClient();
        this.enableMp4Setting();
        this.initServerSettings();
        this.getStreamHandler().muxAdaptorAdded((MuxAdaptor)this);
        return true;
    }

    public VideoDecoderFactory getVideoDecoderFactory() {
        return null;
    }

    public VirtualVideoEncoderFactory getVideoEncoderFactory() {
        VirtualVideoEncoderFactory encoderFactory = null;
        if (!this.getAppSettings().isDefaultDecodersEnabled()) {
            encoderFactory = new VirtualVideoEncoderFactory(this.streamId, new ArrayList<String>(), this.getAppSettings());
        }
        return encoderFactory;
    }

    public PeerConnectionFactory createPeerConnectionFactory() {
        PeerConnectionFactory.initialize((PeerConnectionFactory.InitializationOptions)PeerConnectionFactory.InitializationOptions.builder().setFieldTrials(null).createInitializationOptions());
        VirtualVideoEncoderFactory encoderFactory = this.getVideoEncoderFactory();
        VideoDecoderFactory decoderFactory = this.getVideoDecoderFactory();
        AudioDecoderFactoryFactory audioDecoderFactoryFactory = this.getAudioDecoderFactoryFactory();
        PeerConnectionFactory.Options options = new PeerConnectionFactory.Options();
        options.disableNetworkMonitor = true;
        options.networkIgnoreMask = 16;
        this.adm = (JavaAudioDeviceModule)JavaAudioDeviceModule.builder(null).setUseHardwareAcousticEchoCanceler(false).setUseHardwareNoiseSuppressor(false).setAudioRecordErrorCallback(null).setAudioTrackErrorCallback(null).setAudioTrackListener(new IAudioTrackListener(){

            public void playoutStarted() {
                logger.info("starting playout for stream {}", (Object)WebRTCEncoderAdaptor.this.streamId);
                if (!WebRTCEncoderAdaptor.this.isSFU()) {
                    WebRTCEncoderAdaptor.this.initAudioTrackExecutor();
                }
            }

            public void playoutStopped() {
                logger.info("stopping playout for stream {}", (Object)WebRTCEncoderAdaptor.this.streamId);
            }
        }).createAudioDeviceModule();
        this.webRtcAudioTrack = this.adm.getAudioTrack();
        return PeerConnectionFactory.builder().setOptions(options).setAudioDeviceModule((AudioDeviceModule)this.adm).setAudioDecoderFactoryFactory(audioDecoderFactoryFactory).setVideoEncoderFactory((VideoEncoderFactory)encoderFactory).setVideoDecoderFactory(decoderFactory).createPeerConnectionFactory();
    }

    protected boolean isSFU() {
        return false;
    }

    protected void initializeAudioPacketTime(long timestamp) {
        if (this.firstAudioPacketReceivedTime == 0L) {
            this.firstAudioPacketReceivedTime = System.currentTimeMillis();
            this.firstAudioTimeStamp = timestamp;
            if (this.firstAudioPacketReceivedTime > this.firstVideoPacketReceivedTime && this.firstVideoPacketReceivedTime != 0L) {
                long timeOffsetMs = this.firstAudioPacketReceivedTime - this.firstVideoPacketReceivedTime;
                this.audioTimeOffsetInSampleRate = avutil.av_rescale_q_rnd((long)timeOffsetMs, (AVRational)TIME_BASE_FOR_MS, (AVRational)AUDIO_SAMPLE_RATE_TIMEBASE, (int)8197);
            }
            logger.info("start time set in onAudio {} for stream: {} audio time offset: {}", new Object[]{this.firstAudioPacketReceivedTime, this.streamId, this.audioTimeOffsetInSampleRate});
        }
    }

    public long getRelativeAudioTimeStamp(long timestamp) {
        this.initializeAudioPacketTime(timestamp);
        long relativeTimestamp = timestamp - this.firstAudioTimeStamp + this.audioTimeOffsetInSampleRate;
        if (logger.isTraceEnabled()) {
            long timestampMS = avutil.av_rescale_q_rnd((long)relativeTimestamp, (AVRational)AUDIO_SAMPLE_RATE_TIMEBASE, (AVRational)TIME_BASE_FOR_MS, (int)8197);
            long timeDiffMS = System.currentTimeMillis() - this.firstAudioPacketReceivedTime;
            logger.trace("audio incoming original timestamp {} relative timestampMS -> {} absolute time differenceMS:{}", new Object[]{timestamp, timestampMS, timeDiffMS});
        }
        this.audioFrameProcessedCount.incrementAndGet();
        return relativeTimestamp;
    }

    public AudioDecoderFactoryFactory getAudioDecoderFactoryFactory() {
        BuiltinAudioDecoderFactoryFactory antFactoryFactory = new BuiltinAudioDecoderFactoryFactory();
        antFactoryFactory.setCustomDecoder(this.isSFU());
        antFactoryFactory.setAudioPacketListener((data, timestamp) -> this.onOpusPacket(data, timestamp));
        return antFactoryFactory;
    }

    public void onOpusPacket(ByteBuffer data, long timestamp) {
    }

    public void start() {
        if (this.infoListener == null) {
            throw new IllegalStateException("Do not start with null infoListener");
        }
        this.debugStartFuntionCalledTime = System.currentTimeMillis();
        this.ready.set(false);
        this.isStopped.set(false);
        this.executeOnSignallingThread(() -> {
            this.setupEncoderThreadChecker();
            this.infoListener.requestAccepted(this.getStreamId());
        });
        this.webRTCVertx.setTimer((long)this.getAppSettings().getWebRTCClientStartTimeoutMs(), l -> {
            if (!this.ready.get()) {
                logger.warn("WebRTC ingest is not started. So publish timeout is firing for stream: {}", (Object)this.streamId);
                this.infoListener.publishTimeoutError(this.streamId);
                this.stop(true);
            }
        });
    }

    public void initPeerConnection() {
        try {
            MediaConstraints mediaConstraints = new MediaConstraints();
            this.setSdpMediaConstraints(mediaConstraints);
            ArrayList<PeerConnection.IceServer> iceServers = new ArrayList<PeerConnection.IceServer>();
            if (!this.getAppSettings().getStunServerURI().isEmpty()) {
                this.stunServerUri = this.getAppSettings().getStunServerURI();
            }
            iceServers.add(PeerConnection.IceServer.builder((String)this.stunServerUri).createIceServer());
            PeerConnection.RTCConfiguration rtcConfig = new PeerConnection.RTCConfiguration(iceServers);
            rtcConfig.enableDtlsSrtp = true;
            rtcConfig.disableIpv6 = this.getAppSettings().isDisableIPv6Candidates();
            rtcConfig.enableCpuOveruseDetection = false;
            if (this.peerConnectionFactory == null) {
                this.peerConnectionFactory = this.createPeerConnectionFactory();
            }
            rtcConfig.minPort = this.getAppSettings().getWebRTCPortRangeMin();
            rtcConfig.maxPort = this.getAppSettings().getWebRTCPortRangeMax();
            rtcConfig.tcpCandidatePolicy = this.getAppSettings().isWebRTCTcpCandidatesEnabled() ? PeerConnection.TcpCandidatePolicy.ENABLED : PeerConnection.TcpCandidatePolicy.DISABLED;
            rtcConfig.portAllocatorFlags = this.getAppSettings().getPortAllocatorFlags();
            rtcConfig.sdpSemantics = this.getAppSettings().getWebRTCSdpSemantics().equals("unifiedPlan") ? PeerConnection.SdpSemantics.UNIFIED_PLAN : PeerConnection.SdpSemantics.PLAN_B;
            this.peerConnection = this.peerConnectionFactory.createPeerConnection(rtcConfig, (PeerConnection.Observer)this);
            Logging.enableLogToDebugOutput((Logging.Severity)this.webrtcLogLevel);
        }
        catch (Exception e) {
            logger.error(ExceptionUtils.getStackTrace((Throwable)e));
        }
    }

    protected void setupEncoderThreadChecker() {
        int encodingTimeout = this.getAppSettings().getEncodingTimeout();
        if (encodingTimeout > 0) {
            this.encoderHealthCheckerId = this.vertx.setPeriodic((long)encodingTimeout, id -> {
                if (this.isStopped.get()) {
                    logger.info("Encoder health check is returning because encoder adaptor is stopped for {}", (Object)this.streamId);
                    return;
                }
                long now = System.currentTimeMillis();
                long videoStartTimeLocal = this.getVideoEncodeStartTime();
                long audioStartTimeLocal = this.getAudioEncodeStartTime();
                long videoThreadBlockedTime = now - videoStartTimeLocal;
                long audioThreadBlockedTime = now - audioStartTimeLocal;
                if (videoStartTimeLocal != 0L && videoThreadBlockedTime > (long)encodingTimeout || audioStartTimeLocal != 0L && audioThreadBlockedTime > (long)encodingTimeout) {
                    logger.error("Encoder has been blocked(video block time:{}, audio block time:{}) more than {} for stream:{}  ", new Object[]{videoThreadBlockedTime, audioThreadBlockedTime, encodingTimeout, this.streamId});
                    this.infoListener.encoderBlockedError(this.streamId, true);
                    this.stop(false);
                }
            });
        }
    }

    public void onSignalingChange(PeerConnection.SignalingState newState) {
        logger.debug("onSignalingChange new state: {}", (Object)newState);
    }

    public void onIceConnectionChange(PeerConnection.IceConnectionState newState) {
        logger.info("onIceConnectionChange {} for streamId: {} hash:{}", new Object[]{newState, this.streamId, this.hashCode()});
        if (newState != PeerConnection.IceConnectionState.CONNECTED && (newState == PeerConnection.IceConnectionState.FAILED || newState == PeerConnection.IceConnectionState.CLOSED)) {
            this.stop(false);
        }
    }

    public void onIceConnectionReceivingChange(boolean receiving) {
        logger.debug("onIceConnectionReceivingChange new state: {}", (Object)receiving);
    }

    public void onIceGatheringChange(PeerConnection.IceGatheringState newState) {
        logger.debug("onIceGatheringChange new state: {}", (Object)newState);
    }

    public void setServerAddress(String serverAddress) {
        this.serverAddress = serverAddress;
    }

    public void setReplaceCandidateAddressWithServerAddress(boolean replaceCandidateAddressWithServerAddress) {
        this.replaceCandidateAddressWithServerAddress = replaceCandidateAddressWithServerAddress;
    }

    public void onIceCandidate(IceCandidate candidate) {
        String sdp = candidate.sdp;
        if (!sdp.contains("127.0.0.1") && !sdp.contains("::1")) {
            IceCandidate candidateTmp = WebRTCEncoderAdaptor.getCandidate(candidate, this.replaceCandidateAddressWithServerAddress, this.serverAddress, logger);
            logger.info("onIceCandidate: {} stream id: {}", (Object)candidateTmp, (Object)this.streamId);
            this.executeOnSignallingThread(() -> this.infoListener.iceCandidateReceived(candidateTmp, this.getStreamId()));
        }
    }

    public static IceCandidate getCandidate(IceCandidate candidate, boolean replaceCandidateAddressWithServerAddress, String serverAddress, Logger logger) {
        if (replaceCandidateAddressWithServerAddress) {
            if (serverAddress != null && !serverAddress.isEmpty()) {
                String sdp = candidate.sdp.replaceFirst(IPV4_REGEX, serverAddress);
                return new IceCandidate(candidate.sdpMid, candidate.sdpMLineIndex, sdp);
            }
            logger.warn("Candidate address should be replaces with Server addr but there is no server address. Set in conf/red5.properties");
        }
        return candidate;
    }

    public void onIceCandidatesRemoved(IceCandidate[] candidates) {
        logger.info("onIceCandidatesRemoved: {}", (Object[])candidates);
    }

    private void logWaitingForEncoder(int audioFrameLogCounter) {
        if (audioFrameLogCounter % 50 == 0) {
            logger.info("Waiting for encoder to be ready for {} hash:{}", (Object)this.streamId, (Object)this.hashCode());
        }
    }

    private void logPendingAudioFrames(long totalAudioFrameInterval) {
        if (this.receivedAudioFrameCount.get() > 0) {
            float avgAudioEntranceInterval = (float)totalAudioFrameInterval / (float)this.receivedAudioFrameCount.get();
            if (this.audioFramePending.get() > 2 || avgAudioEntranceInterval < 9.0f) {
                logger.info("Pending audio frames: {}, audio thread entrance interval: {}ms, total received audio frames: {} for stream {} hash: {}", new Object[]{this.audioFramePending, Float.valueOf(avgAudioEntranceInterval), this.receivedAudioFrameCount.get(), this.streamId, this.hashCode()});
            }
        }
    }

    public void initAudioTrackExecutor() {
        if (this.audioEncoderExecutorFuture != -1L) {
            logger.info("init audio track executore is already initialized");
            return;
        }
        this.audioEncoderExecutorFuture = this.webRTCVertx.setPeriodic(10L, l -> {
            if (this.isStopped.get()) {
                logger.info("Encode audio runner is returning because encoder adaptor is stopped for {}", (Object)this.streamId);
                return;
            }
            this.webRTCVertx.executeBlocking(b -> {
                try {
                    this.encodeAudioRunner();
                }
                catch (Exception e) {
                    logger.error(ExceptionUtils.getStackTrace((Throwable)e));
                }
                b.complete();
            }, null);
        });
        NamedThreadFactory threadFactory = new NamedThreadFactory("audio-poller-" + this.streamId);
        this.audioPollerExecutor = Executors.newSingleThreadScheduledExecutor((ThreadFactory)threadFactory);
        this.audioTrackFuture = this.audioPollerExecutor.scheduleAtFixedRate(() -> {
            try {
                if (this.isStopped.get()) {
                    logger.info("Get audio is returning because encoder adaptor is stopped for {}", (Object)this.streamId);
                    return;
                }
                ++this.audioFrameLogCounter;
                if (!this.ready.get()) {
                    this.logWaitingForEncoder(this.audioFrameLogCounter);
                    if (this.audioFrameLogCounter > this.readyTimeoutSeconds * 100) {
                        this.infoListener.publishTimeoutError(this.streamId);
                        logger.warn("It's stopping publish due to timeout. It's likely no video received or encoder is not opened for stream: {}", (Object)this.streamId);
                        this.stop(true);
                    }
                    return;
                }
                if (this.firstAudioPacketReceivedTime == 0L) {
                    this.firstAudioPacketReceivedTime = System.currentTimeMillis();
                }
                this.audioFramePending.incrementAndGet();
                if (this.audioFrameLogCounter % 300 == 0) {
                    this.logPendingAudioFrames(this.totalAudioFrameInterval);
                    this.audioFrameLogCounter = 0;
                }
                long now = System.currentTimeMillis();
                long timestampMS = now - this.firstAudioPacketReceivedTime;
                this.totalAudioFrameInterval += this.lasttAudioTimeStamp != 0L ? now - this.lasttAudioTimeStamp : 0L;
                this.receivedAudioFrameCount.incrementAndGet();
                this.lasttAudioTimeStamp = now;
                ByteBuffer playoutData = this.webRtcAudioTrack.getPlayoutData();
                int readSizeInBytes = this.webRtcAudioTrack.getReadSizeInBytes();
                byte[] audioData = new byte[readSizeInBytes];
                int numberOfFrames = readSizeInBytes / this.webRtcAudioTrack.getBytesPerSample();
                playoutData.get(audioData, 0, audioData.length);
                this.audioFrameQueue.offer(new AudioFrameContext(audioData, timestampMS, numberOfFrames, this.webRtcAudioTrack.getChannels(), this.webRtcAudioTrack.getSampleRate()));
            }
            catch (Exception e) {
                logger.error(ExceptionUtils.getStackTrace((Throwable)e));
            }
        }, 10L, 10L, TimeUnit.MILLISECONDS);
    }

    private void encodeAudioRunner() {
        if (!this.ready.get()) {
            this.logWaitingForEncoder(this.audioFrameLogCounter);
            if (this.receivedAudioFrameCount.get() > this.readyTimeoutSeconds * 100) {
                this.infoListener.publishTimeoutError(this.streamId);
                logger.warn("It's stopping publish due to timeout. It's likely no video received or encoder is not opened for stream: {}", (Object)this.streamId);
                this.stop(true);
            }
            return;
        }
        if (this.audioEncoderRunning.compareAndSet(false, true)) {
            AudioFrameContext audioFrameContext = null;
            while ((audioFrameContext = this.audioFrameQueue.poll()) != null) {
                if (!this.isStopped.get()) {
                    if (this.audioFramePending.get() < this.maxQueueAudioFrameSize) {
                        this.audioFrameProcessedCount.incrementAndGet();
                        this.setAudioEncodeStartTime(System.currentTimeMillis());
                        this.writeRawAudio(audioFrameContext.numberOfFrames, audioFrameContext.sampleRate, audioFrameContext.channels, audioFrameContext.data, audioFrameContext.timestampMs);
                        this.totalAudioEncoderTime += System.currentTimeMillis() - this.getAudioEncodeStartTime();
                        this.setAudioEncodeStartTime(0L);
                    } else {
                        logger.warn(" dropping audio frame, pending audio frame: {} bytes per sample: {} max queue size:{}", new Object[]{this.audioFramePending, this.webRtcAudioTrack.getBytesPerSample(), this.maxQueueAudioFrameSize});
                        ++this.droppedAudioFrameCount;
                    }
                }
                this.audioFramePending.decrementAndGet();
                ++this.audioFrameCount;
            }
            this.audioEncoderRunning.compareAndSet(true, false);
        }
    }

    public void onAddStream(MediaStream stream) {
        logger.info("onAddStream for streamId {}", (Object)this.streamId);
        if (this.videoEncoderExecutorSchedule != -1L) {
            logger.warn("Video encoder is already scheduled for stream: {}", (Object)this.streamId);
            return;
        }
        if (!stream.videoTracks.isEmpty()) {
            this.videoTrack = (VideoTrack)stream.videoTracks.get(0);
            if (this.videoTrack != null) {
                this.videoTrack.addSink(this.getVideoSink());
                this.videoEncoderExecutorSchedule = this.webRTCVertx.setPeriodic(10L, l -> {
                    if (this.isStopped.get()) {
                        logger.info("Encode video runner is returning because encoder adaptor is stopped for {}", (Object)this.streamId);
                        return;
                    }
                    this.webRTCVertx.executeBlocking(b -> {
                        try {
                            this.encodeVideoRunner();
                        }
                        catch (Exception e) {
                            logger.error(ExceptionUtils.getStackTrace((Throwable)e));
                        }
                        b.complete();
                    }, null);
                });
            }
        }
    }

    private VideoSink getVideoSink() {
        if (this.videoSink == null) {
            this.videoSink = new VideoSinkCallback();
        }
        return this.videoSink;
    }

    public void onRemoveStream(MediaStream stream) {
        logger.info("onRemoveStream for stream Id {}", (Object)this.streamId);
    }

    public void onDataChannel(DataChannel dataChannel) {
        logger.info("onDataChannel for stream Id {}", (Object)this.streamId);
        if (this.getAppSettings().isDataChannelEnabled()) {
            this.dataChannel = dataChannel;
            this.getDataChannelRouter().addPublisher(this.streamId, this);
            dataChannel.registerObserver(new DataChannel.Observer(){

                public void onStateChange() {
                    logger.info("DataChannel State Change for stream Id {}", (Object)WebRTCEncoderAdaptor.this.streamId);
                }

                public void onMessage(DataChannel.Buffer buffer) {
                    logger.debug("DataChannel message received stream Id {}", (Object)WebRTCEncoderAdaptor.this.streamId);
                    byte[] data = new byte[buffer.data.capacity()];
                    buffer.data.get(data);
                    boolean binary = buffer.binary;
                    WebRTCEncoderAdaptor.this.signallingContext.runOnContext(l -> {
                        try {
                            WebRTCEncoderAdaptor.this.getDataChannelRouter().publisherMessageReceived(WebRTCEncoderAdaptor.this.streamId, data, binary);
                        }
                        catch (Exception e) {
                            logger.error(ExceptionUtils.getStackTrace((Throwable)e));
                        }
                    });
                }

                public void onBufferedAmountChange(long previousAmount) {
                    logger.debug("DataChannel Buffered Amount has changed from {} for streamId: {}", (Object)previousAmount, (Object)WebRTCEncoderAdaptor.this.streamId);
                }
            });
        } else {
            logger.warn("DataChannel is closed because it is not enabled");
            dataChannel.close();
            dataChannel.dispose();
        }
    }

    public void onRenegotiationNeeded() {
        logger.info("onRenegotiationNeeded for stream Id {}", (Object)this.streamId);
    }

    public void onAddTrack(RtpReceiver receiver, MediaStream[] mediaStreams) {
        logger.info("onAddTrack for streamId {}", (Object)this.streamId);
    }

    public void setRemoteDescription(SessionDescription sdp) {
        try {
            this.remoteDescription = sdp;
            logger.info("before prepare for {} hash: {}", (Object)this.getStreamId(), (Object)this.hashCode());
            if (!this.restored.get()) {
                if (this.prepare()) {
                    this.isRecording.set(true);
                    logger.info("after prepare for {} hash:{}", (Object)this.getStreamId(), (Object)this.hashCode());
                }
            } else {
                logger.info("Session is restored for stream:{}", (Object)this.streamId);
                this.ready.set(true);
                this.restored.set(false);
                if (this.shutdownCompletelyTimer != -1L) {
                    logger.info("Cancelling shutdown completely timer for {}", (Object)this.streamId);
                    this.webRTCVertx.cancelTimer(this.shutdownCompletelyTimer);
                    this.shutdownCompletelyTimer = -1L;
                }
                this.infoListener.streamingSessionRestored(this.getStreamId());
            }
            if (this.remoteDescription != null) {
                this.executeOnSignallingThread(() -> {
                    if (this.isStopped.get()) {
                        logger.warn("Broadcasting is stopped before it's started for {}", (Object)this.streamId);
                        return;
                    }
                    this.initPeerConnection();
                    this.peerConnection.setRemoteDescription((SdpObserver)this, sdp);
                    this.statTimer = this.scheduleAtFixedRateOnSignallingThread(() -> {
                        if (this.isStopped.get()) {
                            logger.error("Get stats called after WebRTC Encoder is stopped for {} client:{} isStopped:{} isNull:{}", new Object[]{this.getStreamId(), this.hashCode(), this.isStopped.get(), this.peerConnection == null});
                            return;
                        }
                        this.peerConnection.getStats(report -> {
                            if (report == null) {
                                return;
                            }
                            this.getWebRTCPublisherStats(report);
                            this.logTheStats(false);
                        });
                    }, 10000L);
                });
            } else {
                logger.error("remote description is null for stream:{}", (Object)this.streamId);
            }
        }
        catch (Exception e) {
            logger.error(ExceptionUtils.getStackTrace((Throwable)e));
        }
    }

    public void onCreateSuccess(final SessionDescription sdp) {
        if (logger.isDebugEnabled()) {
            logger.debug("onCreate Success: {}", (Object)sdp);
        }
        this.executeOnSignallingThread(() -> this.peerConnection.setLocalDescription(new SdpObserver(){

            public void onSetSuccess() {
                String type = sdp.type == SessionDescription.Type.ANSWER ? "answer" : "offer";
                WebRTCEncoderAdaptor.this.infoListener.localDescriptionSet(sdp.description, type, WebRTCEncoderAdaptor.this.getStreamId());
                WebRTCEncoderAdaptor.this.localDescriptionSet = true;
            }

            public void onSetFailure(String error) {
                logger.error("Cannot set local description for {} error: {}", (Object)WebRTCEncoderAdaptor.this.getStreamId(), (Object)error);
                WebRTCEncoderAdaptor.this.infoListener.localDescriptionFailure(WebRTCEncoderAdaptor.this.getStreamId());
            }

            public void onCreateSuccess(SessionDescription sdp2) {
            }

            public void onCreateFailure(String error) {
            }
        }, sdp));
    }

    public void onSetSuccess() {
        logger.debug("onSetSuccess for {}", (Object)this.streamId);
        this.remoteDescriptionSet = true;
        this.executeOnSignallingThread(() -> {
            logger.info("onSetSuccess signalling thread for {} ice candidate queue size: {}", (Object)this.streamId, (Object)this.iceCandidateQueue.size());
            if (this.isStopped.get()) {
                logger.warn("onSetSuccess is called after WebRTC Encoder is stopped for {} client:{} isStopped:{} isNull:{}", new Object[]{this.getStreamId(), this.hashCode(), this.isStopped.get(), this.peerConnection == null});
                return;
            }
            Iterator iterator = this.iceCandidateQueue.iterator();
            while (iterator.hasNext()) {
                IceCandidate iceCandidate = (IceCandidate)iterator.next();
                logger.debug("onSetSuccess iceCandidateQueue for {}", (Object)this.streamId);
                if (!this.peerConnection.addIceCandidate(iceCandidate)) {
                    logger.warn("Ice canddidate cannot be added for stream:{} candidate:{}", (Object)this.streamId, (Object)iceCandidate);
                }
                iterator.remove();
            }
            this.peerConnection.createAnswer((SdpObserver)this, this.getSdpMediaConstraints());
        });
    }

    public MediaConstraints getSdpMediaConstraints() {
        return this.sdpMediaConstraints;
    }

    public void setSdpMediaConstraints(MediaConstraints sdpMediaConstraints) {
        this.sdpMediaConstraints = sdpMediaConstraints;
    }

    public void onCreateFailure(String error) {
        logger.info("onCreateFailure: {} ", (Object)error);
    }

    public void onSetFailure(String error) {
        logger.info("onSetFailure: {}", (Object)error);
        this.infoListener.remoteDescriptionFailure(this.getStreamId());
    }

    public void addIceCandidate(IceCandidate iceCandidate) {
        logger.debug("addIceCandidate: {}", (Object)iceCandidate);
        if (this.peerConnection != null && this.remoteDescriptionSet) {
            this.executeOnSignallingThread(() -> {
                if (this.isStopped.get()) {
                    logger.warn("addIceCandidate is called after stream is stopped {}", (Object)this.streamId);
                    return;
                }
                this.peerConnection.addIceCandidate(iceCandidate);
            });
        } else {
            this.iceCandidateQueue.add(iceCandidate);
            if (this.peerConnection == null) {
                logger.warn("Ice candidate will be added later for stream Id {}. PeerConnection null", (Object)this.streamId);
            } else {
                logger.warn("Ice candidate will be added later for stream Id {}. Remote Description not set", (Object)this.streamId);
            }
        }
    }

    public synchronized void shutdownAdaptorsAndMuxers() {
        if (!this.isRecording.get()) {
            logger.info("WebRTCEncoderAdaptor recording is already stopped for stream:{}", (Object)this.streamId);
            return;
        }
        logger.info("Shutting down adaptors and muxers for stream:{}", (Object)this.streamId);
        this.isRecording.set(false);
        if (this.dataChannelRouter != null) {
            this.getDataChannelRouter().removePublisher(this.streamId, this);
        }
        this.stopAdaptiveHLS();
        this.getStreamHandler().muxAdaptorRemoved((MuxAdaptor)this);
        for (StreamAdaptor streamAdaptor : this.streamAdaptorList) {
            streamAdaptor.stop();
        }
        this.streamingStopTimeMs = System.currentTimeMillis();
    }

    public void stop(boolean stopCompletely) {
        logger.info("entering stop() for {} stopCompetely:{}", (Object)this.streamId, (Object)stopCompletely);
        if (this.isStopped.get()) {
            logger.info("Encoder is already stopped, returning for {}", (Object)this.streamId);
            return;
        }
        this.isStopped.set(true);
        if (!stopCompletely) {
            this.infoListener.streamingBeingStop(this.streamId, this);
        }
        this.releaseIntermediateResources();
        this.executeOnSignallingThread(() -> {
            logger.info("Entering the releasing resources for streamId: {}", (Object)this.streamId);
            this.releaseIntermediateResources();
            this.shutdownInternalPeerConnection();
            if (stopCompletely) {
                this.shutdownAdaptorsAndMuxers();
                Object object = this.lock;
                synchronized (object) {
                    this.infoListener.streamingStopped(this.getStreamId());
                }
            } else {
                this.shutdownCompletelyTimer = this.webRTCVertx.setTimer((long)this.getAppSettings().getWebRTCClientStartTimeoutMs(), h -> {
                    if (!this.isRestored()) {
                        this.shutdownAdaptorsAndMuxers();
                        Object object = this.lock;
                        synchronized (object) {
                            this.infoListener.streamingStopped(this.getStreamId());
                        }
                    }
                });
            }
        });
    }

    private void releaseIntermediateResources() {
        if (this.audioTrackFuture != null) {
            this.audioTrackFuture.cancel(false);
            this.audioPollerExecutor.shutdown();
            this.audioPollerExecutor = null;
            this.audioTrackFuture = null;
        }
        if (this.rawVideoFrame != null) {
            avutil.av_frame_free((AVFrame)this.rawVideoFrame);
            this.rawVideoFrame.close();
            this.rawVideoFrame = null;
        }
        if (this.rawAudioFrame != null) {
            avutil.av_frame_free((AVFrame)this.rawAudioFrame);
            this.rawAudioFrame.close();
            this.rawAudioFrame = null;
        }
        if (this.rawVideoBuffer != null) {
            avutil.av_free((Pointer)this.rawVideoBuffer);
            this.rawVideoBuffer.close();
            this.rawVideoBuffer = null;
        }
        if (this.rawAudioBuffer != null) {
            avutil.av_free((Pointer)this.rawAudioBuffer.position(0L));
            this.rawAudioBuffer.close();
            this.rawAudioBuffer = null;
        }
    }

    public void setStoppedForTest(boolean value) {
        this.isStopped.set(value);
    }

    public void shutdownInternalPeerConnection() {
        logger.error("shutdownInternalPeerConnection for stream: {} ", (Object)this.streamId);
        try {
            logger.info("running stop operations in executor for stream: {} Received audio frame: {}  Processed audio frame: {}Received video frame: {}  Processed video frame: {}", new Object[]{this.streamId, this.receivedAudioFrameCount.get(), this.audioFrameCount, this.receivedVideoFrameCount, this.videoFrameCount});
            if (this.videoFrameCount > 0) {
                long avarageVideoEncoderTime = this.totalVideoEncoderTime / (long)this.videoFrameCount;
                logger.info("Total video encode time {}ms, average video encode time {}ms for stream: {}", new Object[]{this.totalVideoEncoderTime, avarageVideoEncoderTime, this.streamId});
            }
            if (this.audioFrameCount > 0) {
                long avarageAudioEncoderTime = this.totalAudioEncoderTime / (long)this.audioFrameCount;
                logger.info("Total audio encode time {}ms, average audio encode time {}ms for stream: {} ", new Object[]{this.totalAudioEncoderTime, avarageAudioEncoderTime, this.streamId});
            }
            this.logTheStats(true);
            if (this.dataChannel != null) {
                this.dataChannel.dispose();
                this.dataChannel = null;
            }
            if (this.peerConnection != null) {
                this.peerConnection.dispose();
                this.peerConnection = null;
            }
            if (this.peerConnectionFactory != null) {
                this.peerConnectionFactory.dispose();
                this.peerConnectionFactory = null;
            }
            this.stopTimers();
            this.videoSink = null;
            if (this.adm != null) {
                this.adm.release();
                this.adm = null;
                this.webRtcAudioTrack = null;
            }
            logger.info("leaving stop() for {}", (Object)this.getStreamId());
        }
        catch (Exception e) {
            logger.error(ExceptionUtils.getStackTrace((Throwable)e));
        }
    }

    public void stopTimers() {
        if (this.videoEncoderExecutorSchedule != -1L) {
            this.webRTCVertx.cancelTimer(this.videoEncoderExecutorSchedule);
            this.videoEncoderExecutorSchedule = -1L;
        }
        if (this.audioEncoderExecutorFuture != -1L) {
            this.webRTCVertx.cancelTimer(this.audioEncoderExecutorFuture);
            this.audioEncoderExecutorFuture = -1L;
        }
        if (this.encoderHealthCheckerId != -1L) {
            this.vertx.cancelTimer(this.encoderHealthCheckerId);
            this.encoderHealthCheckerId = -1L;
        }
        if (this.statTimer != -1L) {
            this.webRTCVertx.cancelTimer(this.statTimer);
            this.statTimer = -1L;
        }
    }

    public PeerConnectionFactory getPeerConnectionFactory() {
        return this.peerConnectionFactory;
    }

    public void setPeerConnectionFactory(PeerConnectionFactory peerConnectionFactory) {
        this.peerConnectionFactory = peerConnectionFactory;
    }

    public void setTrackEnable(boolean enableVideo, boolean enableAudio) {
        this.enableVideo = enableVideo;
        this.enableAudio = enableAudio;
    }

    public void setVideoSink(VideoSink videoSink) {
        this.videoSink = videoSink;
    }

    public long getDebugStartFuntionCalledTime() {
        return this.debugStartFuntionCalledTime;
    }

    public void setDebugStartFuntionCalledTime(long debugStartFuntionCalledTime) {
        this.debugStartFuntionCalledTime = debugStartFuntionCalledTime;
    }

    public long getFirstPacketReceivedTime() {
        return this.firstVideoPacketReceivedTime;
    }

    public void setFirstPacketReceivedTime(long firstPacketReceivedTime) {
        this.firstVideoPacketReceivedTime = firstPacketReceivedTime;
    }

    public int getDroppedVideoFrameCount() {
        return this.droppedVideoFrameCount;
    }

    public int getDroppedAudioFrameCount() {
        return this.droppedAudioFrameCount;
    }

    public AtomicBoolean getReady() {
        return this.ready;
    }

    public void setReady(AtomicBoolean ready) {
        this.ready = ready;
    }

    public WebRTCStreamInfoListener getInfoListener() {
        return this.infoListener;
    }

    public void setInfoListener(WebRTCStreamInfoListener infoListener) {
        this.infoListener = infoListener;
    }

    public int getReceivedAudioFrameCount() {
        return this.receivedAudioFrameCount.get();
    }

    public ScheduledFuture<?> getAudioTrackFuture() {
        return this.audioTrackFuture;
    }

    public void setRtmpEndpointList(List<Endpoint> endPointList) {
        this.rtmpEndpointList = endPointList;
    }

    public VideoTrack getVideoTrack() {
        return this.videoTrack;
    }

    public long getStreamingStopTimeMs() {
        return this.streamingStopTimeMs;
    }

    public long getStreamingStartTimeMs() {
        return this.streamingStartTimeMs;
    }

    public int getFrameRate() {
        return this.frameRate;
    }

    public void setFrameRate(int frameRate) {
        this.frameRate = frameRate;
    }

    public Queue<IceCandidate> getIceCandidateQueue() {
        return this.iceCandidateQueue;
    }

    public boolean isRemoteDescriptionSet() {
        return this.remoteDescriptionSet;
    }

    public void setRemoteDescriptionSetForTest(boolean remoteDescriptionSet) {
        this.remoteDescriptionSet = remoteDescriptionSet;
    }

    public boolean isLocalDescriptionSet() {
        return this.localDescriptionSet;
    }

    protected void executeOnSignallingThread(Runnable command) {
        this.signallingContext.runOnContext(l -> {
            try {
                command.run();
            }
            catch (Exception e) {
                logger.error(ExceptionUtils.getStackTrace((Throwable)e));
            }
        });
    }

    public long scheduleAtFixedRateOnSignallingThread(Runnable command, long period) {
        return this.webRTCVertx.setPeriodic(period, h -> this.signallingContext.runOnContext(l -> {
            try {
                command.run();
            }
            catch (Exception e) {
                logger.error(ExceptionUtils.getStackTrace((Throwable)e));
            }
        }));
    }

    public void setWebRtcAudioTrack(WebRtcAudioTrack webRtcAudioTrack) {
        this.webRtcAudioTrack = webRtcAudioTrack;
    }

    public boolean isStopped() {
        return this.isStopped.get();
    }

    public void setReadyTimeoutSeconds(int readyTimeoutSeconds) {
        this.readyTimeoutSeconds = readyTimeoutSeconds;
    }

    public int getReadyTimeoutSeconds() {
        return this.readyTimeoutSeconds;
    }

    public long getEncoderHealthCheckerId() {
        return this.encoderHealthCheckerId;
    }

    public WebRTCVideoReceiveStats getVideoReceivedStats() {
        return this.videoReceivedStats;
    }

    public WebRTCAudioReceiveStats getAudioReceivedStats() {
        return this.audioReceivedStats;
    }

    public PeerConnection getPeerConnection() {
        return this.peerConnection;
    }

    public long getVideoEncodeStartTime() {
        return this.videoEncodeStartTime;
    }

    public void setVideoEncodeStartTime(long videoEncodeStartTime) {
        this.videoEncodeStartTime = videoEncodeStartTime;
    }

    public long getAudioEncodeStartTime() {
        return this.audioEncodeStartTime;
    }

    public void setAudioEncodeStartTime(long audioEncodeStartTime) {
        this.audioEncodeStartTime = audioEncodeStartTime;
    }

    @Override
    public void sendMessageViaDataChannel(DataChannel.Buffer buffer) {
        super.sendMessageViaDataChannel(buffer);
        this.executeOnSignallingThread(() -> this.dataChannel.send(buffer));
    }

    public DataChannelRouter getDataChannelRouter() {
        return this.dataChannelRouter;
    }

    public void setDataChannelRouter(DataChannelRouter dataChannelRouter) {
        this.dataChannelRouter = dataChannelRouter;
    }

    public SessionDescription getRemoteDescription() {
        return this.remoteDescription;
    }

    public void setPeerConnectionForTest(PeerConnection peerConnection) {
        this.peerConnection = peerConnection;
    }

    public void setWebRTCVertx(Vertx webRTCVertx) {
        this.webRTCVertx = webRTCVertx;
        this.signallingContext = webRTCVertx.getOrCreateContext();
    }

    public long getVideoEncoderExecutorSchedule() {
        return this.videoEncoderExecutorSchedule;
    }

    public long getAudioEncoderExecutorFuture() {
        return this.audioEncoderExecutorFuture;
    }

    public void setAudioEncoderExecutorFuture(long audioEncoderExecutorFuture) {
        this.audioEncoderExecutorFuture = audioEncoderExecutorFuture;
    }

    public Vertx getWebRTCVertx() {
        return this.webRTCVertx;
    }

    public Context getSignallingContext() {
        return this.signallingContext;
    }

    public AtomicInteger getAudioFrameProcessedCount() {
        return this.audioFrameProcessedCount;
    }

    public boolean isRestored() {
        return this.restored.get();
    }

    public void setRestored(boolean restored) {
        this.restored.set(restored);
    }

    public AVCodecParameters getAudioCodecParameters() {
        AVCodecParameters audioCodecParameters = new AVCodecParameters();
        audioCodecParameters.sample_rate(16000);
        audioCodecParameters.codec_id(86076);
        audioCodecParameters.codec_type(1);
        audioCodecParameters.channel_layout(4L);
        audioCodecParameters.channels(1);
        audioCodecParameters.format(1);
        return audioCodecParameters;
    }

    public AVCodecParameters getVideoCodecParameters() {
        AVCodecParameters videoCodecParameters = new AVCodecParameters();
        videoCodecParameters.width(this.rawVideoWidth);
        videoCodecParameters.height(this.rawVideoHeight);
        videoCodecParameters.format(0);
        videoCodecParameters.codec_tag(0);
        return videoCodecParameters;
    }

    public AVRational getVideoTimeBase() {
        if (this.videoTimeBase == null) {
            this.videoTimeBase = new AVRational();
            this.videoTimeBase.num(1);
            this.videoTimeBase.den(this.getFrameRate());
        }
        return this.videoTimeBase;
    }

    public AVRational getAudioTimeBase() {
        if (this.videoTimeBase == null) {
            this.videoTimeBase = new AVRational();
            this.videoTimeBase.num(1);
            this.videoTimeBase.den(48000);
        }
        return this.videoTimeBase;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    static {
        AUDIO_SAMPLE_RATE_TIMEBASE.num(1).den(48000);
    }

    private class VideoSinkCallback
    implements VideoSink {
        private int videoFrameLogCounter = 0;

        private VideoSinkCallback() {
        }

        public void onFrame(VideoFrame frame) {
            if (WebRTCEncoderAdaptor.this.isStopped.get()) {
                logger.info("renderFrame returning because encoder adaptor is stopped {}", (Object)WebRTCEncoderAdaptor.this.streamId);
                return;
            }
            WebRTCEncoderAdaptor.this.initializeVideoPacketTime(frame.getTimestampNs());
            WebRTCEncoderAdaptor.this.videoFramePending.incrementAndGet();
            ++this.videoFrameLogCounter;
            ++WebRTCEncoderAdaptor.this.receivedVideoFrameCount;
            long incomingFrameTimestampInMS = frame.getTimestampNs() / 1000000L;
            long timestampMS = incomingFrameTimestampInMS - WebRTCEncoderAdaptor.this.firstVideoTimestampMs + WebRTCEncoderAdaptor.this.videoTimeOffsetMS;
            logger.trace("on frame get timestamp: {} relative timestamp: {} streamId:{}", new Object[]{incomingFrameTimestampInMS, timestampMS, WebRTCEncoderAdaptor.this.streamId});
            if (this.videoFrameLogCounter % 100 == 0) {
                long receivedFps = 0L;
                if (timestampMS > 1000L) {
                    receivedFps = (long)WebRTCEncoderAdaptor.this.receivedVideoFrameCount / (timestampMS / 1000L);
                }
                if (WebRTCEncoderAdaptor.this.videoFramePending.get() > 2 || (double)receivedFps < (double)WebRTCEncoderAdaptor.this.getFrameRate() * 0.75) {
                    logger.info("Number of video frames pending in the queue: {}, received total video frames: {}  received fps: {} for stream {}", new Object[]{WebRTCEncoderAdaptor.this.videoFramePending, WebRTCEncoderAdaptor.this.receivedVideoFrameCount, receivedFps, WebRTCEncoderAdaptor.this.streamId});
                }
                this.videoFrameLogCounter = 0;
            }
            frame.retain();
            VideoFrameContext videoFrameContext = new VideoFrameContext(frame, timestampMS);
            WebRTCEncoderAdaptor.this.videoFrameQueue.offer(videoFrameContext);
        }
    }

    public class EncodedAudioFrame {
        public final ByteBuffer buffer;
        public final long timestamp;

        public EncodedAudioFrame(ByteBuffer buffer, long timestamp) {
            this.buffer = buffer;
            this.timestamp = timestamp;
        }
    }
}

