/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.enterprise.adaptive;

import io.antmedia.AntMediaApplicationAdapter;
import io.antmedia.EncoderSettings;
import io.antmedia.RecordType;
import io.antmedia.SystemUtils;
import io.antmedia.datastore.db.DataStore;
import io.antmedia.datastore.db.types.StreamInfo;
import io.antmedia.enterprise.adaptive.StreamAdaptor;
import io.antmedia.enterprise.adaptive.audio.AACDecoder;
import io.antmedia.enterprise.adaptive.audio.AACEncoder;
import io.antmedia.enterprise.adaptive.audio.OpusEncoder;
import io.antmedia.enterprise.adaptive.audio.OpusForwarder;
import io.antmedia.enterprise.adaptive.base.AudioEncoder;
import io.antmedia.enterprise.adaptive.base.Encoder;
import io.antmedia.enterprise.adaptive.base.VideoEncoder;
import io.antmedia.enterprise.adaptive.video.H264Encoder;
import io.antmedia.enterprise.adaptive.video.H265Encoder;
import io.antmedia.enterprise.adaptive.video.SFUForwarder;
import io.antmedia.enterprise.adaptive.video.VP8Encoder;
import io.antmedia.enterprise.cluster.webrtc.OriginServer;
import io.antmedia.enterprise.cluster.webrtc.OriginServerStatusListener;
import io.antmedia.enterprise.muxer.DASHMuxer;
import io.antmedia.enterprise.muxer.MatroskaMuxer;
import io.antmedia.enterprise.preview.PngEncoder;
import io.antmedia.enterprise.preview.PngMuxer;
import io.antmedia.enterprise.tensorflow.detection.TensorFlowDetector;
import io.antmedia.enterprise.webrtc.IDataChannelMessagePublisher;
import io.antmedia.enterprise.webrtc.WebRTCAdaptor;
import io.antmedia.enterprise.webrtc.WebRTCApplication;
import io.antmedia.enterprise.webrtc.WebRTCMuxer;
import io.antmedia.muxer.HLSMuxer;
import io.antmedia.muxer.IEndpointStatusListener;
import io.antmedia.muxer.Mp4Muxer;
import io.antmedia.muxer.MuxAdaptor;
import io.antmedia.muxer.Muxer;
import io.antmedia.muxer.RecordMuxer;
import io.antmedia.muxer.RtmpMuxer;
import io.antmedia.muxer.WebMMuxer;
import io.antmedia.settings.ServerSettings;
import io.antmedia.statistic.GPUUtils;
import io.antmedia.statistic.type.RTMPToWebRTCStats;
import io.antmedia.storage.StorageClient;
import io.antmedia.webrtc.VideoCodec;
import io.antmedia.webrtc.api.IWebRTCAdaptor;
import io.vertx.core.Vertx;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.annotation.Nullable;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.bytedeco.ffmpeg.avcodec.AVCodec;
import org.bytedeco.ffmpeg.avcodec.AVCodecContext;
import org.bytedeco.ffmpeg.avcodec.AVCodecParameters;
import org.bytedeco.ffmpeg.avcodec.AVPacket;
import org.bytedeco.ffmpeg.avformat.AVFormatContext;
import org.bytedeco.ffmpeg.avformat.AVStream;
import org.bytedeco.ffmpeg.avutil.AVDictionary;
import org.bytedeco.ffmpeg.avutil.AVFrame;
import org.bytedeco.ffmpeg.avutil.AVRational;
import org.bytedeco.ffmpeg.global.avcodec;
import org.bytedeco.ffmpeg.global.avutil;
import org.bytedeco.javacpp.BytePointer;
import org.red5.server.api.scope.IScope;
import org.red5.server.api.stream.IStreamPacket;
import org.red5.server.stream.ClientBroadcastStream;
import org.red5.server.util.ScopeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.webrtc.DataChannel;

public class EncoderAdaptor
extends MuxAdaptor
implements IDataChannelMessagePublisher {
    protected IWebRTCAdaptor webRTCAdaptor;
    private static final int INPUT_QUEUE_SIZE_LIMIT_FOR_DROPPING = 75;
    private long dropCount = 0L;
    protected List<StreamAdaptor> streamAdaptorList = new ArrayList<StreamAdaptor>();
    static Logger logger = LoggerFactory.getLogger(EncoderAdaptor.class);
    private AVFrame picture;
    private AVCodecContext videoContext;
    private boolean mkvMuxingEnabled = false;
    private boolean opusEncoderEnabled = false;
    private boolean dropPacketEnabled = true;
    private long lastPacketDropTime;
    protected long totalAudioEncoderTime;
    private long totalExecuteTime;
    private long totalVideoDecodeTime;
    protected int videoFrameCount = 0;
    protected int audioFrameCount = 0;
    private AVPacket tempPkt;
    private ArrayList<StreamInfo> streamInfoList = null;
    private long firstPacketTime = -1L;
    private boolean audioWithMp3Codec = false;
    private boolean transcodeVideo = true;
    private RTMPToWebRTCStats rtmpWebrtcStats;
    private long rtmpWebrtcStatsTaskId;
    private WebRTCApplication applicationAdaptor;
    private long hlsAdaptiveFilePeriodicUpdate = -1L;
    protected int frameRate;
    private AACDecoder aacDecoder;
    private int[] gotFrame;
    protected Vertx webRTCVertx;
    protected boolean decodeAudio = true;
    private boolean firstVideoPacketReceived = false;
    private boolean firstAudioPacketReceived = false;
    private long lastVideoFramePts = -1L;
    private AVRational videoEncoderTimebase;
    private WebMMuxer dynamicWebmMuxer = null;

    public EncoderAdaptor(ClientBroadcastStream clientBroadcastStream) {
        super(clientBroadcastStream);
    }

    public boolean init(IScope scope, String streamId, boolean isAppend) {
        super.init(scope, streamId, isAppend);
        this.initWebRTCAdaptor();
        this.initServerSettings();
        this.initWebRTCVertx();
        this.frameRate = this.getAppSettings().getWebRTCFrameRate();
        this.videoEncoderTimebase = new AVRational();
        this.videoEncoderTimebase.num(1);
        this.videoEncoderTimebase.den(this.frameRate);
        this.tempPkt = avcodec.av_packet_alloc();
        avcodec.av_init_packet((AVPacket)this.tempPkt);
        return true;
    }

    private void initWebRTCAdaptor() {
        this.webRTCAdaptor = (IWebRTCAdaptor)ScopeUtils.getScopeService((IScope)this.scope, IWebRTCAdaptor.class, WebRTCAdaptor.class);
        if (this.webRTCAdaptor == null && this.webRTCEnabled) {
            logger.error("Configuration ERROR: WebRTC enabled but WebRTCAdaptor is not available in the app for stream: {}", (Object)this.streamId);
        }
    }

    private void initWebRTCVertx() {
        this.webRTCVertx = (Vertx)this.scope.getContext().getApplicationContext().getBean("webRTCVertx");
    }

    public boolean findDecoder(AVCodecParameters par) {
        String encoderName = null;
        AVCodec codec = null;
        if (GPUUtils.getInstance().getDeviceCount() > 0 && par.codec_id() == 27) {
            if (SystemUtils.OS_TYPE == 1 || SystemUtils.OS_TYPE == 2) {
                encoderName = "h264_cuvid";
            } else if (SystemUtils.OS_TYPE == 0) {
                // empty if block
            }
        }
        boolean result = false;
        if (encoderName != null) {
            codec = avcodec.avcodec_find_decoder_by_name(encoderName);
            result = this.openDecoder(codec, par);
        }
        if (!result) {
            if (codec != null) {
                codec.close();
            }
            codec = avcodec.avcodec_find_decoder((int)par.codec_id());
            result = this.openDecoder(codec, par);
        }
        BytePointer name = codec.name();
        logger.info("video decoder name:  {} for {}  video context timebase:{}/{} wxh:{}x{}", new Object[]{name.getString(), this.streamId, this.videoContext.time_base().num(), this.videoContext.time_base().den(), this.videoContext.width(), this.videoContext.height()});
        codec.close();
        return result;
    }

    public boolean openDecoder(AVCodec codec, AVCodecParameters par) {
        this.videoContext = avcodec.avcodec_alloc_context3((AVCodec)codec);
        if (this.videoContext == null) {
            logger.warn("cannot allocate video context : {} ", (Object)codec.name().getString());
            return false;
        }
        if (avcodec.avcodec_parameters_to_context((AVCodecContext)this.videoContext, (AVCodecParameters)par) < 0) {
            logger.warn("cannot copy context parameters: {} ", (Object)codec.name().getString());
            avcodec.avcodec_free_context((AVCodecContext)this.videoContext);
            return false;
        }
        this.videoContext.thread_count(6);
        int ret = avcodec.avcodec_open2((AVCodecContext)this.videoContext, (AVCodec)codec, (AVDictionary)null);
        if (ret < 0) {
            if (logger.isErrorEnabled()) {
                byte[] data = new byte[2048];
                avutil.av_strerror((int)ret, (byte[])data, (long)data.length);
                logger.error(" Opening decoder error: {}", (Object)new String(data, 0, data.length));
            }
            avcodec.avcodec_free_context((AVCodecContext)this.videoContext);
            return false;
        }
        return true;
    }

    public boolean prepare() throws Exception {
        super.prepare();
        this.prepareInternal();
        return true;
    }

    public void prepareInternal() {
        this.transcodeVideo = true;
        if ((this.encoderSettingsList == null || this.encoderSettingsList.isEmpty()) && this.webRTCEnabled) {
            this.transcodeVideo = false;
        }
        if (this.streamSourceInputFormatContext != null) {
            this.prepareDecoders(this.streamSourceInputFormatContext, this.transcodeVideo);
            this.prepareEncoders(this.streamSourceInputFormatContext, this.transcodeVideo);
        } else {
            this.gotFrame = new int[1];
            this.prepareDecoders(this.getVideoCodecParameters(), TIME_BASE_FOR_MS, this.getAudioCodecParameters(), TIME_BASE_FOR_MS, this.transcodeVideo || this.appSettings.isForceDecoding());
            this.prepareEncoders(this.getVideoCodecParameters(), this.getAudioCodecParameters(), this.transcodeVideo, TIME_BASE_FOR_MS);
        }
        if (this.webRTCEnabled) {
            this.getApplicationAdaptor().getRtmpToWebRTCStreamsMap().put(this.streamId, this);
            this.getApplicationAdaptor().getDataChannelRouter().addPublisher(this.streamId, this);
            this.startStats();
        }
    }

    public boolean prepareFromInputFormatContext(AVFormatContext inputFormatContext) throws Exception {
        if (!super.prepareFromInputFormatContext(inputFormatContext)) {
            return false;
        }
        this.prepareInternal();
        return true;
    }

    private void prepareDecoders(AVCodecParameters videoCodecParameters, AVRational videoTimebase, AVCodecParameters audioCodecParameters, AVRational audioTimebase, boolean decodeVideo) {
        if (decodeVideo && this.enableVideo) {
            this.prepareVideoDecoder(videoCodecParameters, videoTimebase);
        } else {
            logger.info("not decoding video for stream: {}", (Object)this.streamId);
        }
        if (this.enableAudio && this.decodeAudio) {
            this.aacDecoder = new AACDecoder(this.streamId);
            this.aacDecoder.prepareAudioDecoder(audioCodecParameters);
        } else {
            logger.info("No audio in stream: {}", (Object)this.streamId);
        }
    }

    private void prepareVideoDecoder(AVCodecParameters videoCodecParameters, AVRational videoTimebase) {
        if (!this.findDecoder(videoCodecParameters)) {
            throw new IllegalArgumentException("Decoder cannot be found !!!!");
        }
        this.picture = avutil.av_frame_alloc();
        if (this.picture == null) {
            throw new IllegalArgumentException("av_frame_alloc() error: Could not allocate raw picture frame.");
        }
    }

    private void prepareDecoders(AVFormatContext inputFormatContext, boolean decodeVideo) {
        int nbOfStreams = inputFormatContext.nb_streams();
        this.gotFrame = new int[1];
        for (int i = 0; i < nbOfStreams; ++i) {
            AVStream st = inputFormatContext.streams(i);
            AVCodecParameters par = st.codecpar();
            if (par.codec_type() == 0) {
                this.setHeight(par.height());
                this.width = par.width();
                if (decodeVideo) {
                    logger.info("find decoder for stream: {} ", (Object)this.streamId);
                    this.prepareVideoDecoder(par, st.time_base());
                    continue;
                }
                logger.info("not decoding video for stream: {}", (Object)this.streamId);
                continue;
            }
            if (par.codec_type() != 1) continue;
            this.aacDecoder = new AACDecoder(this.streamId);
            this.aacDecoder.prepareAudioDecoder(par);
        }
    }

    public void buildEncoders(int sourceHeight, boolean encodeVideo) {
        if (!encodeVideo) {
            WebRTCMuxer webRTCMuxer = this.getWebRTCMuxer(0, encodeVideo);
            webRTCMuxer.setCodec(VideoCodec.H264);
            webRTCMuxer.setAbsoluteStartTimeMs(this.broadcastStream != null ? this.broadcastStream.getAbsoluteStartTimeMs() : 0L);
            webRTCMuxer.init(this.scope, this.streamId, 0, this.getBroadcast().getSubFolder(), 0);
            SFUForwarder sfuForwarder = new SFUForwarder(0, 0, null, this.streamId);
            sfuForwarder.setCodecId(27);
            sfuForwarder.setVideoCodec(VideoCodec.H264);
            sfuForwarder.addMuxer(webRTCMuxer);
            OpusEncoder opusEncoder = new OpusEncoder(96000, this.streamId);
            opusEncoder.addMuxer(webRTCMuxer);
            StreamAdaptor streamAdaptor = new StreamAdaptor(true, this.vertx, this.streamId);
            streamAdaptor.addAudioEncoder(opusEncoder);
            streamAdaptor.addVideoEncoder(sfuForwarder);
            this.streamAdaptorList.add(streamAdaptor);
            streamAdaptor.start();
        } else if (this.encoderSettingsList != null && !this.encoderSettingsList.isEmpty()) {
            for (EncoderSettings settings : this.encoderSettingsList) {
                if (sourceHeight == 0 || settings.getHeight() <= sourceHeight || settings.isForceEncode()) {
                    WebRTCMuxer webRTCMuxer;
                    StreamAdaptor streamAdaptor = new StreamAdaptor(true, this.vertx, this.streamId);
                    OpusEncoder opusEncoder = null;
                    if (this.webRTCEnabled) {
                        opusEncoder = new OpusEncoder(settings.getAudioBitrate(), this.streamId);
                        streamAdaptor.addAudioEncoder(opusEncoder);
                    }
                    AACEncoder aacEncoder = null;
                    if (this.getAppSettings().isH265Enabled() && this.webRTCEnabled) {
                        WebRTCMuxer webRTCMuxer2 = this.getWebRTCMuxer(settings.getHeight(), encodeVideo);
                        webRTCMuxer2.setCodec(VideoCodec.H265);
                        webRTCMuxer2.setAbsoluteStartTimeMs(this.broadcastStream != null ? this.broadcastStream.getAbsoluteStartTimeMs() : 0L);
                        webRTCMuxer2.init(this.scope, this.streamId, settings.getHeight(), this.getBroadcast().getSubFolder(), settings.getVideoBitrate());
                        H265Encoder h265Encoder = new H265Encoder(settings.getHeight(), settings.getVideoBitrate(), SystemUtils.OS_TYPE, this.streamId);
                        h265Encoder.setAppSettings(this.getAppSettings());
                        if (this.isAACEncodingRequired()) {
                            aacEncoder = new AACEncoder(settings.getAudioBitrate(), this.streamId);
                            this.initMp4Muxer(settings.getHeight(), h265Encoder, aacEncoder, this.streamId + "_265");
                            streamAdaptor.addAudioEncoder(aacEncoder);
                        }
                        h265Encoder.addMuxer(webRTCMuxer2);
                        if (opusEncoder != null) {
                            opusEncoder.addMuxer(webRTCMuxer2);
                        }
                        streamAdaptor.addVideoEncoder(h265Encoder);
                    }
                    if (this.getAppSettings().isH264Enabled()) {
                        H264Encoder h264Encoder = new H264Encoder(settings.getHeight(), settings.getVideoBitrate(), SystemUtils.OS_TYPE, this.streamId);
                        h264Encoder.setAppSettings(this.getAppSettings());
                        if (this.isAACEncodingRequired()) {
                            if (aacEncoder == null) {
                                aacEncoder = new AACEncoder(settings.getAudioBitrate(), this.streamId);
                                streamAdaptor.addAudioEncoder(aacEncoder);
                            }
                            this.initMp4Muxer(settings.getHeight(), h264Encoder, aacEncoder, this.streamId);
                            this.initHLSMuxer(settings.getHeight(), h264Encoder, aacEncoder);
                            this.initDASHMuxer(settings.getHeight(), h264Encoder, aacEncoder);
                            this.initMkvMuxing(settings.getHeight(), h264Encoder, aacEncoder);
                        } else {
                            this.logAACEncoderisNotCreated();
                        }
                        if (this.webRTCEnabled) {
                            webRTCMuxer = this.getWebRTCMuxer(settings.getHeight(), encodeVideo);
                            webRTCMuxer.setCodec(VideoCodec.H264);
                            webRTCMuxer.setAbsoluteStartTimeMs(this.broadcastStream != null ? this.broadcastStream.getAbsoluteStartTimeMs() : 0L);
                            webRTCMuxer.init(this.scope, this.streamId, settings.getHeight(), this.getBroadcast().getSubFolder(), settings.getVideoBitrate());
                            h264Encoder.addMuxer(webRTCMuxer);
                            if (opusEncoder != null) {
                                opusEncoder.addMuxer(webRTCMuxer);
                            }
                        } else {
                            logger.info("WebRTC is not enabled for {}", (Object)this.streamId);
                        }
                        streamAdaptor.addVideoEncoder(h264Encoder);
                    }
                    if (this.getAppSettings().isVp8Enabled()) {
                        VP8Encoder vp8Encoder = new VP8Encoder(settings.getHeight(), settings.getVideoBitrate(), SystemUtils.OS_TYPE, this.streamId);
                        vp8Encoder.setAppSettings(this.getAppSettings());
                        this.initWebMMuxer(settings.getHeight(), vp8Encoder, opusEncoder);
                        if (this.webRTCEnabled) {
                            webRTCMuxer = this.getWebRTCMuxer(settings.getHeight(), encodeVideo);
                            webRTCMuxer.setAbsoluteStartTimeMs(this.broadcastStream != null ? this.broadcastStream.getAbsoluteStartTimeMs() : 0L);
                            webRTCMuxer.setCodec(VideoCodec.VP8);
                            webRTCMuxer.init(this.scope, this.streamId, settings.getHeight(), this.getBroadcast().getSubFolder(), settings.getVideoBitrate());
                            vp8Encoder.addMuxer(webRTCMuxer);
                            if (opusEncoder != null) {
                                opusEncoder.addMuxer(webRTCMuxer);
                            }
                        } else {
                            logger.info("WebRTC is not enabled for {}", (Object)this.streamId);
                        }
                        streamAdaptor.addVideoEncoder(vp8Encoder);
                    }
                    this.streamAdaptorList.add(streamAdaptor);
                    streamAdaptor.start();
                    continue;
                }
                logger.warn("Ignore stream due to incoming stream resolution:({}) is lower than requested adaptive resolution({}), isForceEncode: {}", new Object[]{sourceHeight, settings.getHeight(), settings.isForceEncode()});
            }
            this.initPngMuxing();
        }
    }

    public void initPngMuxing() {
        if (this.generatePreview) {
            int period = this.getPreviewCreatePeriod() >= 500 ? this.getPreviewCreatePeriod() : 1000;
            PngEncoder pngEncoder = new PngEncoder(this.getPreviewHeight(), 0, period, this.streamId);
            PngMuxer pngMuxer = new PngMuxer(this.vertx, this.storageClient, this.appSettings.getUploadExtensionsToS3());
            pngMuxer.setAddDateTimeToSourceName(this.addDateTimeToMp4FileName);
            pngMuxer.setOverwrite(this.previewOverwrite);
            pngMuxer.setS3PreviewsFolderPath(this.getAppSettings().getS3PreviewsFolderPath());
            pngMuxer.init(this.scope, this.streamId, 0, this.getBroadcast().getSubFolder(), 0);
            this.setDeepLearningProcessor(pngMuxer, this.scope, this.streamId);
            pngEncoder.addMuxer(pngMuxer);
            this.muxerList.add(pngMuxer);
            StreamAdaptor streamAdaptor = new StreamAdaptor(false, this.vertx, this.streamId);
            streamAdaptor.addVideoEncoder(pngEncoder);
            this.streamAdaptorList.add(streamAdaptor);
            streamAdaptor.start();
        }
    }

    private void initMkvMuxing(int height, H264Encoder h264Encoder, AACEncoder aacEncoder) {
        if (this.mkvMuxingEnabled) {
            MatroskaMuxer matroskaMuxer = new MatroskaMuxer(this.storageClient, this.vertx, this.getAppSettings().getS3StreamsFolderPath());
            matroskaMuxer.init(this.scope, this.streamId, height, this.getBroadcast().getSubFolder(), h264Encoder.getBitrate());
            h264Encoder.addMuxer(matroskaMuxer);
            aacEncoder.addMuxer(matroskaMuxer);
        }
    }

    public void initHLSMuxer(int height, @Nullable VideoEncoder h264Encoder, AACEncoder aacEncoder) {
        if (this.hlsMuxingEnabled) {
            HLSMuxer hlsMuxer = new HLSMuxer(this.vertx, this.storageClient, this.getAppSettings().getS3StreamsFolderPath(), this.getAppSettings().getUploadExtensionsToS3());
            hlsMuxer.setHlsParameters(this.hlsListSize, this.hlsTime, this.hlsPlayListType, this.getAppSettings().getHlsFlags(), this.getAppSettings().getHlsEncryptionKeyInfoFile());
            hlsMuxer.setDeleteFileOnExit(this.deleteHLSFilesOnExit);
            hlsMuxer.init(this.scope, this.streamId, height, this.getBroadcast().getSubFolder(), h264Encoder != null ? h264Encoder.getBitrate() : 0);
            if (h264Encoder != null) {
                h264Encoder.addMuxer((Muxer)hlsMuxer);
            }
            aacEncoder.addMuxer((Muxer)hlsMuxer);
        }
    }

    public void initDASHMuxer(int height, @Nullable VideoEncoder h264Encoder, AACEncoder aacEncoder) {
        DASHMuxer dashMuxer = (DASHMuxer)this.getDashMuxer();
        if (dashMuxer != null) {
            dashMuxer.init(this.scope, this.streamId, height, this.getBroadcast().getSubFolder(), h264Encoder != null ? h264Encoder.getBitrate() : 0);
            if (h264Encoder != null) {
                h264Encoder.addMuxer(dashMuxer);
            }
            aacEncoder.addMuxer(dashMuxer);
        }
    }

    public void initMp4Muxer(int height, @Nullable VideoEncoder h264Encoder, AACEncoder aacEncoder, String streamId) {
        if (this.mp4MuxingEnabled) {
            Mp4Muxer mp4Muxer = this.createMp4Muxer();
            mp4Muxer.init(this.scope, streamId, height, this.getBroadcast().getSubFolder(), h264Encoder != null ? h264Encoder.getBitrate() : 0);
            if (h264Encoder != null) {
                h264Encoder.addMuxer((Muxer)mp4Muxer);
            }
            aacEncoder.addMuxer((Muxer)mp4Muxer);
        }
    }

    public void initWebMMuxer(int height, @Nullable VideoEncoder vp8Encoder, AudioEncoder opusEncoder) {
        if (this.webMMuxingEnabled) {
            WebMMuxer webMMuxer = new WebMMuxer(this.storageClient, this.vertx, this.getAppSettings().getS3StreamsFolderPath());
            webMMuxer.setAddDateTimeToSourceName(this.addDateTimeToMp4FileName);
            webMMuxer.init(this.scope, this.streamId, height, this.getBroadcast().getSubFolder(), vp8Encoder != null ? vp8Encoder.getBitrate() : 0);
            if (vp8Encoder != null) {
                vp8Encoder.addMuxer((Muxer)webMMuxer);
            }
            opusEncoder.addMuxer((Muxer)webMMuxer);
        }
    }

    public void buildOnlyAudioEncoders(boolean encode) {
        if (!encode) {
            StreamAdaptor streamAdaptor = new StreamAdaptor(true, this.vertx, this.streamId);
            if (this.isAACEncodingRequired()) {
                AACEncoder aacEncoder = new AACEncoder(96000, this.streamId);
                this.initMp4Muxer(0, null, aacEncoder, this.streamId);
                this.initHLSMuxer(0, null, aacEncoder);
                this.initDASHMuxer(0, null, aacEncoder);
                streamAdaptor.addAudioEncoder(aacEncoder);
            } else {
                this.logAACEncoderisNotCreated();
            }
            WebRTCMuxer webRTCMuxer = this.getWebRTCMuxer(0, encode);
            webRTCMuxer.setCodec(VideoCodec.NOVIDEO);
            webRTCMuxer.init(this.scope, this.streamId, 0, this.getBroadcast().getSubFolder(), 0);
            OpusEncoder opusEncoder = new OpusEncoder(96000, this.streamId);
            opusEncoder.addMuxer(webRTCMuxer);
            this.initWebMMuxer(0, null, opusEncoder);
            streamAdaptor.addAudioEncoder(opusEncoder);
            this.streamAdaptorList.add(streamAdaptor);
            streamAdaptor.start();
        } else if (this.encoderSettingsList != null) {
            for (EncoderSettings settings : this.encoderSettingsList) {
                StreamAdaptor streamAdaptor = new StreamAdaptor(true, this.vertx, this.streamId);
                if (this.isAACEncodingRequired()) {
                    AACEncoder aacEncoder = new AACEncoder(settings.getAudioBitrate(), this.streamId);
                    this.initMp4Muxer(settings.getHeight(), null, aacEncoder, this.streamId);
                    this.initHLSMuxer(settings.getHeight(), null, aacEncoder);
                    this.initDASHMuxer(settings.getHeight(), null, aacEncoder);
                    streamAdaptor.addAudioEncoder(aacEncoder);
                } else {
                    this.logAACEncoderisNotCreated();
                }
                WebRTCMuxer webRTCMuxer = this.getWebRTCMuxer(0, encode);
                webRTCMuxer.setCodec(VideoCodec.NOVIDEO);
                webRTCMuxer.init(this.scope, this.streamId, 0, this.getBroadcast().getSubFolder(), 0);
                OpusEncoder opusEncoder = new OpusEncoder(settings.getAudioBitrate(), this.streamId);
                opusEncoder.addMuxer(webRTCMuxer);
                this.initWebMMuxer(0, null, opusEncoder);
                streamAdaptor.addAudioEncoder(opusEncoder);
                this.streamAdaptorList.add(streamAdaptor);
                streamAdaptor.start();
            }
        }
    }

    private void logAACEncoderisNotCreated() {
        logger.info("AAC encoder is not created because mp4, hls muxing and mp4 system settings are disabled for stream:{}", (Object)this.streamId);
    }

    public boolean isAACEncodingRequired() {
        return this.mp4MuxingEnabled || this.hlsMuxingEnabled || this.dashMuxingEnabled || this.getAppSettings().isMp4MuxingEnabled() || this.getAppSettings().isAacEncodingEnabled();
    }

    public WebRTCMuxer getWebRTCMuxer(int muxerHeight, boolean encodeVideo) {
        WebRTCMuxer webRTCMuxer = null;
        webRTCMuxer = new WebRTCMuxer(this.webRTCAdaptor);
        return webRTCMuxer;
    }

    private void setDeepLearningProcessor(PngMuxer pngMuxer, IScope scope, String streamId) {
        if (this.isObjectDetectionEnabled()) {
            logger.info("Object detection is enabled for stream: {}", (Object)streamId);
            try {
                TensorFlowDetector tensorFlowDetector = new TensorFlowDetector(this.vertx, this.dataStore, "lib/detection/");
                tensorFlowDetector.init(scope, streamId, 0, this.getBroadcast().getSubFolder(), 0);
                pngMuxer.setDeepLearningProcessor(tensorFlowDetector);
            }
            catch (IOException e) {
                logger.error(ExceptionUtils.getStackTrace((Throwable)e));
            }
        } else {
            logger.info("Object detection is NOT enabled for stream:{}", (Object)streamId);
        }
    }

    private void prepareEncoders(AVCodecParameters videoCodecParameters, AVCodecParameters audioCodecParameters, boolean encode, AVRational videoStreamTimebase) {
        if (!this.enableVideo) {
            this.buildOnlyAudioEncoders(encode);
        } else {
            this.buildEncoders(this.height, encode);
        }
        if (this.getVideoStreamIndex() <= this.getAudioStreamIndex()) {
            if (videoCodecParameters != null) {
                this.prepareVideoEncoders(videoCodecParameters, encode ? this.videoEncoderTimebase : videoStreamTimebase, this.frameRate * 2);
            }
            if (audioCodecParameters != null) {
                this.prepareAudioEncoders(audioCodecParameters);
                this.audioWithMp3Codec = audioCodecParameters.codec_id() == 86017;
            }
        } else {
            if (audioCodecParameters != null) {
                this.prepareAudioEncoders(audioCodecParameters);
                boolean bl = this.audioWithMp3Codec = audioCodecParameters.codec_id() == 86017;
            }
            if (videoCodecParameters != null) {
                this.prepareVideoEncoders(videoCodecParameters, encode ? this.videoEncoderTimebase : videoStreamTimebase, this.frameRate * 2);
            }
        }
        this.prepareIO();
        this.startAdaptiveHLS();
        this.startOriginIfRequired();
    }

    private void prepareEncoders(AVFormatContext inputFormatContext, boolean encode) {
        int numberOfStreams = inputFormatContext.nb_streams();
        AVCodecParameters videoCodecParameters = null;
        AVRational videoStreamTimebase = null;
        AVCodecParameters audioCodecParameters = null;
        for (int i = 0; i < numberOfStreams; ++i) {
            AVStream st = inputFormatContext.streams(i);
            AVCodecParameters par = st.codecpar();
            if (par.codec_type() == 0) {
                videoStreamTimebase = st.time_base();
                videoCodecParameters = par;
                continue;
            }
            if (par.codec_type() != 1) continue;
            audioCodecParameters = par;
        }
        this.prepareEncoders(videoCodecParameters, audioCodecParameters, encode, videoStreamTimebase);
    }

    protected void prepareAudioEncoders(AVCodecParameters codecpar) {
        for (StreamAdaptor streamAdaptor : this.streamAdaptorList) {
            for (AudioEncoder encoder : streamAdaptor.getAudioEncoderList()) {
                try {
                    encoder.prepareCodec(codecpar.sample_rate(), (int)codecpar.channel_layout(), this.getAudioStreamIndex());
                }
                catch (Exception e) {
                    logger.error(ExceptionUtils.getStackTrace((Throwable)e));
                }
            }
        }
    }

    protected void prepareVideoEncoders(AVCodecParameters codecpar, AVRational timebase, int gopSize) {
        for (StreamAdaptor streamAdaptor : this.streamAdaptorList) {
            for (VideoEncoder encoder : streamAdaptor.getVideoEncoderList()) {
                try {
                    encoder.prepareCodec(codecpar.width(), codecpar.height(), timebase, codecpar.sample_aspect_ratio(), gopSize, this.getVideoStreamIndex(), this.isAvc(), codecpar);
                }
                catch (Exception e) {
                    logger.error(ExceptionUtils.getStackTrace((Throwable)e));
                }
            }
        }
    }

    protected void prepareIO() {
        for (StreamAdaptor streamAdaptor : this.streamAdaptorList) {
            for (Encoder encoder : streamAdaptor.getVideoEncoderList()) {
                try {
                    encoder.prepareIO();
                }
                catch (Exception e) {
                    logger.error(ExceptionUtils.getStackTrace((Throwable)e));
                }
            }
            for (Encoder encoder : streamAdaptor.getAudioEncoderList()) {
                try {
                    encoder.prepareIO();
                }
                catch (Exception e) {
                    logger.error(ExceptionUtils.getStackTrace((Throwable)e));
                }
            }
        }
        if (this.dashMuxer != null) {
            this.dashMuxer.prepareIO();
        }
    }

    public void stopAdaptiveHLS() {
        if (this.hlsAdaptiveFilePeriodicUpdate != -1L) {
            this.vertx.cancelTimer(this.hlsAdaptiveFilePeriodicUpdate);
            this.hlsAdaptiveFilePeriodicUpdate = -1L;
        }
        if (this.hlsMuxingEnabled && this.encoderSettingsList != null && !this.encoderSettingsList.isEmpty() && this.getAppSettings().isH264Enabled()) {
            int listSize = Integer.parseInt(this.hlsListSize);
            int segmentTime = Integer.parseInt(this.hlsTime);
            String subFolder = this.getBroadcast().getSubFolder();
            this.vertx.setTimer((long)(listSize * segmentTime) * 1000L, h -> {
                File adaptiveHLSFile = Muxer.getRecordFile((IScope)this.scope, (String)(this.streamId + "_adaptive"), (String)".m3u8", (String)subFolder);
                if (adaptiveHLSFile.exists()) {
                    String directoryPath = this.getAppSettings().getS3StreamsFolderPath() + File.separator + (String)(subFolder != null ? subFolder + File.separator : "");
                    RecordMuxer.saveToStorage((String)directoryPath, (File)adaptiveHLSFile, (String)adaptiveHLSFile.getName(), (StorageClient)this.storageClient);
                    if (this.deleteHLSFilesOnExit) {
                        this.deleteFile(adaptiveHLSFile);
                    }
                }
            });
        }
    }

    private void deleteFile(File adaptiveHLSFile) {
        try {
            Files.deleteIfExists(adaptiveHLSFile.toPath());
        }
        catch (IOException e) {
            logger.error(ExceptionUtils.getStackTrace((Throwable)e));
        }
    }

    public void startAdaptiveHLS() {
        if (this.hlsMuxingEnabled && this.encoderSettingsList != null && !this.encoderSettingsList.isEmpty() && this.getAppSettings().isH264Enabled()) {
            this.hlsAdaptiveFilePeriodicUpdate = this.vertx.setPeriodic(5000L, h -> this.updateAdaptiveHLSFile());
        }
    }

    private void updateAdaptiveHLSFile() {
        File adaptiveHLSFile = Muxer.getRecordFile((IScope)this.scope, (String)(this.streamId + "_adaptive"), (String)".m3u8.tmp", (String)this.getBroadcast().getSubFolder());
        try {
            TreeMap<Long, HLSMuxer> adaptiveListMap = new TreeMap<Long, HLSMuxer>();
            HLSMuxer muxerWOEncoding = null;
            for (Muxer muxer : this.muxerList) {
                if (!(muxer instanceof HLSMuxer)) continue;
                HLSMuxer hlsMuxer = (HLSMuxer)muxer;
                adaptiveListMap.put(hlsMuxer.getAverageBitrate(), hlsMuxer);
                muxerWOEncoding = hlsMuxer;
            }
            for (StreamAdaptor streamAdaptor : this.streamAdaptorList) {
                HLSMuxer hlsMuxer;
                List<Muxer> list;
                if (!this.enableVideo) {
                    for (Encoder encoder : streamAdaptor.getAudioEncoderList()) {
                        list = encoder.getMuxerList();
                        for (Muxer muxer : list) {
                            if (!(muxer instanceof HLSMuxer)) continue;
                            hlsMuxer = (HLSMuxer)muxer;
                            adaptiveListMap.put(hlsMuxer.getAverageBitrate(), hlsMuxer);
                        }
                    }
                    continue;
                }
                for (Encoder encoder : streamAdaptor.getVideoEncoderList()) {
                    list = encoder.getMuxerList();
                    for (Muxer muxer : list) {
                        if (!(muxer instanceof HLSMuxer)) continue;
                        hlsMuxer = (HLSMuxer)muxer;
                        adaptiveListMap.put(hlsMuxer.getAverageBitrate(), hlsMuxer);
                    }
                }
            }
            Iterator iterator = adaptiveListMap.entrySet().iterator();
            PrintWriter out = new PrintWriter(adaptiveHLSFile);
            out.println("#EXTM3U");
            while (iterator.hasNext()) {
                Map.Entry mentry = iterator.next();
                HLSMuxer hLSMuxer = (HLSMuxer)mentry.getValue();
                out.print("#EXT-X-STREAM-INF:PROGRAM-ID=1,BANDWIDTH=" + mentry.getKey());
                if (this.audioWithMp3Codec && hLSMuxer == muxerWOEncoding) {
                    out.println("");
                } else {
                    out.println(",RESOLUTION=" + hLSMuxer.getVideoWidth() + "x" + hLSMuxer.getVideoHeight() + ",CODECS=\"avc1.42e00a,mp4a.40.2\"");
                }
                out.println(hLSMuxer.getFileName());
            }
            out.flush();
            out.close();
            File originalFile = Muxer.getRecordFile((IScope)this.scope, (String)(this.streamId + "_adaptive"), (String)".m3u8", (String)this.getBroadcast().getSubFolder());
            Files.move(adaptiveHLSFile.toPath(), originalFile.toPath(), StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE);
        }
        catch (IOException e) {
            logger.error(ExceptionUtils.getStackTrace((Throwable)e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        Class<org.bytedeco.ffmpeg.presets.avcodec> clazz = org.bytedeco.ffmpeg.presets.avcodec.class;
        synchronized (org.bytedeco.ffmpeg.presets.avcodec.class) {
            this.releaseUnsafe();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    void releaseUnsafe() {
        if (this.picture != null) {
            avutil.av_frame_free((AVFrame)this.picture);
            this.picture.close();
            this.picture = null;
        }
        if (this.tempPkt != null) {
            avcodec.av_packet_free((AVPacket)this.tempPkt);
            this.tempPkt = null;
        }
        if (this.videoContext != null) {
            avcodec.avcodec_free_context((AVCodecContext)this.videoContext);
            this.videoContext.close();
            this.videoContext = null;
        }
        if (this.aacDecoder != null) {
            this.aacDecoder.stop();
        }
        if (this.videoEncoderTimebase != null) {
            this.videoEncoderTimebase.close();
            this.videoEncoderTimebase = null;
        }
    }

    public void writeStreamPacket(IStreamPacket packet) {
        super.writeStreamPacket(packet);
        long currentTime = System.currentTimeMillis();
        if (packet.getDataType() == 9) {
            if (!this.firstVideoPacketReceived) {
                this.firstVideoPacketReceived = true;
                return;
            }
            int bodySize = packet.getData().limit();
            byte frameType = packet.getData().position(0).get();
            ByteBuffer byteBuffer = ByteBuffer.allocateDirect(bodySize - 5);
            byteBuffer.put(packet.getData().buf().position(5));
            this.tempPkt.stream_index(this.getVideoStreamIndex());
            this.tempPkt.pts((long)packet.getTimestamp());
            this.tempPkt.dts((long)packet.getTimestamp());
            byteBuffer.rewind();
            if ((frameType & 0xF0) == 16) {
                this.tempPkt.flags(this.tempPkt.flags() | 1);
            }
            BytePointer bytePointer = new BytePointer(byteBuffer);
            this.tempPkt.data(bytePointer);
            this.tempPkt.size(byteBuffer.limit());
            this.tempPkt.position(0L);
            this.handleVideoPacket(TIME_BASE_FOR_MS, this.tempPkt, this.getInputQueueSize(), currentTime);
        } else if (packet.getDataType() == 8) {
            if (!this.firstAudioPacketReceived) {
                this.firstAudioPacketReceived = true;
                return;
            }
            int bodySize = packet.getData().limit();
            ByteBuffer byteBuffer = ByteBuffer.allocateDirect(bodySize - 2);
            byteBuffer.put(packet.getData().buf().position(2));
            this.tempPkt.stream_index(this.getAudioStreamIndex());
            this.tempPkt.pts((long)packet.getTimestamp());
            this.tempPkt.dts((long)packet.getTimestamp());
            byteBuffer.rewind();
            this.tempPkt.flags(this.tempPkt.flags() | 1);
            this.tempPkt.data(new BytePointer(byteBuffer));
            this.tempPkt.size(byteBuffer.limit());
            this.tempPkt.position(0L);
            this.handleAudioPacket(TIME_BASE_FOR_MS, this.tempPkt, currentTime);
        }
        avcodec.av_packet_unref((AVPacket)this.tempPkt);
    }

    public void writePacket(AVStream stream, AVPacket pkt) {
        boolean isVideoPacket;
        super.writePacket(stream, pkt);
        int inputQueueSize = this.getInputQueueSize();
        long currentTime = System.currentTimeMillis();
        boolean bl = isVideoPacket = stream.codecpar().codec_type() == 0;
        if (isVideoPacket) {
            this.handleVideoPacket(stream.time_base(), pkt, inputQueueSize, currentTime);
        } else if (stream.codecpar().codec_type() == 1) {
            this.handleAudioPacket(stream.time_base(), pkt, currentTime);
        }
    }

    private void handleAudioPacket(AVRational audioStreamTimebase, AVPacket pkt, long currentTime) {
        ++this.audioFrameCount;
        long traceStartTime = System.currentTimeMillis();
        AVFrame frame = this.decodeAudioFrame(audioStreamTimebase, pkt);
        if (frame != null) {
            frame.pts(frame.best_effort_timestamp());
            this.addFrame2StreamAdaptors(currentTime, frame, this.getAudioStreamIndex(), StreamAdaptor.PacketType.AUDIO_FRAME);
            avutil.av_frame_unref((AVFrame)frame);
        }
        this.totalAudioEncoderTime += System.currentTimeMillis() - traceStartTime;
    }

    private void handleVideoPacket(AVRational videoStreamTimebase, AVPacket pkt, int inputQueueSize, long currentTime) {
        if (this.transcodeVideo) {
            this.decodeAndAdd2Queue(videoStreamTimebase, pkt, inputQueueSize, currentTime);
        } else {
            this.addPacket2StreamAdaptors(pkt, currentTime);
            if (this.appSettings.isForceDecoding()) {
                this.decodeAndAdd2Queue(videoStreamTimebase, pkt, inputQueueSize, currentTime);
            }
        }
    }

    private void decodeAndAdd2Queue(AVRational videoStreamTimebase, AVPacket pkt, int inputQueueSize, long currentTime) {
        long traceStartTime = System.currentTimeMillis();
        this.sendVideoPacket(videoStreamTimebase, pkt);
        AVFrame frame = null;
        while ((frame = this.receiveVideoPacket()) != null) {
            if (frame.pts() <= this.lastVideoFramePts) {
                avutil.av_frame_unref((AVFrame)frame);
                return;
            }
            this.lastVideoFramePts = frame.pts();
            this.totalVideoDecodeTime += System.currentTimeMillis() - traceStartTime;
            ++this.videoFrameCount;
            if (this.webRTCEnabled && this.dropPacketEnabled && inputQueueSize > 75 && (pkt.flags() & 1) != 1 && this.lastPacketDropTime + 100L < currentTime) {
                logger.warn("Dropping video packet because input queue size{} is exceeding {}", (Object)inputQueueSize, (Object)75);
                ++this.dropCount;
                this.lastPacketDropTime = currentTime;
                avutil.av_frame_unref((AVFrame)frame);
                return;
            }
            traceStartTime = System.currentTimeMillis();
            this.addFrame2StreamAdaptors(currentTime, frame, this.getVideoStreamIndex(), StreamAdaptor.PacketType.VIDEO_FRAME);
            avutil.av_frame_unref((AVFrame)frame);
        }
    }

    private void addPacket2StreamAdaptors(AVPacket pkt, long currentTime) {
        for (StreamAdaptor streamAdaptor : this.streamAdaptorList) {
            streamAdaptor.addPacket2Queue(pkt, this.getVideoStreamIndex(), StreamAdaptor.PacketType.VIDEO_PACKET, currentTime);
        }
    }

    public void addFrame2StreamAdaptors(long currentTime, AVFrame frame, int streamIndex, StreamAdaptor.PacketType type) {
        for (StreamAdaptor streamAdaptor : this.streamAdaptorList) {
            streamAdaptor.addQueue(frame, streamIndex, type, currentTime);
        }
    }

    public synchronized void writeTrailer() {
        super.writeTrailer();
        this.stopAdaptiveHLS();
        this.clearStreamInfo();
        long totalVideoEncoderTime = 0L;
        int totalEncodedFrameCount = 0;
        for (StreamAdaptor streamAdaptor : this.streamAdaptorList) {
            for (VideoEncoder venc : streamAdaptor.getVideoEncoderList()) {
                totalVideoEncoderTime += venc.getTotalVideoEncoderTime();
                totalEncodedFrameCount = (int)((long)totalEncodedFrameCount + venc.getEncodedPacketCount());
            }
            streamAdaptor.stop();
        }
        logger.info("closing input and number of dropped packets {}", (Object)this.dropCount);
        try {
            this.releaseUnsafe();
        }
        catch (Exception e) {
            logger.error(ExceptionUtils.getStackTrace((Throwable)e));
        }
        long avarageVideoEncodeTime = 0L;
        long avarageVideoDecodeTime = 0L;
        if (this.videoFrameCount > 0 && totalEncodedFrameCount > 0) {
            avarageVideoEncodeTime = totalVideoEncoderTime / (long)totalEncodedFrameCount;
            avarageVideoDecodeTime = this.getAvgVideoDecodeTime();
        }
        logger.info("Total video encode time {}ms, average video encode time {}ms total audio encode time {}ms total video decode time {}ms , average video decode time {} ms ", new Object[]{totalVideoEncoderTime, avarageVideoEncodeTime, this.totalAudioEncoderTime, this.totalVideoDecodeTime, avarageVideoDecodeTime});
        this.vertx.cancelTimer(this.rtmpWebrtcStatsTaskId);
        this.getApplicationAdaptor().getRtmpToWebRTCStreamsMap().remove(this.streamId);
        this.getApplicationAdaptor().getDataChannelRouter().removePublisher(this.streamId, this);
    }

    public boolean isRecording() {
        if (this.isRecording.get()) {
            for (StreamAdaptor streamAdaptor : this.streamAdaptorList) {
                if (!streamAdaptor.isRecording()) continue;
                return true;
            }
        }
        return this.isRecording.get();
    }

    public VideoEncoder findVP8VideoEncoder(StreamAdaptor streamAdaptor) {
        for (VideoEncoder videoEncoder : streamAdaptor.getVideoEncoderList()) {
            if (!(videoEncoder instanceof VP8Encoder) && (!(videoEncoder instanceof SFUForwarder) || videoEncoder.getCodec() != VideoCodec.VP8)) continue;
            return videoEncoder;
        }
        return null;
    }

    public VideoEncoder findH264VideoEncoder(StreamAdaptor streamAdaptor) {
        for (VideoEncoder videoEncoder : streamAdaptor.getVideoEncoderList()) {
            if (!(videoEncoder instanceof H264Encoder) && (!(videoEncoder instanceof SFUForwarder) || videoEncoder.getCodec() != VideoCodec.H264 && videoEncoder.getCodec() != VideoCodec.H265)) continue;
            return videoEncoder;
        }
        return null;
    }

    public AudioEncoder findAACEncoder(StreamAdaptor streamAdaptor) {
        for (AudioEncoder audioEncoder : streamAdaptor.getAudioEncoderList()) {
            if (!(audioEncoder instanceof AACEncoder)) continue;
            return audioEncoder;
        }
        return null;
    }

    public AudioEncoder findOpusEncoder(StreamAdaptor streamAdaptor) {
        for (AudioEncoder audioEncoder : streamAdaptor.getAudioEncoderList()) {
            if (!(audioEncoder instanceof OpusEncoder) && !(audioEncoder instanceof OpusForwarder)) continue;
            return audioEncoder;
        }
        return null;
    }

    public StreamAdaptor getStreamAdaptor(VideoCodec codec, int resolution) {
        StreamAdaptor selectedStreamAdaptor = null;
        int currentResolutionHeight = 0;
        int currentAudioBitrate = 0;
        for (StreamAdaptor streamAdaptor : this.streamAdaptorList) {
            VideoEncoder videoEncoder = null;
            AudioEncoder audioEncoder = null;
            if (codec == VideoCodec.H264) {
                videoEncoder = this.findH264VideoEncoder(streamAdaptor);
                audioEncoder = this.findAACEncoder(streamAdaptor);
            } else if (codec == VideoCodec.VP8) {
                videoEncoder = this.findVP8VideoEncoder(streamAdaptor);
                audioEncoder = this.findOpusEncoder(streamAdaptor);
            }
            if (videoEncoder != null) {
                if (resolution == 0 && (videoEncoder.getResolutionHeight() > currentResolutionHeight || videoEncoder instanceof SFUForwarder)) {
                    selectedStreamAdaptor = streamAdaptor;
                    currentResolutionHeight = videoEncoder.getResolutionHeight();
                    continue;
                }
                if (resolution == 0 || videoEncoder.getResolutionHeight() != resolution) continue;
                selectedStreamAdaptor = streamAdaptor;
                break;
            }
            if (audioEncoder == null || audioEncoder.getBitrate() <= currentAudioBitrate) continue;
            currentAudioBitrate = audioEncoder.getBitrate();
            selectedStreamAdaptor = streamAdaptor;
        }
        return selectedStreamAdaptor;
    }

    public boolean stopRecording(RecordType recordType) {
        boolean stopRecording = super.stopRecording(recordType);
        if (!stopRecording && this.dynamicWebmMuxer != null) {
            StreamAdaptor streamAdaptor = this.getStreamAdaptor(VideoCodec.VP8, 0);
            stopRecording = this.removeMuxer(streamAdaptor, (Muxer)this.dynamicWebmMuxer);
            if (!stopRecording) {
                logger.warn("WebM Recording could not be removed from list for stream {}", (Object)this.streamId);
            }
            this.dynamicWebmMuxer.writeTrailer();
            this.dynamicWebmMuxer = null;
        }
        return stopRecording;
    }

    public RtmpMuxer findRtmpMuxer(StreamAdaptor streamAdaptor, String rtmpUrl) {
        RtmpMuxer rtmpMuxer;
        for (AudioEncoder audioEncoder : streamAdaptor.getAudioEncoderList()) {
            rtmpMuxer = audioEncoder.getRtmpMuxer(rtmpUrl);
            if (rtmpMuxer == null) continue;
            return rtmpMuxer;
        }
        for (VideoEncoder videoEncoder : streamAdaptor.getVideoEncoderList()) {
            rtmpMuxer = videoEncoder.getRtmpMuxer(rtmpUrl);
            if (rtmpMuxer == null) continue;
            return rtmpMuxer;
        }
        return null;
    }

    public boolean removeMuxer(StreamAdaptor streamAdaptor, Muxer muxer) {
        VideoEncoder videoEncoder;
        AudioEncoder audioEncoder;
        boolean removedFromAudio = false;
        boolean removedFromVideo = false;
        Iterator<Encoder> iterator = streamAdaptor.getAudioEncoderList().iterator();
        while (iterator.hasNext() && !(removedFromAudio = (audioEncoder = iterator.next()).removeMuxer(muxer))) {
        }
        iterator = streamAdaptor.getVideoEncoderList().iterator();
        while (iterator.hasNext() && !(removedFromVideo = (videoEncoder = (VideoEncoder)iterator.next()).removeMuxer(muxer))) {
        }
        if (this.enableAudio && !removedFromAudio) {
            logger.warn("{} is not removed from Audio Encoder for stream {}", (Object)muxer.getClass().getName(), (Object)this.streamId);
        }
        if (this.enableVideo && !removedFromVideo) {
            logger.warn("{} is not removed from Video Encoder for stream {}", (Object)muxer.getClass().getName(), (Object)this.streamId);
        }
        return !(this.enableAudio && !removedFromAudio || this.enableVideo && !removedFromVideo);
    }

    protected boolean startWebMRecording() {
        StreamAdaptor streamAdaptor = this.getStreamAdaptor(VideoCodec.VP8, 0);
        boolean result = false;
        if (streamAdaptor != null) {
            VideoEncoder vp8VideoEncoder = this.findVP8VideoEncoder(streamAdaptor);
            AudioEncoder opusEncoder = this.findOpusEncoder(streamAdaptor);
            if (!(this.enableVideo && vp8VideoEncoder == null || this.enableAudio && opusEncoder == null)) {
                WebMMuxer webMMuxer = new WebMMuxer(this.storageClient, this.vertx, this.getAppSettings().getS3StreamsFolderPath());
                webMMuxer.setAddDateTimeToSourceName(this.addDateTimeToMp4FileName);
                int bitrate = 0;
                int height = 0;
                if (vp8VideoEncoder != null) {
                    if (!(vp8VideoEncoder instanceof SFUForwarder)) {
                        bitrate = vp8VideoEncoder.getBitrate();
                        height = vp8VideoEncoder.getResolutionHeight();
                    }
                } else {
                    bitrate = opusEncoder.getBitrate();
                }
                webMMuxer.init(this.scope, this.streamId, height, this.getBroadcast().getSubFolder(), bitrate);
                webMMuxer.setDynamic(true);
                logger.info("start webm recording video stream index: {} audio stream index:{}", (Object)this.getVideoStreamIndex(), (Object)this.getAudioStreamIndex());
                if (this.getVideoStreamIndex() <= this.getAudioStreamIndex()) {
                    if (vp8VideoEncoder != null) {
                        vp8VideoEncoder.addMuxer((Muxer)webMMuxer);
                    }
                    if (opusEncoder != null) {
                        opusEncoder.addMuxer((Muxer)webMMuxer);
                    }
                } else {
                    if (opusEncoder != null) {
                        opusEncoder.addMuxer((Muxer)webMMuxer);
                    }
                    if (vp8VideoEncoder != null) {
                        vp8VideoEncoder.addMuxer((Muxer)webMMuxer);
                    }
                }
                if (result = webMMuxer.prepareIO()) {
                    if (this.getClass().equals(EncoderAdaptor.class)) {
                        this.dynamicWebmMuxer = webMMuxer;
                    } else {
                        this.addMuxer((Muxer)webMMuxer);
                    }
                }
            }
        }
        return result;
    }

    public boolean startRecording(RecordType recordType) {
        boolean recording = super.startRecording(recordType);
        if (!recording && recordType == RecordType.WEBM) {
            if (!this.isRecording.get()) {
                logger.warn("Starting recording return false for stream:{} because stream is being prepared", (Object)this.streamId);
                return false;
            }
            if (this.dynamicWebmMuxer == null) {
                recording = this.startWebMRecording();
            }
        }
        return recording;
    }

    public boolean startRtmpStreaming(String rtmpUrl, int resolutionHeight) {
        boolean started = super.startRtmpStreaming(rtmpUrl, resolutionHeight);
        if (!started) {
            started = this.startRtmpStreamingInStreamAdaptor(rtmpUrl, resolutionHeight);
        }
        return started;
    }

    public boolean stopRtmpStreaming(String rtmpUrl, int resolutionHeight) {
        boolean stopped = super.stopRtmpStreaming(rtmpUrl, resolutionHeight);
        if (!stopped) {
            stopped = this.stopRtmpStreamingInStreamAdaptor(rtmpUrl, resolutionHeight);
        }
        return stopped;
    }

    public boolean stopRtmpStreamingInStreamAdaptor(String rtmpUrl, int resolutionHeight) {
        boolean result = false;
        StreamAdaptor streamAdaptor = this.getStreamAdaptor(VideoCodec.H264, resolutionHeight);
        if (streamAdaptor != null) {
            RtmpMuxer rtmpMuxer = this.findRtmpMuxer(streamAdaptor, rtmpUrl);
            if (rtmpMuxer != null) {
                result = this.removeMuxer(streamAdaptor, (Muxer)rtmpMuxer);
                rtmpMuxer.writeTrailer();
            } else {
                logger.warn("Rtmp muxer({}) is not removed from the list for stream: {} ", (Object)rtmpUrl, (Object)this.streamId);
            }
        }
        return result;
    }

    public RtmpMuxer createRtmpMuxer(String rtmpUrl) {
        return new RtmpMuxer(rtmpUrl, this.vertx);
    }

    public boolean startRtmpStreamingInStreamAdaptor(String rtmpUrl, int resolutionHeight) {
        if (!this.isRecording.get()) {
            logger.warn("Start rtmp streaming return false for stream:{} because stream is being prepared", (Object)this.streamId);
            return false;
        }
        StreamAdaptor streamAdaptor = this.getStreamAdaptor(VideoCodec.H264, resolutionHeight);
        boolean result = false;
        if (streamAdaptor != null) {
            VideoEncoder h264VideoEncoder = this.findH264VideoEncoder(streamAdaptor);
            AudioEncoder aacEncoder = this.findAACEncoder(streamAdaptor);
            if (h264VideoEncoder != null || aacEncoder != null) {
                RtmpMuxer rtmpMuxer = this.createRtmpMuxer(rtmpUrl);
                rtmpMuxer.setStatusListener((IEndpointStatusListener)this);
                rtmpMuxer.init(this.scope, this.streamId, 0, this.getBroadcast().getSubFolder(), 0);
                if (this.getVideoStreamIndex() <= this.getAudioStreamIndex()) {
                    this.addMuxer2Encoder(h264VideoEncoder, rtmpMuxer);
                    this.addMuxer2Encoder(aacEncoder, rtmpMuxer);
                } else {
                    this.addMuxer2Encoder(aacEncoder, rtmpMuxer);
                    this.addMuxer2Encoder(h264VideoEncoder, rtmpMuxer);
                }
                result = rtmpMuxer.prepareIO();
            } else {
                logger.warn("h264 or aac encoder is not found in the list. You may need to enable mp4 or hls muxing in order to create AAC encoder");
            }
        } else {
            logger.warn("Could not find proper stream adaptor to add RTMP url:{} for resolution:{} and streamId:{}", new Object[]{rtmpUrl, resolutionHeight, this.streamId});
        }
        return result;
    }

    private void addMuxer2Encoder(Encoder encoder, RtmpMuxer rtmpMuxer) {
        if (encoder != null) {
            encoder.addMuxer((Muxer)rtmpMuxer);
        }
    }

    private AVFrame decodeAudioFrame(AVRational timebase, AVPacket pkt) {
        return this.aacDecoder.decodeAudioFrame(timebase, pkt);
    }

    private void sendVideoPacket(AVRational timebase, AVPacket pkt) {
        avcodec.av_packet_rescale_ts((AVPacket)pkt, (AVRational)timebase, (AVRational)this.videoEncoderTimebase);
        int ret = avcodec.avcodec_send_packet((AVCodecContext)this.videoContext, (AVPacket)pkt);
        if (ret < 0) {
            logger.error("Cannot send video packet for decoding for stream: {}", (Object)this.streamId);
        }
    }

    private AVFrame receiveVideoPacket() {
        int ret = avcodec.avcodec_receive_frame((AVCodecContext)this.videoContext, (AVFrame)this.picture);
        if (ret == org.bytedeco.ffmpeg.presets.avutil.AVERROR_EAGAIN() || ret == avutil.AVERROR_EOF()) {
            return null;
        }
        if (ret < 0 && logger.isErrorEnabled()) {
            byte[] data = new byte[2048];
            avutil.av_strerror((int)ret, (byte[])data, (long)data.length);
            logger.error("Decode video frame error: {}", (Object)new String(data, 0, data.length));
            return null;
        }
        return this.picture;
    }

    public boolean isMkvMuxingEnabled() {
        return this.mkvMuxingEnabled;
    }

    public void setMkvMuxingEnabled(boolean mkvMuxingEnabled) {
        this.mkvMuxingEnabled = mkvMuxingEnabled;
    }

    public boolean isOpusEncoderEnabled() {
        return this.opusEncoderEnabled;
    }

    public void setOpusEncoderEnabled(boolean opusEncoderEnabled) {
        this.opusEncoderEnabled = opusEncoderEnabled;
    }

    public IWebRTCAdaptor getWebRTCAdaptor() {
        return this.webRTCAdaptor;
    }

    public void setWebRTCAdaptor(IWebRTCAdaptor webRTCAdaptor) {
        this.webRTCAdaptor = webRTCAdaptor;
    }

    public void setDropPacketEnabled(boolean enable) {
        this.dropPacketEnabled = enable;
    }

    public List<StreamAdaptor> getStreamAdaptorList() {
        return this.streamAdaptorList;
    }

    public List<StreamInfo> getStreamInfoList() {
        if (this.webRTCAdaptor != null && this.streamInfoList == null && !this.streamAdaptorList.isEmpty()) {
            this.streamInfoList = new ArrayList();
            for (StreamAdaptor streamAdaptor : this.streamAdaptorList) {
                if (!streamAdaptor.isStreamable()) continue;
                if (this.isEnableVideo()) {
                    for (VideoEncoder videoEncoder : streamAdaptor.getVideoEncoderList()) {
                        if (!(videoEncoder instanceof H264Encoder) && !(videoEncoder instanceof VP8Encoder) && !(videoEncoder instanceof SFUForwarder)) continue;
                        StreamInfo streamInfo = new StreamInfo();
                        streamInfo.setStreamId(this.getStreamId());
                        streamInfo.setVideoEnabled(true);
                        streamInfo.setHeight(videoEncoder.getResolutionHeight());
                        streamInfo.setWidth(videoEncoder.getResolutionWidth());
                        streamInfo.setVideoBitrate(videoEncoder.getBitrate());
                        streamInfo.setVideoCodec(videoEncoder.getCodec());
                        streamInfo.setNodeGroup(this.serverSettings.getNodeGroup());
                        streamInfo.setGlobalHost(true);
                        AVRational timebase = videoEncoder.getTimebase();
                        if (timebase != null) {
                            streamInfo.setVideoRTimebase(timebase.den());
                        }
                        if (this.isEnableAudio()) {
                            List<AudioEncoder> audioEncoderList = streamAdaptor.getAudioEncoderList();
                            for (AudioEncoder audioEncoder : audioEncoderList) {
                                if (!audioEncoder.getCodecName().contains("opus")) continue;
                                streamInfo.setAudioEnabled(true);
                                streamInfo.setAudioBitrate(audioEncoder.getBitrate());
                                timebase = audioEncoder.getTimebase();
                                if (timebase == null) break;
                                streamInfo.setAudioRTimebase(timebase.den());
                                break;
                            }
                        }
                        this.streamInfoList.add(streamInfo);
                    }
                    continue;
                }
                if (!this.isEnableAudio()) continue;
                List<AudioEncoder> audioEncoderList = streamAdaptor.getAudioEncoderList();
                StreamInfo streamInfo = new StreamInfo();
                streamInfo.setStreamId(this.getStreamId());
                streamInfo.setVideoCodec(VideoCodec.NOVIDEO);
                streamInfo.setNodeGroup(this.serverSettings.getNodeGroup());
                streamInfo.setGlobalHost(true);
                for (AudioEncoder audioEncoder : audioEncoderList) {
                    if (!audioEncoder.getCodecName().contains("opus")) continue;
                    streamInfo.setAudioEnabled(true);
                    streamInfo.setAudioBitrate(audioEncoder.getBitrate());
                    AVRational timebase = audioEncoder.getTimebase();
                    if (timebase == null) break;
                    streamInfo.setAudioRTimebase(timebase.den());
                    break;
                }
                this.streamInfoList.add(streamInfo);
            }
        }
        logger.info("getStreamInfoList size: {} for stream: {}", (Object)(this.streamInfoList != null ? Integer.valueOf(this.streamInfoList.size()) : null), (Object)this.streamId);
        return this.streamInfoList;
    }

    public void startOriginIfRequired() {
        if (this.isInClusterMode()) {
            List<StreamInfo> infoList = this.getStreamInfoList();
            for (StreamInfo streamInfo : infoList) {
                streamInfo.setHost(this.serverSettings.getHostAddress());
                OriginServer originServer = new OriginServer(streamInfo.getStreamId(), this.vertx, streamInfo.isVideoEnabled(), streamInfo.isAudioEnabled());
                originServer.setStatusListener(new OriginServerStatusListener(this.webRTCAdaptor, this.dataStore, streamInfo, originServer));
                boolean dataChannelEnabled = this.getAppSettings().isDataChannelEnabled() && streamInfo == infoList.get(0);
                originServer.setDataChannelEnabled(dataChannelEnabled);
                streamInfo.setDataChannelEnabled(dataChannelEnabled);
                if (dataChannelEnabled) {
                    originServer.setDataChannelRouter(this.getApplicationAdaptor().getDataChannelRouter());
                }
                originServer.start();
            }
        }
    }

    protected void clearStreamInfo() {
        this.dataStore.clearStreamInfoList(this.getStreamId());
    }

    public boolean isInClusterMode() {
        return this.scope.getContext().hasBean("tomcat.cluster");
    }

    public void setVertx(Vertx vertx) {
        this.vertx = vertx;
    }

    public void setDataStore(DataStore dataStore) {
        this.dataStore = dataStore;
    }

    public void setServerSettings(ServerSettings serverSettings) {
        this.serverSettings = serverSettings;
    }

    public long getAvgVideoDecodeTime() {
        return this.totalVideoDecodeTime / (long)this.videoFrameCount;
    }

    private void startStats() {
        this.rtmpWebrtcStats = new RTMPToWebRTCStats(this.streamId);
        this.rtmpWebrtcStatsTaskId = this.vertx.setPeriodic(5000L, id -> this.calculateStats());
    }

    private void calculateStats() {
        this.rtmpWebrtcStats.setTotalVideoDecodeTime(this.totalVideoDecodeTime);
        this.rtmpWebrtcStats.setTotalDecodedVideoFrameCount((long)this.videoFrameCount);
        this.rtmpWebrtcStats.setTotalVideoIngestTime(this.totalIngestTime);
        this.rtmpWebrtcStats.setTotalIngestedVideoPacketCount((long)this.totalIngestedVideoPacketCount);
        this.rtmpWebrtcStats.setAbsoluteIngestTime(this.absoluteTotalIngestTime);
        this.rtmpWebrtcStats.setAbsoluteTimeMs(this.getAbsoluteTimeMs());
        long totalEncodeTime = 0L;
        long totalEncodedVideoPacketCount = 0L;
        long totalDeliveryTime = 0L;
        long totalDeliveredPacketCount = 0L;
        long totalVideoEncodeQueueTime = 0L;
        int h264EncoderCount = 0;
        long absouteTotalLatencyUntilRTPPacketizingTimeMs = 0L;
        long frameId = 0L;
        long captureTimeMs = 0L;
        for (StreamAdaptor streamAdaptor : this.streamAdaptorList) {
            for (VideoEncoder videoEncoder : streamAdaptor.getVideoEncoderList()) {
                if (videoEncoder instanceof H264Encoder || videoEncoder instanceof H265Encoder || videoEncoder instanceof SFUForwarder) {
                    totalEncodeTime += videoEncoder.getTotalProcessingTime();
                    totalEncodedVideoPacketCount += videoEncoder.getEncodedPacketCount();
                    totalVideoEncodeQueueTime += videoEncoder.getTotalVideoEncodeQueueTime();
                    ++h264EncoderCount;
                }
                List<Muxer> muxers = videoEncoder.getMuxerList();
                for (Muxer muxer : muxers) {
                    if (!(muxer instanceof WebRTCMuxer)) continue;
                    totalDeliveryTime += ((WebRTCMuxer)muxer).getTotalVideoProcessingTime();
                    totalDeliveredPacketCount += ((WebRTCMuxer)muxer).getVideoPacketCount();
                    absouteTotalLatencyUntilRTPPacketizingTimeMs += ((WebRTCMuxer)muxer).getAbsouteTotalLatencyUntilRTPPacketizingTimeMs();
                    frameId = ((WebRTCMuxer)muxer).getFrameId();
                    captureTimeMs = ((WebRTCMuxer)muxer).getCaptureTimeMs();
                }
            }
        }
        this.rtmpWebrtcStats.setFrameId(frameId);
        this.rtmpWebrtcStats.setCaptureTimeMs(captureTimeMs);
        this.rtmpWebrtcStats.setAbsouteTotalLatencyUntilRTPPacketizingTimeMs(absouteTotalLatencyUntilRTPPacketizingTimeMs);
        this.rtmpWebrtcStats.setEncoderCount(h264EncoderCount);
        this.rtmpWebrtcStats.setTotalVideoEncodeQueueTime(totalVideoEncodeQueueTime);
        this.rtmpWebrtcStats.setTotalVideoEncodeTime(totalEncodeTime / 1000000L);
        this.rtmpWebrtcStats.setTotalEncodedVideoPacketCount(totalEncodedVideoPacketCount);
        this.rtmpWebrtcStats.setTotalVideoDeliveryTime(totalDeliveryTime);
        this.rtmpWebrtcStats.setTotalDeliveredVideoPacketCount(totalDeliveredPacketCount);
    }

    public RTMPToWebRTCStats getRtmpWebrtcStats() {
        return this.rtmpWebrtcStats;
    }

    public void setRtmpWebrtcStats(RTMPToWebRTCStats rtmpWebrtcStats) {
        this.rtmpWebrtcStats = rtmpWebrtcStats;
    }

    public WebRTCApplication getApplicationAdaptor() {
        AntMediaApplicationAdapter appAdaptor;
        if (this.applicationAdaptor == null && (appAdaptor = (AntMediaApplicationAdapter)this.scope.getContext().getApplicationContext().getBean("web.handler")) instanceof WebRTCApplication) {
            this.applicationAdaptor = (WebRTCApplication)appAdaptor;
        }
        return this.applicationAdaptor;
    }

    public void setApplicationAdaptor(WebRTCApplication applicationAdaptor) {
        this.applicationAdaptor = applicationAdaptor;
    }

    @Override
    public void sendMessageViaDataChannel(DataChannel.Buffer buffer) {
        this.sendMessageToDataChannelWebHook(buffer);
    }

    @Override
    public void sendMessageToDataChannelWebHook(DataChannel.Buffer buffer) {
        if (this.dataChannelWebHookURL != null) {
            this.vertx.setTimer(10L, h -> {
                try {
                    buffer.data.rewind();
                    this.sendPOST(this.dataChannelWebHookURL, buffer.binary, buffer.data);
                }
                catch (Exception e) {
                    logger.error("Request to {} not succeeded. Check the log below", (Object)this.dataChannelWebHookURL);
                    logger.error(ExceptionUtils.getStackTrace((Throwable)e));
                }
            });
        }
    }

    public StringBuilder sendPOST(String url, boolean binary, ByteBuffer data) throws IOException {
        StringBuilder response = null;
        try (CloseableHttpClient httpClient = this.getHttpClient();){
            HttpPost httpPost = new HttpPost(url + "?binary=" + binary);
            byte[] dataArray = new byte[data.limit()];
            data.get(dataArray);
            MultipartEntityBuilder builder = MultipartEntityBuilder.create();
            if (binary) {
                builder.addBinaryBody("data", dataArray);
            } else {
                builder.addTextBody("data", new String(dataArray));
            }
            httpPost.setEntity(builder.build());
            try (CloseableHttpResponse httpResponse = httpClient.execute((HttpUriRequest)httpPost);){
                if (httpResponse != null) {
                    logger.info("POST Response Status:: {}", (Object)httpResponse.getStatusLine().getStatusCode());
                    HttpEntity entity = httpResponse.getEntity();
                    if (entity != null) {
                        String inputLine;
                        BufferedReader reader = new BufferedReader(new InputStreamReader(entity.getContent()));
                        response = new StringBuilder();
                        while ((inputLine = reader.readLine()) != null) {
                            response.append(inputLine);
                        }
                        reader.close();
                    }
                }
            }
        }
        return response;
    }

    public RequestConfig getHttpRequestConfig() {
        return RequestConfig.custom().setConnectTimeout(2000).setConnectionRequestTimeout(2000).setSocketTimeout(2000).build();
    }

    public CloseableHttpClient getHttpClient() {
        return HttpClients.custom().setDefaultRequestConfig(this.getHttpRequestConfig()).build();
    }
}

