/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.enterprise.adaptive;

import io.antmedia.RecordType;
import io.antmedia.enterprise.adaptive.EncoderAdaptor;
import io.antmedia.enterprise.adaptive.StreamAdaptor;
import io.antmedia.enterprise.adaptive.base.AudioEncoder;
import io.antmedia.enterprise.adaptive.base.VideoEncoder;
import io.antmedia.enterprise.adaptive.video.SFUForwarder;
import io.antmedia.muxer.Mp4Muxer;
import io.antmedia.muxer.Muxer;
import io.antmedia.webrtc.VideoCodec;
import org.red5.server.stream.ClientBroadcastStream;

public class DecodedStreamsEncoderAdaptor
extends EncoderAdaptor {
    public DecodedStreamsEncoderAdaptor(ClientBroadcastStream clientBroadcastStream) {
        super(clientBroadcastStream);
    }

    @Override
    public boolean startRtmpStreaming(String rtmpUrl, int resolutionHeight) {
        return this.startRtmpStreamingInStreamAdaptor(rtmpUrl, resolutionHeight);
    }

    @Override
    public boolean stopRtmpStreaming(String rtmpUrl, int resolutionHeight) {
        return this.stopRtmpStreamingInStreamAdaptor(rtmpUrl, resolutionHeight);
    }

    @Override
    public boolean startRecording(RecordType recordType) {
        boolean result = false;
        if (recordType == RecordType.MP4) {
            result = this.startMp4Recording();
        } else if (recordType == RecordType.WEBM) {
            result = this.startWebMRecording();
        }
        return result;
    }

    public boolean startMp4Recording() {
        StreamAdaptor streamAdaptor = this.getStreamAdaptor(VideoCodec.H264, 0);
        boolean result = false;
        if (streamAdaptor != null) {
            VideoEncoder videoEncoder = this.findH264VideoEncoder(streamAdaptor);
            logger.info("Recording video codec is = {} for streamId:{}", (Object)videoEncoder, (Object)this.streamId);
            AudioEncoder aacEncoder = this.findAACEncoder(streamAdaptor);
            if (!(this.enableVideo && videoEncoder == null || this.enableAudio && aacEncoder == null)) {
                Mp4Muxer mp4Muxer = this.createMp4Muxer();
                mp4Muxer.setAddDateTimeToSourceName(this.addDateTimeToMp4FileName);
                int bitrate = 0;
                int height = 0;
                if (videoEncoder != null) {
                    if (!(videoEncoder instanceof SFUForwarder)) {
                        bitrate = videoEncoder.getBitrate();
                        height = videoEncoder.getResolutionHeight();
                    }
                } else {
                    bitrate = aacEncoder.getBitrate();
                }
                mp4Muxer.init(this.scope, this.streamId, height, this.getBroadcast().getSubFolder(), bitrate);
                mp4Muxer.setDynamic(true);
                if (aacEncoder != null) {
                    aacEncoder.addMuxer((Muxer)mp4Muxer);
                }
                if (videoEncoder != null) {
                    videoEncoder.addMuxer((Muxer)mp4Muxer);
                }
                if (result = mp4Muxer.prepareIO()) {
                    this.addMuxer((Muxer)mp4Muxer);
                    logger.info("Start mp4 recording for stream: {}", (Object)this.streamId);
                } else {
                    logger.info("Mp4 muxer prepareIO returns false for stream:{}", (Object)this.streamId);
                }
            } else {
                logger.warn("There is no ( h264 or h265 ) and aac encoder for recording mp4 for stream:{}", (Object)this.streamId);
            }
        } else {
            logger.warn("There is no stream adaptor for mp4 recording for stream:{}", (Object)this.streamId);
        }
        return result;
    }

    @Override
    public boolean stopRecording(RecordType recordType) {
        logger.info("Stop recording for stream: {}", (Object)this.streamId);
        boolean result = false;
        if (recordType == RecordType.MP4) {
            result = this.stopMp4Recording();
        } else if (recordType == RecordType.WEBM) {
            result = this.stopWebMRecording();
        }
        return result;
    }

    protected boolean stopWebMRecording() {
        Muxer webMMuxer = this.findDynamicRecordMuxer(RecordType.WEBM);
        boolean result = false;
        if (webMMuxer != null) {
            StreamAdaptor streamAdaptor = this.getStreamAdaptor(VideoCodec.VP8, 0);
            result = this.removeMuxer(streamAdaptor, webMMuxer);
            if (!result) {
                logger.warn("WebM Recording could not be removed from list for stream {}", (Object)this.streamId);
            }
            this.muxerList.remove(webMMuxer);
            webMMuxer.writeTrailer();
        }
        return result;
    }

    private boolean stopMp4Recording() {
        Muxer mp4Muxer = this.findDynamicRecordMuxer(RecordType.MP4);
        boolean result = false;
        if (mp4Muxer != null) {
            StreamAdaptor streamAdaptor = this.getStreamAdaptor(VideoCodec.H264, 0);
            result = this.removeMuxer(streamAdaptor, mp4Muxer);
            if (!result) {
                logger.warn("MP4 Recording could not be removed from list for stream {}", (Object)this.streamId);
            }
            this.muxerList.remove(mp4Muxer);
            mp4Muxer.writeTrailer();
        } else {
            logger.warn("There is no MP4Muxer to stop for stream:{}", (Object)this.streamId);
        }
        return result;
    }
}

