/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.enterprise.adaptive;

import java.util.concurrent.ConcurrentLinkedQueue;
import org.bytedeco.ffmpeg.avutil.AVFrame;
import org.bytedeco.ffmpeg.global.avutil;

public class AVFramePool {
    private ConcurrentLinkedQueue<AVFrame> availableFrames = new ConcurrentLinkedQueue();

    public AVFrame getAVFrame() {
        if (!this.availableFrames.isEmpty()) {
            return this.availableFrames.poll();
        }
        return new AVFrame();
    }

    public void addFrame2Pool(AVFrame frame) {
        avutil.av_frame_unref((AVFrame)frame);
        this.availableFrames.offer(frame);
    }

    public void releaseFrames() {
        for (AVFrame avFrame : this.availableFrames) {
            avutil.av_frame_unref((AVFrame)avFrame);
            avFrame.close();
        }
        this.availableFrames = null;
    }
}

