/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.proxy.toys.hotswap;

import com.thoughtworks.proxy.ProxyFactory;
import com.thoughtworks.proxy.kit.ObjectReference;
import com.thoughtworks.proxy.toys.delegate.DelegatingInvoker;
import com.thoughtworks.proxy.toys.delegate.DelegationMode;
import com.thoughtworks.proxy.toys.hotswap.Swappable;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Method;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HotSwappingInvoker<T>
extends DelegatingInvoker<Object> {
    private static final long serialVersionUID = 1L;
    private static final Method hotswap;
    private static final Method checkForCycle;
    private Class<?>[] types;
    private transient boolean executed = false;
    private transient ThreadLocal<Object> delegate;

    public HotSwappingInvoker(Class<?>[] types, ProxyFactory proxyFactory, ObjectReference<Object> delegateReference, DelegationMode delegationMode) {
        super(proxyFactory, delegateReference, delegationMode);
        this.types = types;
        this.delegate = new ThreadLocal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Object result;
        try {
            this.delegate.set(this.delegate());
            if (method.equals(hotswap)) {
                result = this.hotswap(args[0]);
            } else {
                if (method.equals(checkForCycle)) {
                    if (this.executed) {
                        throw new IllegalStateException("Cyclic dependency");
                    }
                    if (this.delegate() instanceof CycleCheck) {
                        this.executed = true;
                        ((CycleCheck)CycleCheck.class.cast(this.delegate())).checkForCycle();
                        this.executed = false;
                    }
                    Class<Void> clazz = Void.TYPE;
                    return clazz;
                }
                result = super.invoke(proxy, method, args);
            }
        }
        finally {
            this.delegate.set(null);
        }
        return result;
    }

    @Override
    protected Object delegate() {
        Object currentDelegate = this.delegate.get();
        if (currentDelegate == null) {
            return super.delegate();
        }
        return currentDelegate;
    }

    protected Object hotswap(Object newDelegate) {
        ObjectReference<Object> ref = this.getDelegateReference();
        Object result = ref.get();
        this.delegate.set(newDelegate);
        ref.set(newDelegate);
        if (newDelegate instanceof CycleCheck) {
            ((CycleCheck)CycleCheck.class.cast(newDelegate)).checkForCycle();
        }
        return result;
    }

    public T proxy() {
        Class[] typesWithSwappable = new Class[this.types.length + 2];
        System.arraycopy(this.types, 0, typesWithSwappable, 0, this.types.length);
        typesWithSwappable[this.types.length] = Swappable.class;
        typesWithSwappable[this.types.length + 1] = CycleCheck.class;
        return this.getProxyFactory().createProxy(this, typesWithSwappable);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.delegate = new ThreadLocal();
    }

    static {
        try {
            hotswap = Swappable.class.getMethod("hotswap", Object.class);
            checkForCycle = CycleCheck.class.getMethod("checkForCycle", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new ExceptionInInitializerError(e.toString());
        }
    }

    protected static interface CycleCheck {
        public void checkForCycle();
    }
}

