/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.proxy.toys.echo;

import com.thoughtworks.proxy.ProxyFactory;
import com.thoughtworks.proxy.toys.decorate.Decorating;
import com.thoughtworks.proxy.toys.decorate.Decorator;
import java.io.PrintWriter;
import java.lang.reflect.Method;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EchoDecorator<T>
extends Decorator<T> {
    private static final long serialVersionUID = 1L;
    private final PrintWriter out;
    private final ProxyFactory factory;

    public EchoDecorator(PrintWriter out, ProxyFactory factory) {
        this.out = out;
        this.factory = factory;
    }

    @Override
    public Object[] beforeMethodStarts(T proxy, Method method, Object[] args) {
        this.printMethodCall(method, args);
        return super.beforeMethodStarts(proxy, method, args);
    }

    @Override
    public Object decorateResult(T proxy, Method method, Object[] args, Object result) {
        Class<?> returnType = method.getReturnType();
        this.printMethodResult(result);
        if (returnType != Object.class && this.factory.canProxy(returnType)) {
            result = Decorating.proxy(result, returnType).visiting(this).build(this.factory);
        } else if (result != null && returnType == Object.class && this.factory.canProxy(result.getClass())) {
            returnType = result.getClass();
            result = Decorating.proxy(result, returnType).visiting(this).build(this.factory);
        }
        return result;
    }

    @Override
    public Throwable decorateTargetException(T proxy, Method method, Object[] args, Throwable cause) {
        this.printTargetException(cause);
        return super.decorateTargetException(proxy, method, args, cause);
    }

    @Override
    public Exception decorateInvocationException(T proxy, Method method, Object[] args, Exception cause) {
        this.printInvocationException(cause);
        return super.decorateInvocationException(proxy, method, args, cause);
    }

    private void printMethodCall(Method method, Object[] args) {
        StringBuilder buf = new StringBuilder("[");
        buf.append(Thread.currentThread().getName());
        buf.append("] ");
        buf.append(method.getDeclaringClass().getName());
        buf.append(".").append(method.getName());
        if (args == null) {
            args = new Object[]{};
        }
        buf.append("(");
        for (int i = 0; i < args.length; ++i) {
            buf.append(i == 0 ? "<" : ", <").append(args[i]).append(">");
        }
        buf.append(") ");
        this.out.print(buf);
        this.out.flush();
    }

    private void printMethodResult(Object result) {
        StringBuilder buf = new StringBuilder("--> <");
        buf.append(result == null ? "NULL" : result.toString());
        buf.append(">");
        this.out.println(buf);
        this.out.flush();
    }

    private void printTargetException(Throwable throwable) {
        StringBuilder buf = new StringBuilder("throws ");
        buf.append(throwable.getClass().getName());
        buf.append(": ");
        buf.append(throwable.getMessage());
        this.out.println(buf);
        this.out.flush();
    }

    private void printInvocationException(Throwable throwable) {
        this.out.print("INTERNAL ERROR, ");
        this.printTargetException(throwable);
    }
}

