/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.proxy.toys.dispatch;

import com.thoughtworks.proxy.Invoker;
import com.thoughtworks.proxy.ProxyFactory;
import com.thoughtworks.proxy.factory.InvokerReference;
import com.thoughtworks.proxy.factory.StandardProxyFactory;
import com.thoughtworks.proxy.kit.ObjectReference;
import com.thoughtworks.proxy.kit.ReflectionUtils;
import com.thoughtworks.proxy.toys.delegate.DelegatingInvoker;
import com.thoughtworks.proxy.toys.delegate.DelegationMode;
import com.thoughtworks.proxy.toys.dispatch.DispatchingException;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DispatchingInvoker
implements Invoker {
    private static final long serialVersionUID = 1L;
    private List<Class<?>> types;
    private Invoker[] invokers;
    private transient Set<Method>[] methodSets;
    private transient Method[] toStringMethods;

    public DispatchingInvoker(ProxyFactory proxyFactory, Class<?>[] types, ObjectReference<Object>[] delegateReferences) {
        this.types = Arrays.asList(types);
        this.invokers = new Invoker[types.length];
        this.toStringMethods = new Method[types.length];
        Set[] sets = new Set[types.length];
        this.methodSets = sets;
        for (int i = 0; i < types.length; ++i) {
            block1: for (ObjectReference<Object> delegateReference : delegateReferences) {
                if (!types[i].isAssignableFrom(delegateReference.get().getClass())) continue;
                this.invokers[i] = new DelegatingInvoker<Object>(proxyFactory, delegateReference, DelegationMode.DIRECT);
                this.methodSets[i] = new HashSet<Method>(Arrays.asList(types[i].getMethods()));
                for (Method method : this.methodSets[i]) {
                    if (!method.getName().equals("toString") || method.getParameterTypes().length != 0) continue;
                    this.toStringMethods[i] = method;
                    break block1;
                }
                break;
            }
            if (this.invokers[i] != null) continue;
            throw new DispatchingException("Cannot dispatch type " + types[i].getName(), types[i]);
        }
    }

    protected DispatchingInvoker() {
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (method.equals(ReflectionUtils.equals)) {
            Object arg = args[0];
            if (new StandardProxyFactory().isProxyClass(arg.getClass()) && ((InvokerReference)InvokerReference.class.cast(arg)).getInvoker() instanceof DispatchingInvoker) {
                DispatchingInvoker invoker = (DispatchingInvoker)DispatchingInvoker.class.cast(((InvokerReference)InvokerReference.class.cast(arg)).getInvoker());
                if (this.types.size() == invoker.types.size()) {
                    boolean isEqual = true;
                    for (int i = 0; isEqual && i < this.types.size(); ++i) {
                        Class<?> type = this.types.get(i);
                        for (int j = 0; isEqual && j < invoker.types.size(); ++j) {
                            if (!invoker.types.get(j).equals(type) || this.invokers[i].equals(invoker.invokers[j])) continue;
                            isEqual = false;
                        }
                    }
                    return isEqual;
                }
            }
            return Boolean.FALSE;
        }
        if (method.equals(ReflectionUtils.hashCode)) {
            return this.hashCode();
        }
        if (method.equals(ReflectionUtils.toString)) {
            for (int i = 0; i < this.invokers.length; ++i) {
                Method toString = this.toStringMethods[i];
                if (toString == null || !toString.getDeclaringClass().isAssignableFrom(proxy.getClass())) continue;
                return this.invokers[i].invoke(proxy, method, args);
            }
            return this.types.toString();
        }
        for (int i = 0; i < this.invokers.length; ++i) {
            if (!this.methodSets[i].contains(method)) continue;
            return this.invokers[i].invoke(proxy, method, args);
        }
        throw new RuntimeException("Cannot dispatch method " + method.getName());
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        List[] types = new List[this.methodSets.length];
        List[] names = new List[this.methodSets.length];
        List[] arguments = new List[this.methodSets.length];
        for (int i = 0; i < this.methodSets.length; ++i) {
            Method[] methods = this.methodSets[i].toArray(new Method[this.methodSets[i].size()]);
            types[i] = new ArrayList();
            names[i] = new ArrayList();
            arguments[i] = new ArrayList();
            for (Method method : methods) {
                types[i].add(method.getDeclaringClass());
                names[i].add(method.getName());
                arguments[i].add(method.getParameterTypes());
            }
        }
        out.writeObject(types);
        out.writeObject(names);
        out.writeObject(arguments);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        List[] types = (List[])List[].class.cast(in.readObject());
        List[] names = (List[])List[].class.cast(in.readObject());
        List[] arguments = (List[])List[].class.cast(in.readObject());
        Set[] set = new Set[types.length];
        this.methodSets = set;
        this.toStringMethods = new Method[types.length];
        try {
            for (int i = 0; i < this.methodSets.length; ++i) {
                this.methodSets[i] = new HashSet<Method>();
                for (int j = 0; j < types[i].size(); ++j) {
                    Class type = (Class)types[i].get(j);
                    String name = (String)names[i].get(j);
                    Class[] argumentTypes = (Class[])arguments[i].get(j);
                    Method method = type.getMethod(name, argumentTypes);
                    this.methodSets[i].add(method);
                    if (!name.equals("toString") || argumentTypes.length != 0) continue;
                    this.toStringMethods[i] = method;
                }
            }
        }
        catch (NoSuchMethodException e) {
            throw new InvalidObjectException(e.getMessage());
        }
    }
}

