/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.proxy.kit;

import com.thoughtworks.proxy.ProxyFactory;
import com.thoughtworks.proxy.factory.InvokerReference;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReflectionUtils {
    public static final Method equals;
    public static final Method hashCode;
    public static final Method toString;

    private ReflectionUtils() {
    }

    public static Set<Class<?>> getAllInterfaces(Object ... objects) {
        HashSet interfaces = new HashSet();
        for (Object object : objects) {
            if (object == null) continue;
            ReflectionUtils.getInterfaces(object.getClass(), interfaces);
        }
        interfaces.remove(InvokerReference.class);
        return interfaces;
    }

    public static Set<Class<?>> getAllInterfaces(Class<?> type) {
        HashSet interfaces = new HashSet();
        ReflectionUtils.getInterfaces(type, interfaces);
        interfaces.remove(InvokerReference.class);
        return interfaces;
    }

    private static void getInterfaces(Class<?> type, Set<Class<?>> interfaces) {
        if (type.isInterface()) {
            interfaces.add(type);
        }
        while (type != null) {
            for (Class<?> anImplemented : type.getInterfaces()) {
                if (interfaces.contains(anImplemented)) continue;
                ReflectionUtils.getInterfaces(anImplemented, interfaces);
            }
            type = type.getSuperclass();
        }
    }

    public static Class<?> getMostCommonSuperclass(Object ... objects) {
        Class type = null;
        boolean found = false;
        if (objects != null && objects.length > 0) {
            block0: while (!found) {
                for (Object object : objects) {
                    found = true;
                    if (object == null) continue;
                    Class<?> currenttype = object.getClass();
                    if (type == null) {
                        type = currenttype;
                    }
                    if (type.isAssignableFrom(currenttype)) continue;
                    if (currenttype.isAssignableFrom(type)) {
                        type = currenttype;
                        continue;
                    }
                    type = type.getSuperclass();
                    found = false;
                    continue block0;
                }
            }
        }
        if (type == null) {
            type = Object.class;
        }
        return type;
    }

    public static void addIfClassProxyingSupportedAndNotObject(Class<?> type, Set<Class<?>> interfaces, ProxyFactory proxyFactory) {
        if (proxyFactory.canProxy(type) && !type.equals(Object.class)) {
            interfaces.add(type);
        }
    }

    public static Method getMatchingMethod(Class<?> type, String methodName, Object[] args) throws NoSuchMethodException {
        Object[] newArgs = args == null ? new Object[]{} : args;
        Method[] methods = type.getMethods();
        HashSet<Method> possibleMethods = new HashSet<Method>();
        Method method = null;
        for (int i = 0; method == null && i < methods.length; ++i) {
            Class<?>[] argTypes;
            if (!methodName.equals(methods[i].getName()) || (argTypes = methods[i].getParameterTypes()).length != newArgs.length) continue;
            boolean exact = true;
            Method possibleMethod = methods[i];
            for (int j = 0; possibleMethod != null && j < argTypes.length; ++j) {
                Class<Object> newArgType;
                Class clazz = newArgType = newArgs[j] != null ? newArgs[j].getClass() : Object.class;
                if (argTypes[j].equals(Byte.TYPE) && newArgType.equals(Byte.class) || argTypes[j].equals(Character.TYPE) && newArgType.equals(Character.class) || argTypes[j].equals(Short.TYPE) && newArgType.equals(Short.class) || argTypes[j].equals(Integer.TYPE) && newArgType.equals(Integer.class) || argTypes[j].equals(Long.TYPE) && newArgType.equals(Long.class) || argTypes[j].equals(Float.TYPE) && newArgType.equals(Float.class) || argTypes[j].equals(Double.TYPE) && newArgType.equals(Double.class) || argTypes[j].equals(Boolean.TYPE) && newArgType.equals(Boolean.class)) {
                    exact = true;
                    continue;
                }
                if (!argTypes[j].isAssignableFrom(newArgType)) {
                    possibleMethod = null;
                    exact = false;
                    continue;
                }
                if (argTypes[j].isPrimitive() || argTypes[j].equals(newArgType)) continue;
                exact = false;
            }
            if (exact) {
                method = possibleMethod;
                continue;
            }
            if (possibleMethod == null) continue;
            possibleMethods.add(possibleMethod);
        }
        if (method == null && possibleMethods.size() > 0) {
            method = (Method)possibleMethods.iterator().next();
        }
        if (method == null) {
            StringBuilder name = new StringBuilder(type.getName());
            name.append('.');
            name.append(methodName);
            name.append('(');
            for (int i = 0; i < newArgs.length; ++i) {
                if (i != 0) {
                    name.append(", ");
                }
                name.append(newArgs[i].getClass().getName());
            }
            name.append(')');
            throw new NoSuchMethodException(name.toString());
        }
        return method;
    }

    public static void writeMethod(ObjectOutputStream out, Method method) throws IOException {
        out.writeObject(method.getDeclaringClass());
        out.writeObject(method.getName());
        out.writeObject(method.getParameterTypes());
    }

    public static Method readMethod(ObjectInputStream in) throws IOException, ClassNotFoundException {
        Class type = (Class)Class.class.cast(in.readObject());
        String name = (String)String.class.cast(in.readObject());
        Class[] parameters = (Class[])Class[].class.cast(in.readObject());
        try {
            return type.getMethod(name, parameters);
        }
        catch (NoSuchMethodException e) {
            throw new InvalidObjectException(e.getMessage());
        }
    }

    public static Class<?>[] makeTypesArray(Class<?> primaryType, Class<?>[] types) {
        if (primaryType == null) {
            return types;
        }
        Class[] retVal = new Class[types == null ? 1 : types.length + 1];
        retVal[0] = primaryType;
        if (types != null) {
            System.arraycopy(types, 0, retVal, 1, types.length);
        }
        return retVal;
    }

    static {
        try {
            equals = Object.class.getMethod("equals", Object.class);
            hashCode = Object.class.getMethod("hashCode", new Class[0]);
            toString = Object.class.getMethod("toString", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new ExceptionInInitializerError(e.toString());
        }
    }
}

