/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.streams.processor.StreamPartitioner;
import org.apache.kafka.streams.processor.internals.DefaultStreamPartitioner;
import org.apache.kafka.streams.processor.internals.InternalTopologyBuilder;
import org.apache.kafka.streams.state.HostInfo;
import org.apache.kafka.streams.state.StreamsMetadata;

public class StreamsMetadataState {
    public static final HostInfo UNKNOWN_HOST = new HostInfo("unknown", -1);
    private final InternalTopologyBuilder builder;
    private final List<StreamsMetadata> allMetadata = new ArrayList<StreamsMetadata>();
    private final Set<String> globalStores;
    private final HostInfo thisHost;
    private Cluster clusterMetadata;
    private StreamsMetadata myMetadata;

    public StreamsMetadataState(InternalTopologyBuilder builder, HostInfo thisHost) {
        this.builder = builder;
        this.globalStores = builder.globalStateStores().keySet();
        this.thisHost = thisHost;
    }

    public String toString() {
        return this.toString("");
    }

    public String toString(String indent) {
        StringBuilder builder = new StringBuilder();
        builder.append(indent).append("GlobalMetadata: ").append(this.allMetadata).append("\n");
        builder.append(indent).append("GlobalStores: ").append(this.globalStores).append("\n");
        builder.append(indent).append("My HostInfo: ").append(this.thisHost).append("\n");
        builder.append(indent).append(this.clusterMetadata).append("\n");
        return builder.toString();
    }

    public synchronized Collection<StreamsMetadata> getAllMetadata() {
        return this.allMetadata;
    }

    public synchronized Collection<StreamsMetadata> getAllMetadataForStore(String storeName) {
        Objects.requireNonNull(storeName, "storeName cannot be null");
        if (!this.isInitialized()) {
            return Collections.emptyList();
        }
        if (this.globalStores.contains(storeName)) {
            return this.allMetadata;
        }
        List<String> sourceTopics = this.builder.stateStoreNameToSourceTopics().get(storeName);
        if (sourceTopics == null) {
            return Collections.emptyList();
        }
        ArrayList<StreamsMetadata> results = new ArrayList<StreamsMetadata>();
        for (StreamsMetadata metadata : this.allMetadata) {
            if (!metadata.stateStoreNames().contains(storeName)) continue;
            results.add(metadata);
        }
        return results;
    }

    public synchronized <K> StreamsMetadata getMetadataWithKey(String storeName, K key, Serializer<K> keySerializer) {
        Objects.requireNonNull(keySerializer, "keySerializer can't be null");
        Objects.requireNonNull(storeName, "storeName can't be null");
        Objects.requireNonNull(key, "key can't be null");
        if (!this.isInitialized()) {
            return StreamsMetadata.NOT_AVAILABLE;
        }
        if (this.globalStores.contains(storeName)) {
            if (this.thisHost == UNKNOWN_HOST) {
                return this.allMetadata.get(0);
            }
            return this.myMetadata;
        }
        SourceTopicsInfo sourceTopicsInfo = this.getSourceTopicsInfo(storeName);
        if (sourceTopicsInfo == null) {
            return null;
        }
        return this.getStreamsMetadataForKey(storeName, key, new DefaultStreamPartitioner(keySerializer, this.clusterMetadata), sourceTopicsInfo);
    }

    public synchronized <K> StreamsMetadata getMetadataWithKey(String storeName, K key, StreamPartitioner<? super K, ?> partitioner) {
        Objects.requireNonNull(storeName, "storeName can't be null");
        Objects.requireNonNull(key, "key can't be null");
        Objects.requireNonNull(partitioner, "partitioner can't be null");
        if (!this.isInitialized()) {
            return StreamsMetadata.NOT_AVAILABLE;
        }
        if (this.globalStores.contains(storeName)) {
            if (this.thisHost == UNKNOWN_HOST) {
                return this.allMetadata.get(0);
            }
            return this.myMetadata;
        }
        SourceTopicsInfo sourceTopicsInfo = this.getSourceTopicsInfo(storeName);
        if (sourceTopicsInfo == null) {
            return null;
        }
        return this.getStreamsMetadataForKey(storeName, key, partitioner, sourceTopicsInfo);
    }

    synchronized void onChange(Map<HostInfo, Set<TopicPartition>> currentState, Cluster clusterMetadata) {
        this.clusterMetadata = clusterMetadata;
        this.rebuildMetadata(currentState);
    }

    private boolean hasPartitionsForAnyTopics(List<String> topicNames, Set<TopicPartition> partitionForHost) {
        for (TopicPartition topicPartition : partitionForHost) {
            if (!topicNames.contains(topicPartition.topic())) continue;
            return true;
        }
        return false;
    }

    private void rebuildMetadata(Map<HostInfo, Set<TopicPartition>> currentState) {
        this.allMetadata.clear();
        if (currentState.isEmpty()) {
            return;
        }
        Map<String, List<String>> stores = this.builder.stateStoreNameToSourceTopics();
        for (Map.Entry<HostInfo, Set<TopicPartition>> entry : currentState.entrySet()) {
            HostInfo key = entry.getKey();
            HashSet<TopicPartition> partitionsForHost = new HashSet<TopicPartition>((Collection)entry.getValue());
            HashSet<String> storesOnHost = new HashSet<String>();
            for (Map.Entry<String, List<String>> storeTopicEntry : stores.entrySet()) {
                List<String> topicsForStore = storeTopicEntry.getValue();
                if (!this.hasPartitionsForAnyTopics(topicsForStore, partitionsForHost)) continue;
                storesOnHost.add(storeTopicEntry.getKey());
            }
            storesOnHost.addAll(this.globalStores);
            StreamsMetadata metadata = new StreamsMetadata(key, storesOnHost, partitionsForHost);
            this.allMetadata.add(metadata);
            if (!key.equals(this.thisHost)) continue;
            this.myMetadata = metadata;
        }
    }

    private <K> StreamsMetadata getStreamsMetadataForKey(String storeName, K key, StreamPartitioner<? super K, ?> partitioner, SourceTopicsInfo sourceTopicsInfo) {
        Integer partition = partitioner.partition(sourceTopicsInfo.topicWithMostPartitions, key, null, sourceTopicsInfo.maxPartitions);
        HashSet<TopicPartition> matchingPartitions = new HashSet<TopicPartition>();
        for (String sourceTopic : sourceTopicsInfo.sourceTopics) {
            matchingPartitions.add(new TopicPartition(sourceTopic, partition.intValue()));
        }
        for (StreamsMetadata streamsMetadata : this.allMetadata) {
            Set<String> stateStoreNames = streamsMetadata.stateStoreNames();
            HashSet<TopicPartition> topicPartitions = new HashSet<TopicPartition>(streamsMetadata.topicPartitions());
            topicPartitions.retainAll(matchingPartitions);
            if (!stateStoreNames.contains(storeName) || topicPartitions.isEmpty()) continue;
            return streamsMetadata;
        }
        return null;
    }

    private SourceTopicsInfo getSourceTopicsInfo(String storeName) {
        List<String> sourceTopics = this.builder.stateStoreNameToSourceTopics().get(storeName);
        if (sourceTopics == null || sourceTopics.isEmpty()) {
            return null;
        }
        return new SourceTopicsInfo(sourceTopics);
    }

    private boolean isInitialized() {
        return this.clusterMetadata != null && !this.clusterMetadata.topics().isEmpty();
    }

    private class SourceTopicsInfo {
        private final List<String> sourceTopics;
        private int maxPartitions;
        private String topicWithMostPartitions;

        private SourceTopicsInfo(List<String> sourceTopics) {
            this.sourceTopics = sourceTopics;
            for (String topic : sourceTopics) {
                List partitions = StreamsMetadataState.this.clusterMetadata.partitionsForTopic(topic);
                if (partitions.size() <= this.maxPartitions) continue;
                this.maxPartitions = partitions.size();
                this.topicWithMostPartitions = ((PartitionInfo)partitions.get(0)).topic();
            }
        }
    }
}

