/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import org.apache.kafka.common.header.Header;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.header.internals.RecordHeader;
import org.apache.kafka.common.header.internals.RecordHeaders;
import org.apache.kafka.streams.processor.RecordContext;

public class ProcessorRecordContext
implements RecordContext {
    private long timestamp;
    private final long offset;
    private final String topic;
    private final int partition;
    private final Headers headers;

    public ProcessorRecordContext(long timestamp, long offset, int partition, String topic, Headers headers) {
        this.timestamp = timestamp;
        this.offset = offset;
        this.topic = topic;
        this.partition = partition;
        this.headers = headers;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    @Override
    public long offset() {
        return this.offset;
    }

    @Override
    public long timestamp() {
        return this.timestamp;
    }

    @Override
    public String topic() {
        return this.topic;
    }

    @Override
    public int partition() {
        return this.partition;
    }

    @Override
    public Headers headers() {
        return this.headers;
    }

    public long sizeBytes() {
        long size = 0L;
        size += 8L;
        size += 8L;
        if (this.topic != null) {
            size += (long)this.topic.toCharArray().length;
        }
        size += 4L;
        if (this.headers != null) {
            for (Header header : this.headers) {
                size += (long)header.key().toCharArray().length;
                byte[] value = header.value();
                if (value == null) continue;
                size += (long)value.length;
            }
        }
        return size;
    }

    public byte[] serialize() {
        int i;
        Object headerKeysBytes;
        Object headerValuesBytes;
        byte[] topicBytes = this.topic.getBytes(StandardCharsets.UTF_8);
        int size = 0;
        size += 8;
        size += 8;
        size += 4;
        size += topicBytes.length;
        size += 4;
        size += 4;
        if (this.headers == null) {
            headerKeysBytes = headerValuesBytes = (byte[][])null;
        } else {
            Header[] headers = this.headers.toArray();
            headerKeysBytes = new byte[headers.length][];
            headerValuesBytes = new byte[headers.length][];
            for (i = 0; i < headers.length; ++i) {
                size += 8;
                byte[] keyBytes = headers[i].key().getBytes(StandardCharsets.UTF_8);
                size += keyBytes.length;
                byte[] valueBytes = headers[i].value();
                if (valueBytes != null) {
                    size += valueBytes.length;
                }
                headerKeysBytes[i] = keyBytes;
                headerValuesBytes[i] = valueBytes;
            }
        }
        ByteBuffer buffer = ByteBuffer.allocate(size);
        buffer.putLong(this.timestamp);
        buffer.putLong(this.offset);
        buffer.putInt(topicBytes.length);
        buffer.put(topicBytes);
        buffer.putInt(this.partition);
        if (this.headers == null) {
            buffer.putInt(-1);
        } else {
            buffer.putInt(((byte[][])headerKeysBytes).length);
            for (i = 0; i < ((byte[][])headerKeysBytes).length; ++i) {
                buffer.putInt(headerKeysBytes[i].length);
                buffer.put(headerKeysBytes[i]);
                if (headerValuesBytes[i] != null) {
                    buffer.putInt(headerValuesBytes[i].length);
                    buffer.put(headerValuesBytes[i]);
                    continue;
                }
                buffer.putInt(-1);
            }
        }
        return buffer.array();
    }

    public static ProcessorRecordContext deserialize(ByteBuffer buffer) {
        RecordHeaders headers;
        long timestamp = buffer.getLong();
        long offset = buffer.getLong();
        int topicSize = buffer.getInt();
        byte[] topicBytes = new byte[topicSize];
        buffer.get(topicBytes);
        String topic = new String(topicBytes, StandardCharsets.UTF_8);
        int partition = buffer.getInt();
        int headerCount = buffer.getInt();
        if (headerCount == -1) {
            headers = null;
        } else {
            Header[] headerArr = new Header[headerCount];
            for (int i = 0; i < headerCount; ++i) {
                byte[] valueBytes;
                int keySize = buffer.getInt();
                byte[] keyBytes = new byte[keySize];
                buffer.get(keyBytes);
                int valueSize = buffer.getInt();
                if (valueSize == -1) {
                    valueBytes = null;
                } else {
                    valueBytes = new byte[valueSize];
                    buffer.get(valueBytes);
                }
                headerArr[i] = new RecordHeader(new String(keyBytes, StandardCharsets.UTF_8), valueBytes);
            }
            headers = new RecordHeaders(headerArr);
        }
        return new ProcessorRecordContext(timestamp, offset, partition, topic, (Headers)headers);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProcessorRecordContext that = (ProcessorRecordContext)o;
        return this.timestamp == that.timestamp && this.offset == that.offset && this.partition == that.partition && Objects.equals(this.topic, that.topic) && Objects.equals(this.headers, that.headers);
    }

    @Deprecated
    public int hashCode() {
        throw new UnsupportedOperationException("ProcessorRecordContext is unsafe for use in Hash collections");
    }

    public String toString() {
        return "ProcessorRecordContext{topic='" + this.topic + '\'' + ", partition=" + this.partition + ", offset=" + this.offset + ", timestamp=" + this.timestamp + ", headers=" + this.headers + '}';
    }
}

