/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals;

import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.streams.processor.internals.ProcessorNode;
import org.apache.kafka.streams.processor.internals.RecordQueue;
import org.apache.kafka.streams.processor.internals.StampedRecord;

public class PartitionGroup {
    private final Map<TopicPartition, RecordQueue> partitionQueues;
    private final Sensor recordLatenessSensor;
    private final PriorityQueue<RecordQueue> nonEmptyQueuesByTime;
    private long streamTime;
    private int totalBuffered;
    private boolean allBuffered;

    PartitionGroup(Map<TopicPartition, RecordQueue> partitionQueues, Sensor recordLatenessSensor) {
        this.nonEmptyQueuesByTime = new PriorityQueue<RecordQueue>(partitionQueues.size(), Comparator.comparingLong(RecordQueue::timestamp));
        this.partitionQueues = partitionQueues;
        this.recordLatenessSensor = recordLatenessSensor;
        this.totalBuffered = 0;
        this.allBuffered = false;
        this.streamTime = -1L;
    }

    StampedRecord nextRecord(RecordInfo info) {
        RecordQueue queue;
        StampedRecord record = null;
        info.queue = queue = this.nonEmptyQueuesByTime.poll();
        if (queue != null && (record = queue.poll()) != null) {
            --this.totalBuffered;
            if (queue.isEmpty()) {
                this.allBuffered = false;
            } else {
                this.nonEmptyQueuesByTime.offer(queue);
            }
            if (record.timestamp > this.streamTime) {
                this.streamTime = record.timestamp;
                this.recordLatenessSensor.record(0.0);
            } else {
                this.recordLatenessSensor.record((double)(this.streamTime - record.timestamp));
            }
        }
        return record;
    }

    int addRawRecords(TopicPartition partition, Iterable<ConsumerRecord<byte[], byte[]>> rawRecords) {
        RecordQueue recordQueue = this.partitionQueues.get(partition);
        int oldSize = recordQueue.size();
        int newSize = recordQueue.addRawRecords(rawRecords);
        if (oldSize == 0 && newSize > 0) {
            this.nonEmptyQueuesByTime.offer(recordQueue);
            if (this.nonEmptyQueuesByTime.size() == this.partitionQueues.size()) {
                this.allBuffered = true;
            }
        }
        this.totalBuffered += newSize - oldSize;
        return newSize;
    }

    public Set<TopicPartition> partitions() {
        return Collections.unmodifiableSet(this.partitionQueues.keySet());
    }

    public long timestamp() {
        return this.streamTime;
    }

    int numBuffered(TopicPartition partition) {
        RecordQueue recordQueue = this.partitionQueues.get(partition);
        if (recordQueue == null) {
            throw new IllegalStateException(String.format("Record's partition %s does not belong to this partition-group.", partition));
        }
        return recordQueue.size();
    }

    int numBuffered() {
        return this.totalBuffered;
    }

    boolean allPartitionsBuffered() {
        return this.allBuffered;
    }

    public void close() {
        this.clear();
        this.partitionQueues.clear();
    }

    public void clear() {
        this.nonEmptyQueuesByTime.clear();
        for (RecordQueue queue : this.partitionQueues.values()) {
            queue.clear();
        }
    }

    public static class RecordInfo {
        RecordQueue queue;

        public ProcessorNode node() {
            return this.queue.source();
        }

        public TopicPartition partition() {
            return this.queue.partition();
        }

        RecordQueue queue() {
            return this.queue;
        }
    }
}

