/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.utils;

import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import com.mongodb.DBRef;
import dev.morphia.Key;
import dev.morphia.annotations.Embedded;
import dev.morphia.annotations.Entity;
import dev.morphia.mapping.MappingException;
import io.github.classgraph.ClassGraph;
import io.github.classgraph.ClassInfo;
import io.github.classgraph.ScanResult;
import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Pattern;
import org.bson.types.CodeWScope;
import org.bson.types.ObjectId;

public final class ReflectionUtils {
    private ReflectionUtils() {
    }

    public static Field[] getDeclaredAndInheritedFields(Class type, boolean returnFinalFields) {
        ArrayList<Field> allFields = new ArrayList<Field>();
        allFields.addAll(ReflectionUtils.getValidFields(type.getDeclaredFields(), returnFinalFields));
        for (Class parent = type.getSuperclass(); parent != null && parent != Object.class; parent = parent.getSuperclass()) {
            allFields.addAll(ReflectionUtils.getValidFields(parent.getDeclaredFields(), returnFinalFields));
        }
        return allFields.toArray(new Field[allFields.size()]);
    }

    public static List<Field> getValidFields(Field[] fields, boolean returnFinalFields) {
        ArrayList<Field> validFields = new ArrayList<Field>();
        for (Field field : fields) {
            if (Modifier.isStatic(field.getModifiers()) || !returnFinalFields && Modifier.isFinal(field.getModifiers())) continue;
            validFields.add(field);
        }
        return validFields;
    }

    public static List<Method> getDeclaredAndInheritedMethods(Class type) {
        return ReflectionUtils.getDeclaredAndInheritedMethods(type, new ArrayList<Method>());
    }

    private static List<Method> getDeclaredAndInheritedMethods(Class type, List<Method> methods) {
        if (type == null || type == Object.class) {
            return methods;
        }
        Class parent = type.getSuperclass();
        List<Method> list = ReflectionUtils.getDeclaredAndInheritedMethods(parent, methods == null ? new ArrayList() : methods);
        for (Method m : type.getDeclaredMethods()) {
            if (Modifier.isStatic(m.getModifiers())) continue;
            list.add(m);
        }
        return list;
    }

    public static boolean isIntegerType(Class type) {
        return Arrays.asList(Integer.class, Integer.TYPE, Long.class, Long.TYPE, Short.class, Short.TYPE, Byte.class, Byte.TYPE).contains(type);
    }

    public static boolean isPropertyType(Type type) {
        if (type instanceof GenericArrayType) {
            return ReflectionUtils.isPropertyType(((GenericArrayType)type).getGenericComponentType());
        }
        if (type instanceof ParameterizedType) {
            return ReflectionUtils.isPropertyType(((ParameterizedType)type).getRawType());
        }
        return type instanceof Class && ReflectionUtils.isPropertyType((Class)type);
    }

    public static Class getParameterizedClass(Field field) {
        return ReflectionUtils.getParameterizedClass(field, 0);
    }

    public static Class getParameterizedClass(Field field, int index) {
        if (field.getGenericType() instanceof ParameterizedType) {
            ParameterizedType type = (ParameterizedType)field.getGenericType();
            if (type.getActualTypeArguments() != null && type.getActualTypeArguments().length <= index) {
                return null;
            }
            Type paramType = type.getActualTypeArguments()[index];
            if (paramType instanceof GenericArrayType) {
                Class arrayType = (Class)((GenericArrayType)paramType).getGenericComponentType();
                return Array.newInstance(arrayType, 0).getClass();
            }
            if (paramType instanceof ParameterizedType) {
                ParameterizedType paramPType = (ParameterizedType)paramType;
                return (Class)paramPType.getRawType();
            }
            if (paramType instanceof TypeVariable) {
                throw new MappingException("Generic Typed Class not supported:  <" + ((TypeVariable)paramType).getName() + "> = " + ((TypeVariable)paramType).getBounds()[0]);
            }
            if (paramType instanceof Class) {
                return (Class)paramType;
            }
            throw new MappingException("Unknown type... pretty bad... call for help, wave your hands... yeah!");
        }
        return ReflectionUtils.getParameterizedClass(field.getType(), index);
    }

    public static Type getParameterizedType(Field field, int index) {
        if (field != null) {
            if (field.getGenericType() instanceof ParameterizedType) {
                ParameterizedType type = (ParameterizedType)field.getGenericType();
                if (type.getActualTypeArguments() != null && type.getActualTypeArguments().length <= index) {
                    return null;
                }
                Type paramType = type.getActualTypeArguments()[index];
                if (paramType instanceof GenericArrayType) {
                    return paramType;
                }
                if (paramType instanceof ParameterizedType) {
                    return paramType;
                }
                if (paramType instanceof TypeVariable) {
                    return paramType;
                }
                if (paramType instanceof WildcardType) {
                    return paramType;
                }
                if (paramType instanceof Class) {
                    return paramType;
                }
                throw new MappingException("Unknown type... pretty bad... call for help, wave your hands... yeah!");
            }
            return ReflectionUtils.getParameterizedClass(field.getType(), index);
        }
        return null;
    }

    public static Class getParameterizedClass(Class c) {
        return ReflectionUtils.getParameterizedClass(c, 0);
    }

    public static Class getParameterizedClass(Class c, int index) {
        Type[] interfaces;
        TypeVariable<Class<T>>[] typeVars = c.getTypeParameters();
        if (typeVars.length > 0) {
            TypeVariable typeVariable = typeVars[index];
            Type[] bounds = typeVariable.getBounds();
            Type type = bounds[0];
            if (type instanceof Class) {
                return (Class)type;
            }
            return null;
        }
        Type superclass = c.getGenericSuperclass();
        if (superclass == null && c.isInterface() && (interfaces = c.getGenericInterfaces()).length > 0) {
            superclass = interfaces[index];
        }
        if (superclass instanceof ParameterizedType) {
            Type[] actualTypeArguments = ((ParameterizedType)superclass).getActualTypeArguments();
            return actualTypeArguments.length > index ? (Class)actualTypeArguments[index] : null;
        }
        if (!Object.class.equals((Object)superclass)) {
            return ReflectionUtils.getParameterizedClass((Class)superclass, index);
        }
        return null;
    }

    public static boolean isFieldParameterizedWithClass(Field field, Class c) {
        if (field.getGenericType() instanceof ParameterizedType) {
            ParameterizedType genericType = (ParameterizedType)field.getGenericType();
            for (Type type : genericType.getActualTypeArguments()) {
                if (type == c) {
                    return true;
                }
                if (!c.isInterface() || !ReflectionUtils.implementsInterface((Class)type, c)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean implementsInterface(Class<?> type, Class<?> interfaceClass) {
        return interfaceClass.isAssignableFrom(type);
    }

    public static boolean isFieldParameterizedWithPropertyType(Field field) {
        if (field.getGenericType() instanceof ParameterizedType) {
            ParameterizedType genericType = (ParameterizedType)field.getGenericType();
            for (Type type : genericType.getActualTypeArguments()) {
                if (!ReflectionUtils.isPropertyType((Class)type)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isPropertyType(Class type) {
        return type != null && (ReflectionUtils.isPrimitiveLike(type) || type == DBRef.class || type == Pattern.class || type == CodeWScope.class || type == ObjectId.class || type == Key.class || type == DBObject.class || type == BasicDBObject.class);
    }

    public static boolean isPrimitiveLike(Class type) {
        return type != null && (type == String.class || type == Character.TYPE || type == Character.class || type == Short.TYPE || type == Short.class || type == Integer.class || type == Integer.TYPE || type == Long.class || type == Long.TYPE || type == Double.class || type == Double.TYPE || type == Float.TYPE || type == Float.class || type == Boolean.class || type == Boolean.TYPE || type == Byte.class || type == Byte.TYPE || type == Date.class || type == Locale.class || type == Class.class || type == UUID.class || type == URI.class || type.isEnum());
    }

    public static Embedded getClassEmbeddedAnnotation(Class c) {
        return ReflectionUtils.getAnnotation(c, Embedded.class);
    }

    public static <T> T getAnnotation(Class c, Class<T> annotation) {
        List<T> found = ReflectionUtils.getAnnotations(c, annotation);
        if (found != null && !found.isEmpty()) {
            return found.get(0);
        }
        return null;
    }

    public static <T> List<T> getAnnotations(Class c, Class<T> annotation) {
        ArrayList<T> found = new ArrayList<T>();
        if (c.isAnnotationPresent(annotation)) {
            found.add(c.getAnnotation(annotation));
        }
        for (Class parent = c.getSuperclass(); parent != null && parent != Object.class; parent = parent.getSuperclass()) {
            if (parent.isAnnotationPresent(annotation)) {
                found.add(parent.getAnnotation(annotation));
            }
            for (Class<?> interfaceClass : parent.getInterfaces()) {
                if (!interfaceClass.isAnnotationPresent(annotation)) continue;
                found.add(interfaceClass.getAnnotation(annotation));
            }
        }
        for (Class<?> interfaceClass : c.getInterfaces()) {
            if (!interfaceClass.isAnnotationPresent(annotation)) continue;
            found.add(interfaceClass.getAnnotation(annotation));
        }
        return found;
    }

    public static Entity getClassEntityAnnotation(Class c) {
        return ReflectionUtils.getAnnotation(c, Entity.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<Class<?>> getClasses(ClassLoader loader, String packageName, boolean mapSubPackages) throws IOException, ClassNotFoundException {
        HashSet classes = new HashSet();
        ClassGraph classGraph = new ClassGraph().addClassLoader(loader).enableAllInfo();
        if (mapSubPackages) {
            classGraph.whitelistPackages(new String[]{packageName});
            classGraph.whitelistPackages(new String[]{packageName + ".*"});
        } else {
            classGraph.whitelistPackagesNonRecursive(new String[]{packageName});
        }
        try (ScanResult scanResult = classGraph.scan();){
            Iterator iterator = scanResult.getAllClasses().iterator();
            while (iterator.hasNext()) {
                classes.add(Class.forName(((ClassInfo)iterator.next()).getName(), true, loader));
            }
        }
        return classes;
    }

    public static <T> List<T> iterToList(Iterable<T> it) {
        if (it instanceof List) {
            return (List)it;
        }
        if (it == null) {
            return null;
        }
        ArrayList<T> ar = new ArrayList<T>();
        for (T o : it) {
            ar.add(o);
        }
        return ar;
    }

    public static Object convertToArray(Class type, List<?> values) {
        Object exampleArray = Array.newInstance(type, values.size());
        try {
            return values.toArray((Object[])exampleArray);
        }
        catch (ClassCastException e) {
            for (int i = 0; i < values.size(); ++i) {
                Array.set(exampleArray, i, values.get(i));
            }
            return exampleArray;
        }
    }

    public static Class<?> getClass(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return ReflectionUtils.getClass(((ParameterizedType)type).getRawType());
        }
        if (type instanceof GenericArrayType) {
            Type componentType = ((GenericArrayType)type).getGenericComponentType();
            Class<?> componentClass = ReflectionUtils.getClass(componentType);
            if (componentClass != null) {
                return Array.newInstance(componentClass, 0).getClass();
            }
            return null;
        }
        return null;
    }

    public static <T> List<Class<?>> getTypeArguments(Class<T> baseClass, Class<? extends T> childClass) {
        HashMap resolvedTypes = new HashMap();
        Type type = childClass;
        while (!ReflectionUtils.getClass(type).equals(baseClass)) {
            if (type instanceof Class) {
                type = type.getGenericSuperclass();
                continue;
            }
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Class rawType = (Class)parameterizedType.getRawType();
            Type[] actualTypeArguments = parameterizedType.getActualTypeArguments();
            TypeVariable<Class<T>>[] typeParameters = rawType.getTypeParameters();
            for (int i = 0; i < actualTypeArguments.length; ++i) {
                resolvedTypes.put(typeParameters[i], actualTypeArguments[i]);
            }
            if (rawType.equals(baseClass)) continue;
            type = rawType.getGenericSuperclass();
        }
        Type[] actualTypeArguments = type instanceof Class ? type.getTypeParameters() : ((ParameterizedType)type).getActualTypeArguments();
        ArrayList typeArgumentsAsClasses = new ArrayList();
        for (Type baseType : actualTypeArguments) {
            while (resolvedTypes.containsKey(baseType)) {
                baseType = (Type)resolvedTypes.get(baseType);
            }
            typeArgumentsAsClasses.add(ReflectionUtils.getClass(baseType));
        }
        return typeArgumentsAsClasses;
    }

    public static <T> Class<?> getTypeArgument(Class<? extends T> clazz, TypeVariable<? extends GenericDeclaration> tv) {
        HashMap resolvedTypes = new HashMap();
        Type type = clazz;
        while (type != null && !Object.class.equals(ReflectionUtils.getClass(type))) {
            if (type instanceof Class) {
                type = type.getGenericSuperclass();
                continue;
            }
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Class rawType = (Class)parameterizedType.getRawType();
            Type[] actualTypeArguments = parameterizedType.getActualTypeArguments();
            TypeVariable<Class<T>>[] typeParameters = rawType.getTypeParameters();
            for (int i = 0; i < actualTypeArguments.length; ++i) {
                if (typeParameters[i].equals(tv)) {
                    Class<?> cls = ReflectionUtils.getClass(actualTypeArguments[i]);
                    if (cls != null) {
                        return cls;
                    }
                    Type typeToTest = (Type)resolvedTypes.get(actualTypeArguments[i]);
                    while (typeToTest != null) {
                        Class<?> classToTest = ReflectionUtils.getClass(typeToTest);
                        if (classToTest != null) {
                            return classToTest;
                        }
                        typeToTest = (Type)resolvedTypes.get(typeToTest);
                    }
                }
                resolvedTypes.put(typeParameters[i], actualTypeArguments[i]);
            }
            if (rawType.equals(Object.class)) continue;
            type = rawType.getGenericSuperclass();
        }
        return null;
    }
}

