/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.query.validation;

import dev.morphia.mapping.MappedField;
import dev.morphia.query.FilterOperator;
import dev.morphia.query.validation.CollectionTypeValidator;
import dev.morphia.query.validation.OperationValidator;
import dev.morphia.query.validation.ValidationFailure;
import dev.morphia.query.validation.ValueClassValidator;
import java.util.List;

public final class SizeOperationValidator
extends OperationValidator {
    private static final SizeOperationValidator INSTANCE = new SizeOperationValidator();

    private SizeOperationValidator() {
    }

    public static SizeOperationValidator getInstance() {
        return INSTANCE;
    }

    @Override
    protected FilterOperator getOperator() {
        return FilterOperator.SIZE;
    }

    @Override
    protected void validate(MappedField mappedField, Object value, List<ValidationFailure> validationFailures) {
        if (!ValueClassValidator.valueIsClassOrSubclassOf(value, Number.class)) {
            validationFailures.add(new ValidationFailure(String.format("For a $size operation, value '%s' should be an integer type.  Instead it was a: %s", value, value.getClass())));
        }
        if (!CollectionTypeValidator.typeIsIterableOrArrayOrMap(mappedField.getType())) {
            validationFailures.add(new ValidationFailure(String.format("For a $size operation, field '%s' should be a List or array.  Instead it was a: %s", mappedField, mappedField.getType())));
        }
    }
}

