/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.query.validation;

import dev.morphia.mapping.MappedField;
import dev.morphia.query.FilterOperator;
import dev.morphia.query.validation.OperationValidator;
import dev.morphia.query.validation.ValidationFailure;
import java.util.List;

public final class ExistsOperationValidator
extends OperationValidator {
    private static final ExistsOperationValidator INSTANCE = new ExistsOperationValidator();

    private ExistsOperationValidator() {
    }

    public static ExistsOperationValidator getInstance() {
        return INSTANCE;
    }

    @Override
    protected FilterOperator getOperator() {
        return FilterOperator.EXISTS;
    }

    @Override
    protected void validate(MappedField mappedField, Object value, List<ValidationFailure> validationFailures) {
        if (value.getClass() != Boolean.class) {
            validationFailures.add(new ValidationFailure(String.format("For an $exists operation, value '%s' should be a boolean type.  Instead it was a: %s", value, value.getClass())));
        }
    }
}

