/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.query.validation;

import dev.morphia.mapping.MappedClass;
import dev.morphia.mapping.MappedField;
import dev.morphia.query.validation.ValidationFailure;
import dev.morphia.query.validation.Validator;
import java.util.List;

public final class EntityTypeAndIdValueValidator
implements Validator {
    private static final EntityTypeAndIdValueValidator INSTANCE = new EntityTypeAndIdValueValidator();

    private EntityTypeAndIdValueValidator() {
    }

    public static EntityTypeAndIdValueValidator getInstance() {
        return INSTANCE;
    }

    public boolean apply(MappedClass mappedClass, MappedField mappedField, Object value, List<ValidationFailure> validationFailures) {
        if (this.appliesTo(mappedClass, mappedField)) {
            Class<?> classOfValue = value.getClass();
            Class classOfIdFieldForType = mappedClass.getMappedIdField().getConcreteType();
            if (!mappedField.getType().equals(classOfValue) && !classOfValue.equals(classOfIdFieldForType)) {
                validationFailures.add(new ValidationFailure(String.format("The value class needs to match the type of ID for the field. Value was %s and was a %s and the ID of the type was %s", value, classOfValue, classOfIdFieldForType)));
            }
            return true;
        }
        return false;
    }

    private boolean appliesTo(MappedClass mappedClass, MappedField mappedField) {
        return mappedField != null && mappedField.equals(mappedClass.getMappedIdField());
    }
}

