/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.query.validation;

import dev.morphia.query.validation.TypeValidator;
import dev.morphia.query.validation.ValidationFailure;
import java.util.List;

public final class DefaultTypeValidator
extends TypeValidator {
    private static final DefaultTypeValidator INSTANCE = new DefaultTypeValidator();

    private DefaultTypeValidator() {
    }

    public static DefaultTypeValidator getInstance() {
        return INSTANCE;
    }

    @Override
    protected boolean appliesTo(Class<?> type) {
        return true;
    }

    @Override
    protected void validate(Class<?> type, Object value, List<ValidationFailure> validationFailures) {
        if (!type.isAssignableFrom(value.getClass()) && !value.getClass().getSimpleName().equalsIgnoreCase(type.getSimpleName())) {
            validationFailures.add(new ValidationFailure(String.format("Type %s may not be queryable with value '%s' with class %s", type.getCanonicalName(), value, value.getClass().getCanonicalName())));
        }
    }
}

