/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.query.internal;

import com.mongodb.Cursor;
import com.mongodb.DBObject;
import com.mongodb.ServerAddress;
import com.mongodb.ServerCursor;
import com.mongodb.client.MongoCursor;
import dev.morphia.Datastore;
import dev.morphia.mapping.Mapper;
import dev.morphia.mapping.cache.EntityCache;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;

public class MorphiaCursor<T>
implements MongoCursor<T> {
    private final Cursor wrapped;
    private final Mapper mapper;
    private final Class<T> clazz;
    private final EntityCache cache;
    private final Datastore datastore;

    public MorphiaCursor(Datastore datastore, Cursor cursor, Mapper mapper, Class<T> clazz, EntityCache cache) {
        this.wrapped = cursor;
        if (this.wrapped == null) {
            throw new IllegalArgumentException("The wrapped cursor can not be null");
        }
        this.mapper = mapper;
        this.clazz = clazz;
        this.cache = cache;
        this.datastore = datastore;
    }

    public List<T> toList() {
        ArrayList<T> results = new ArrayList<T>();
        try {
            while (this.wrapped.hasNext()) {
                results.add(this.next());
            }
        }
        finally {
            this.wrapped.close();
        }
        return results;
    }

    public void close() {
        if (this.wrapped != null) {
            this.wrapped.close();
        }
    }

    public boolean hasNext() {
        if (this.wrapped == null) {
            return false;
        }
        return this.wrapped.hasNext();
    }

    public T next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.mapper.fromDBObject(this.datastore, this.clazz, (DBObject)this.wrapped.next(), this.cache);
    }

    public T tryNext() {
        if (this.hasNext()) {
            return this.next();
        }
        return null;
    }

    public ServerCursor getServerCursor() {
        return new ServerCursor(this.wrapped.getCursorId(), this.wrapped.getServerAddress());
    }

    public ServerAddress getServerAddress() {
        return this.wrapped.getServerAddress();
    }

    public void remove() {
        this.wrapped.remove();
    }

    protected DBObject getNext() {
        return (DBObject)this.wrapped.next();
    }
}

