/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.query.internal;

import com.mongodb.Function;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.MongoIterable;
import com.mongodb.lang.Nullable;
import dev.morphia.query.internal.MongoMappingCursor;
import java.util.Collection;
import java.util.function.Consumer;

public class MappingIterable<U, V>
implements MongoIterable<V> {
    private final MongoIterable<U> iterable;
    private final Function<U, V> mapper;

    public MappingIterable(MongoIterable<U> iterable, Function<U, V> mapper) {
        this.iterable = iterable;
        this.mapper = mapper;
    }

    public MongoCursor<V> iterator() {
        return new MongoMappingCursor<U, V>(this.iterable.iterator(), this.mapper);
    }

    public MongoCursor<V> cursor() {
        return new MongoMappingCursor<U, V>(this.iterable.iterator(), this.mapper);
    }

    @Nullable
    public V first() {
        Object first = this.iterable.first();
        if (first == null) {
            return null;
        }
        return (V)this.mapper.apply(first);
    }

    public void forEach(Consumer<? super V> block) {
        this.iterable.forEach(document -> block.accept((V)this.mapper.apply(document)));
    }

    public <A extends Collection<? super V>> A into(A target) {
        this.forEach(v -> target.add(v));
        return target;
    }

    public MappingIterable<U, V> batchSize(int batchSize) {
        this.iterable.batchSize(batchSize);
        return this;
    }

    public <W> MongoIterable<W> map(Function<V, W> newMap) {
        return new MappingIterable<V, W>(this, newMap);
    }

    MongoIterable<U> getMapped() {
        return this.iterable;
    }
}

