/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.query;

import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;

public class Shape {
    private final String geometry;
    private final Point[] points;

    Shape(String geometry, Point ... points) {
        this.geometry = geometry;
        this.points = points;
    }

    public static Shape box(Point bottomLeft, Point upperRight) {
        return new Shape("$box", bottomLeft, upperRight);
    }

    public static Shape center(Point center, double radius) {
        return new Center("$center", center, radius);
    }

    public static Shape centerSphere(Point center, double radius) {
        return new Center("$centerSphere", center, radius);
    }

    public static Shape polygon(Point ... points) {
        return new Shape("$polygon", points);
    }

    public String getGeometry() {
        return this.geometry;
    }

    public Point[] getPoints() {
        return this.copy(this.points);
    }

    public DBObject toDBObject() {
        BasicDBList list = new BasicDBList();
        for (Point point : this.points) {
            list.add((Object)point.toDBObject());
        }
        return new BasicDBObject(this.geometry, (Object)list);
    }

    private Point[] copy(Point[] array) {
        Point[] copy = new Point[array.length];
        System.arraycopy(array, 0, copy, 0, array.length);
        return copy;
    }

    private static class Center
    extends Shape {
        private final Point center;
        private final double radius;

        Center(String geometry, Point center, double radius) {
            super(geometry, new Point[0]);
            this.center = center;
            this.radius = radius;
        }

        @Override
        public DBObject toDBObject() {
            BasicDBList list = new BasicDBList();
            list.add((Object)this.center.toDBObject());
            list.add((Object)this.radius);
            return new BasicDBObject(this.getGeometry(), (Object)list);
        }
    }

    public static class Point {
        private final double longitude;
        private final double latitude;

        public Point(double longitude, double latitude) {
            this.latitude = latitude;
            this.longitude = longitude;
        }

        public DBObject toDBObject() {
            BasicDBList list = new BasicDBList();
            list.add((Object)this.longitude);
            list.add((Object)this.latitude);
            return list;
        }
    }
}

