/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.query;

import com.mongodb.BasicDBObject;
import com.mongodb.CursorType;
import com.mongodb.DBObject;
import com.mongodb.ReadConcern;
import com.mongodb.ReadPreference;
import com.mongodb.client.model.Collation;
import com.mongodb.client.model.DBCollectionFindOptions;
import com.mongodb.lang.Nullable;
import java.util.concurrent.TimeUnit;

public class FindOptions {
    private DBCollectionFindOptions options = new DBCollectionFindOptions();

    public FindOptions() {
    }

    private FindOptions(DBCollectionFindOptions copy) {
        this.options = copy.copy();
    }

    public FindOptions batchSize(int batchSize) {
        this.options.batchSize(batchSize);
        return this;
    }

    public FindOptions collation(Collation collation) {
        this.options.collation(collation);
        return this;
    }

    public FindOptions comment(String comment) {
        this.options.comment(comment);
        return this;
    }

    public FindOptions copy() {
        return new FindOptions(this.options.copy());
    }

    public FindOptions cursorType(CursorType cursorType) {
        this.options.cursorType(cursorType);
        return this;
    }

    public int getBatchSize() {
        return this.options.getBatchSize();
    }

    public Collation getCollation() {
        return this.options.getCollation();
    }

    @Nullable
    public String getComment() {
        return this.options.getComment();
    }

    public CursorType getCursorType() {
        return this.options.getCursorType();
    }

    @Nullable
    public DBObject getHint() {
        return this.options.getHint();
    }

    public int getLimit() {
        return this.options.getLimit();
    }

    @Nullable
    public DBObject getMax() {
        return this.options.getMax();
    }

    public long getMaxAwaitTime(TimeUnit timeUnit) {
        return this.options.getMaxAwaitTime(timeUnit);
    }

    public long getMaxTime(TimeUnit timeUnit) {
        return this.options.getMaxTime(timeUnit);
    }

    @Nullable
    public DBObject getMin() {
        return this.options.getMin();
    }

    public ReadConcern getReadConcern() {
        return this.options.getReadConcern();
    }

    public ReadPreference getReadPreference() {
        return this.options.getReadPreference();
    }

    public int getSkip() {
        return this.options.getSkip();
    }

    @Nullable
    public DBObject getSort() {
        return this.options.getSort();
    }

    public FindOptions hint(DBObject hint) {
        this.options.hint(hint);
        return this;
    }

    public FindOptions hintString(String hint) {
        this.options.hint((DBObject)new BasicDBObject(hint, (Object)1));
        return this;
    }

    public boolean isNoCursorTimeout() {
        return this.options.isNoCursorTimeout();
    }

    public boolean isOplogReplay() {
        return this.options.isOplogReplay();
    }

    public boolean isPartial() {
        return this.options.isPartial();
    }

    public boolean isReturnKey() {
        return this.options.isReturnKey();
    }

    public boolean isShowRecordId() {
        return this.options.isShowRecordId();
    }

    public FindOptions limit(int limit) {
        this.options.limit(limit);
        return this;
    }

    public FindOptions max(DBObject max) {
        this.options.max(max);
        return this;
    }

    public FindOptions maxAwaitTime(long maxAwaitTime, TimeUnit timeUnit) {
        this.options.maxAwaitTime(maxAwaitTime, timeUnit);
        return this;
    }

    public FindOptions maxTime(long maxTime, TimeUnit timeUnit) {
        this.options.maxTime(maxTime, timeUnit);
        return this;
    }

    public FindOptions min(DBObject min) {
        this.options.min(min);
        return this;
    }

    public FindOptions noCursorTimeout(boolean noCursorTimeout) {
        this.options.noCursorTimeout(noCursorTimeout);
        return this;
    }

    public FindOptions oplogReplay(boolean oplogReplay) {
        this.options.oplogReplay(oplogReplay);
        return this;
    }

    public FindOptions partial(boolean partial) {
        this.options.partial(partial);
        return this;
    }

    public FindOptions readConcern(ReadConcern readConcern) {
        this.options.readConcern(readConcern);
        return this;
    }

    public FindOptions readPreference(ReadPreference readPreference) {
        this.options.readPreference(readPreference);
        return this;
    }

    public FindOptions returnKey(boolean returnKey) {
        this.options.returnKey(returnKey);
        return this;
    }

    public FindOptions showRecordId(boolean showRecordId) {
        this.options.showRecordId(showRecordId);
        return this;
    }

    public FindOptions skip(int skip) {
        this.options.skip(skip);
        return this;
    }

    DBCollectionFindOptions getOptions() {
        return this.options;
    }

    DBObject getProjection() {
        return this.options.getProjection();
    }

    DBObject getSortDBObject() {
        return this.options.getSort();
    }

    FindOptions projection(DBObject projection) {
        this.options.projection(projection);
        return this;
    }

    FindOptions sort(DBObject sort) {
        this.options.sort(sort);
        return this;
    }
}

