/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.query;

import dev.morphia.geo.CoordinateReferenceSystem;
import dev.morphia.geo.Geometry;
import dev.morphia.geo.MultiPolygon;
import dev.morphia.geo.Point;
import dev.morphia.geo.Polygon;
import dev.morphia.query.CriteriaContainer;
import dev.morphia.query.FieldCriteria;
import dev.morphia.query.FieldEnd;
import dev.morphia.query.FilterOperator;
import dev.morphia.query.Geo2dCriteria;
import dev.morphia.query.Geo2dSphereCriteria;
import dev.morphia.query.Query;
import dev.morphia.query.QueryException;
import dev.morphia.query.QueryImpl;
import dev.morphia.query.Shape;
import dev.morphia.query.Type;
import dev.morphia.utils.Assert;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FieldEndImpl<T extends CriteriaContainer>
implements FieldEnd<T> {
    private static final Logger LOG = LoggerFactory.getLogger(FieldEndImpl.class);
    private final QueryImpl<?> query;
    private final String field;
    private final T target;
    private boolean not;

    public FieldEndImpl(QueryImpl<?> query, String field, T target) {
        this.query = query;
        this.field = field;
        this.target = target;
    }

    @Override
    public T contains(String string) {
        Assert.parametersNotNull("val", string);
        return this.addCriteria(FilterOperator.EQUAL, Pattern.compile(Pattern.quote(string)));
    }

    @Override
    public T containsIgnoreCase(String string) {
        Assert.parametersNotNull("val", string);
        return this.addCriteria(FilterOperator.EQUAL, Pattern.compile(Pattern.quote(string), 2));
    }

    @Override
    public T doesNotExist() {
        return this.addCriteria(FilterOperator.EXISTS, false);
    }

    @Override
    public T endsWith(String suffix) {
        Assert.parametersNotNull("val", suffix);
        return this.addCriteria(FilterOperator.EQUAL, Pattern.compile(Pattern.quote(suffix) + "$"));
    }

    @Override
    public T endsWithIgnoreCase(String suffix) {
        Assert.parametersNotNull("val", suffix);
        return this.addCriteria(FilterOperator.EQUAL, Pattern.compile(Pattern.quote(suffix) + "$", 2));
    }

    @Override
    public T equal(Object val) {
        return this.addCriteria(FilterOperator.EQUAL, val);
    }

    @Override
    public T equalIgnoreCase(Object val) {
        Assert.parametersNotNull("val", val);
        return this.addCriteria(FilterOperator.EQUAL, Pattern.compile("^" + Pattern.quote(val.toString()) + "$", 2));
    }

    @Override
    public T exists() {
        return this.addCriteria(FilterOperator.EXISTS, true);
    }

    @Override
    public T greaterThan(Object val) {
        Assert.parametersNotNull("val", val);
        return this.addCriteria(FilterOperator.GREATER_THAN, val);
    }

    @Override
    public T greaterThanOrEq(Object val) {
        Assert.parametersNotNull("val", val);
        return this.addCriteria(FilterOperator.GREATER_THAN_OR_EQUAL, val);
    }

    @Override
    public T hasAllOf(Iterable<?> values) {
        Assert.parametersNotNull("values", values);
        Assert.parameterNotEmpty("values", values);
        return this.addCriteria(FilterOperator.ALL, values);
    }

    @Override
    public T hasAnyOf(Iterable<?> values) {
        Assert.parametersNotNull("values", values);
        if (LOG.isWarnEnabled() && !values.iterator().hasNext()) {
            LOG.warn("Specified an empty list/collection with the '" + this.field + "' criteria");
        }
        return this.addCriteria(FilterOperator.IN, values);
    }

    @Override
    public T hasNoneOf(Iterable<?> values) {
        Assert.parametersNotNull("values", values);
        Assert.parameterNotEmpty("values", values);
        return this.addCriteria(FilterOperator.NOT_IN, values);
    }

    @Override
    @Deprecated
    public T doesNotHaveThisElement(Object val) {
        Assert.parametersNotNull("val", val);
        return this.addCriteria(FilterOperator.ELEMENT_MATCH, val, true);
    }

    @Override
    @Deprecated
    public T hasThisElement(Object val) {
        Assert.parametersNotNull("val", val);
        return this.addCriteria(FilterOperator.ELEMENT_MATCH, val, this.not);
    }

    @Override
    public T elemMatch(Query query) {
        Assert.parametersNotNull("query", query);
        return this.addCriteria(FilterOperator.ELEMENT_MATCH, query, this.not);
    }

    @Override
    public T hasThisOne(Object val) {
        return this.addCriteria(FilterOperator.EQUAL, val);
    }

    @Override
    public T in(Iterable<?> values) {
        return (T)this.hasAnyOf((Iterable)values);
    }

    @Override
    public T intersects(Geometry geometry) {
        this.target.add(Geo2dSphereCriteria.geo(this.query, this.field, FilterOperator.INTERSECTS, geometry));
        return this.target;
    }

    @Override
    public T intersects(Geometry geometry, CoordinateReferenceSystem crs) {
        this.target.add(Geo2dSphereCriteria.geo(this.query, this.field, FilterOperator.INTERSECTS, geometry).addCoordinateReferenceSystem(crs));
        return this.target;
    }

    @Override
    public T lessThan(Object val) {
        Assert.parametersNotNull("val", val);
        return this.addCriteria(FilterOperator.LESS_THAN, val);
    }

    @Override
    public T lessThanOrEq(Object val) {
        Assert.parametersNotNull("val", val);
        return this.addCriteria(FilterOperator.LESS_THAN_OR_EQUAL, val);
    }

    @Override
    public T mod(long divisor, long remainder) {
        return this.addCriteria(FilterOperator.MOD, new long[]{divisor, remainder});
    }

    @Override
    public T near(double longitude, double latitude) {
        return (T)this.near(longitude, latitude, false);
    }

    @Override
    public T near(double longitude, double latitude, boolean spherical) {
        return this.addGeoCriteria(spherical ? FilterOperator.NEAR_SPHERE : FilterOperator.NEAR, new double[]{longitude, latitude}, null);
    }

    @Override
    public T near(double longitude, double latitude, double radius) {
        return (T)this.near(longitude, latitude, radius, false);
    }

    @Override
    public T near(double longitude, double latitude, double radius, boolean spherical) {
        return this.addGeoCriteria(spherical ? FilterOperator.NEAR_SPHERE : FilterOperator.NEAR, new double[]{longitude, latitude}, this.opts("$maxDistance", radius));
    }

    @Override
    public T near(Point point, int maxDistance) {
        return (T)this.near(point, Double.valueOf(maxDistance), null);
    }

    @Override
    public T near(Point point) {
        this.target.add(Geo2dSphereCriteria.geo(this.query, this.field, FilterOperator.NEAR, point));
        return this.target;
    }

    @Override
    public T near(Point point, Double maxDistance, Double minDistance) {
        this.target.add(Geo2dSphereCriteria.geo(this.query, this.field, FilterOperator.NEAR, point).maxDistance(maxDistance).minDistance(minDistance));
        return this.target;
    }

    @Override
    public T nearSphere(Point point) {
        return (T)this.nearSphere(point, null, null);
    }

    @Override
    public T nearSphere(Point point, Double maxDistance, Double minDistance) {
        this.target.add(Geo2dSphereCriteria.geo(this.query, this.field, FilterOperator.NEAR_SPHERE, point).maxDistance(maxDistance).minDistance(minDistance));
        return this.target;
    }

    @Override
    public FieldEnd<T> not() {
        this.not = !this.not;
        return this;
    }

    @Override
    public T notEqual(Object val) {
        return this.addCriteria(FilterOperator.NOT_EQUAL, val);
    }

    @Override
    public T notIn(Iterable<?> values) {
        return (T)this.hasNoneOf((Iterable)values);
    }

    @Override
    public T sizeEq(int val) {
        return this.addCriteria(FilterOperator.SIZE, val);
    }

    @Override
    public T startsWith(String prefix) {
        Assert.parametersNotNull("val", prefix);
        return this.addCriteria(FilterOperator.EQUAL, Pattern.compile("^" + Pattern.quote(prefix)));
    }

    @Override
    public T startsWithIgnoreCase(String prefix) {
        Assert.parametersNotNull("val", prefix);
        return this.addCriteria(FilterOperator.EQUAL, Pattern.compile("^" + Pattern.quote(prefix), 2));
    }

    @Override
    public T type(Type type) {
        return this.addCriteria(FilterOperator.TYPE, type.val());
    }

    @Override
    public T within(Shape shape) {
        Assert.parametersNotNull("shape", shape);
        return this.addCriteria(FilterOperator.GEO_WITHIN, shape.toDBObject());
    }

    @Override
    public T within(Polygon boundary) {
        this.target.add(Geo2dSphereCriteria.geo(this.query, this.field, FilterOperator.GEO_WITHIN, boundary));
        return this.target;
    }

    @Override
    public T within(MultiPolygon boundaries) {
        this.target.add(Geo2dSphereCriteria.geo(this.query, this.field, FilterOperator.GEO_WITHIN, boundaries));
        return this.target;
    }

    @Override
    public T within(Polygon boundary, CoordinateReferenceSystem crs) {
        this.target.add(Geo2dSphereCriteria.geo(this.query, this.field, FilterOperator.GEO_WITHIN, boundary).addCoordinateReferenceSystem(crs));
        return this.target;
    }

    @Override
    public T within(MultiPolygon boundaries, CoordinateReferenceSystem crs) {
        this.target.add(Geo2dSphereCriteria.geo(this.query, this.field, FilterOperator.GEO_WITHIN, boundaries).addCoordinateReferenceSystem(crs));
        return this.target;
    }

    private T addCriteria(FilterOperator op, Object val) {
        return this.addCriteria(op, val, this.not);
    }

    private T addCriteria(FilterOperator op, Object val, boolean not) {
        this.target.add(new FieldCriteria(this.query, this.field, op, val, not));
        return this.target;
    }

    private T addGeoCriteria(FilterOperator op, Object val, Map<String, Object> opts) {
        if (this.not) {
            throw new QueryException("Geospatial queries cannot be negated with 'not'.");
        }
        this.target.add(new Geo2dCriteria(this.query, this.field, op, val, opts));
        return this.target;
    }

    private Map<String, Object> opts(String s, Object v) {
        HashMap<String, Object> opts = new HashMap<String, Object>();
        opts.put(s, v);
        return opts;
    }
}

