/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.query;

import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import dev.morphia.query.AbstractCriteria;
import dev.morphia.query.Criteria;
import dev.morphia.query.CriteriaContainer;
import dev.morphia.query.CriteriaJoin;
import dev.morphia.query.FieldEnd;
import dev.morphia.query.FieldEndImpl;
import dev.morphia.query.QueryImpl;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class CriteriaContainerImpl
extends AbstractCriteria
implements CriteriaContainer {
    private CriteriaJoin joinMethod;
    private List<Criteria> children;
    private QueryImpl<?> query;

    protected CriteriaContainerImpl(QueryImpl<?> query, CriteriaJoin joinMethod) {
        this(joinMethod);
        this.query = query;
    }

    protected CriteriaContainerImpl(CriteriaContainerImpl original) {
        this.joinMethod = original.joinMethod;
        this.query = original.query;
        this.children = new ArrayList<Criteria>(original.children);
    }

    protected CriteriaContainerImpl(CriteriaJoin joinMethod) {
        this.joinMethod = joinMethod;
        this.children = new ArrayList<Criteria>();
    }

    @Override
    public void add(Criteria ... criteria) {
        for (Criteria c : criteria) {
            c.attach(this);
            this.children.add(c);
        }
    }

    @Override
    public CriteriaContainer and(Criteria ... criteria) {
        return this.collect(CriteriaJoin.AND, criteria);
    }

    @Override
    public FieldEnd<? extends CriteriaContainer> criteria(String name) {
        return new FieldEndImpl<CriteriaContainerImpl>(this.query, name, this);
    }

    @Override
    public CriteriaContainer or(Criteria ... criteria) {
        return this.collect(CriteriaJoin.OR, criteria);
    }

    @Override
    public void remove(Criteria criteria) {
        this.children.remove(criteria);
    }

    @Override
    public DBObject toDBObject() {
        if (this.joinMethod == CriteriaJoin.AND) {
            return this.and();
        }
        return this.or();
    }

    private DBObject and() {
        BasicDBObject dbObject = new BasicDBObject();
        BasicDBList and = new BasicDBList();
        HashSet<String> names = new HashSet<String>();
        boolean duplicates = false;
        for (Criteria child : this.children) {
            DBObject childObject = child.toDBObject();
            for (String s : childObject.keySet()) {
                duplicates |= !names.add(s);
            }
            and.add((Object)childObject);
        }
        if (!duplicates) {
            for (Object o : and) {
                dbObject.putAll((Map)o);
            }
        } else {
            dbObject.put("$and", (Object)and);
        }
        return dbObject;
    }

    private DBObject or() {
        BasicDBObject dbObject = new BasicDBObject();
        BasicDBList or = new BasicDBList();
        for (Criteria child : this.children) {
            or.add((Object)child.toDBObject());
        }
        dbObject.put("$or", (Object)or);
        return dbObject;
    }

    @Override
    public String getFieldName() {
        return this.joinMethod.toString();
    }

    public QueryImpl<?> getQuery() {
        return this.query;
    }

    public void setQuery(QueryImpl<?> query) {
        this.query = query;
    }

    private CriteriaContainer collect(CriteriaJoin cj, Criteria ... criteria) {
        CriteriaContainerImpl parent = new CriteriaContainerImpl(this.query, cj);
        for (Criteria c : criteria) {
            parent.add(c);
        }
        this.add(parent);
        return parent;
    }

    public String toString() {
        return this.children.toString();
    }
}

