/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.mapping.validation.fieldrules;

import dev.morphia.annotations.Serialized;
import dev.morphia.mapping.MappedClass;
import dev.morphia.mapping.MappedField;
import dev.morphia.mapping.Mapper;
import dev.morphia.mapping.validation.ConstraintViolation;
import dev.morphia.mapping.validation.fieldrules.FieldConstraint;
import dev.morphia.utils.ReflectionUtils;
import java.io.Serializable;
import java.util.Set;

public class MapNotSerializable
extends FieldConstraint {
    @Override
    protected void check(Mapper mapper, MappedClass mc, MappedField mf, Set<ConstraintViolation> ve) {
        if (mf.isMap() && mf.hasAnnotation(Serialized.class)) {
            Class keyClass = ReflectionUtils.getParameterizedClass(mf.getField(), 0);
            Class valueClass = ReflectionUtils.getParameterizedClass(mf.getField(), 1);
            if (keyClass != null && !Serializable.class.isAssignableFrom(keyClass)) {
                ve.add(new ConstraintViolation(ConstraintViolation.Level.FATAL, mc, mf, this.getClass(), "Key class (" + keyClass.getName() + ") is not Serializable"));
            }
            if (valueClass != null && !Serializable.class.isAssignableFrom(valueClass)) {
                ve.add(new ConstraintViolation(ConstraintViolation.Level.FATAL, mc, mf, this.getClass(), "Value class (" + valueClass.getName() + ") is not Serializable"));
            }
        }
    }
}

