/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.mapping.validation;

import dev.morphia.ObjectFactory;
import dev.morphia.annotations.Embedded;
import dev.morphia.annotations.Property;
import dev.morphia.annotations.Reference;
import dev.morphia.annotations.Serialized;
import dev.morphia.mapping.MappedClass;
import dev.morphia.mapping.Mapper;
import dev.morphia.mapping.validation.ClassConstraint;
import dev.morphia.mapping.validation.ConstraintViolation;
import dev.morphia.mapping.validation.ConstraintViolationException;
import dev.morphia.mapping.validation.classrules.DuplicatedAttributeNames;
import dev.morphia.mapping.validation.classrules.EmbeddedAndId;
import dev.morphia.mapping.validation.classrules.EmbeddedAndValue;
import dev.morphia.mapping.validation.classrules.EntityAndEmbed;
import dev.morphia.mapping.validation.classrules.EntityCannotBeMapOrIterable;
import dev.morphia.mapping.validation.classrules.MultipleId;
import dev.morphia.mapping.validation.classrules.MultipleVersions;
import dev.morphia.mapping.validation.classrules.NoId;
import dev.morphia.mapping.validation.fieldrules.ContradictingFieldAnnotation;
import dev.morphia.mapping.validation.fieldrules.LazyReferenceMissingDependencies;
import dev.morphia.mapping.validation.fieldrules.LazyReferenceOnArray;
import dev.morphia.mapping.validation.fieldrules.MapKeyDifferentFromString;
import dev.morphia.mapping.validation.fieldrules.MapNotSerializable;
import dev.morphia.mapping.validation.fieldrules.MisplacedProperty;
import dev.morphia.mapping.validation.fieldrules.ReferenceToUnidentifiable;
import dev.morphia.mapping.validation.fieldrules.VersionMisuse;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MappingValidator {
    private static final Logger LOG = LoggerFactory.getLogger(MappingValidator.class);
    private ObjectFactory creator;

    public MappingValidator(ObjectFactory objectFactory) {
        this.creator = objectFactory;
    }

    @Deprecated
    public void validate(Mapper mapper, MappedClass mappedClass) {
        this.validate(mapper, Collections.singletonList(mappedClass));
    }

    public void validate(Mapper mapper, List<MappedClass> classes) {
        TreeSet<ConstraintViolation> ve = new TreeSet<ConstraintViolation>(new Comparator<ConstraintViolation>(){

            @Override
            public int compare(ConstraintViolation o1, ConstraintViolation o2) {
                return o1.getLevel().ordinal() > o2.getLevel().ordinal() ? -1 : 1;
            }
        });
        List<ClassConstraint> rules = this.getConstraints();
        for (MappedClass c : classes) {
            for (ClassConstraint v : rules) {
                v.check(mapper, c, ve);
            }
        }
        if (!ve.isEmpty()) {
            ConstraintViolation worst = (ConstraintViolation)ve.iterator().next();
            ConstraintViolation.Level maxLevel = worst.getLevel();
            if (maxLevel.ordinal() >= ConstraintViolation.Level.FATAL.ordinal()) {
                throw new ConstraintViolationException(ve);
            }
            ArrayList<LogLine> l = new ArrayList<LogLine>();
            for (ConstraintViolation v : ve) {
                l.add(new LogLine(v));
            }
            Collections.sort(l);
            for (LogLine line : l) {
                line.log(LOG);
            }
        }
    }

    private List<ClassConstraint> getConstraints() {
        ArrayList<ClassConstraint> constraints = new ArrayList<ClassConstraint>(32);
        constraints.add(new MultipleId());
        constraints.add(new MultipleVersions());
        constraints.add(new NoId());
        constraints.add(new EmbeddedAndId());
        constraints.add(new EntityAndEmbed());
        constraints.add(new EmbeddedAndValue());
        constraints.add(new EntityCannotBeMapOrIterable());
        constraints.add(new DuplicatedAttributeNames());
        constraints.add(new MisplacedProperty());
        constraints.add(new ReferenceToUnidentifiable());
        constraints.add(new LazyReferenceMissingDependencies());
        constraints.add(new LazyReferenceOnArray());
        constraints.add(new MapKeyDifferentFromString());
        constraints.add(new MapNotSerializable());
        constraints.add(new VersionMisuse(this.creator));
        constraints.add(new ContradictingFieldAnnotation(Reference.class, Serialized.class));
        constraints.add(new ContradictingFieldAnnotation(Reference.class, Property.class));
        constraints.add(new ContradictingFieldAnnotation(Reference.class, Embedded.class));
        constraints.add(new ContradictingFieldAnnotation(Embedded.class, Serialized.class));
        constraints.add(new ContradictingFieldAnnotation(Embedded.class, Property.class));
        constraints.add(new ContradictingFieldAnnotation(Property.class, Serialized.class));
        return constraints;
    }

    static class LogLine
    implements Comparable<LogLine> {
        private final ConstraintViolation v;

        LogLine(ConstraintViolation v) {
            this.v = v;
        }

        @Override
        public int compareTo(LogLine o) {
            return this.v.getPrefix().compareTo(o.v.getPrefix());
        }

        public int hashCode() {
            return this.v.hashCode();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LogLine logLine = (LogLine)o;
            return this.v.equals(logLine.v);
        }

        void log(Logger logger) {
            switch (this.v.getLevel()) {
                case SEVERE: {
                    logger.error(this.v.render());
                    break;
                }
                case WARNING: {
                    logger.warn(this.v.render());
                    break;
                }
                case INFO: {
                    logger.info(this.v.render());
                    break;
                }
                case MINOR: {
                    logger.debug(this.v.render());
                    break;
                }
                default: {
                    throw new IllegalStateException(String.format("Cannot log %s of Level %s", new Object[]{ConstraintViolation.class.getSimpleName(), this.v.getLevel()}));
                }
            }
        }
    }
}

