/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.mapping.experimental;

import com.mongodb.DBRef;
import dev.morphia.Datastore;
import dev.morphia.mapping.MappedClass;
import dev.morphia.mapping.MappedField;
import dev.morphia.mapping.Mapper;
import dev.morphia.mapping.experimental.ListReference;
import dev.morphia.mapping.experimental.MapReference;
import dev.morphia.mapping.experimental.SetReference;
import dev.morphia.mapping.experimental.SingleReference;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class MorphiaReference<T> {
    private Datastore datastore;
    private MappedClass mappedClass;

    MorphiaReference() {
    }

    MorphiaReference(Datastore datastore, MappedClass mappedClass) {
        this.datastore = datastore;
        this.mappedClass = mappedClass;
    }

    static Object wrapId(Mapper mapper, MappedField field, Object entity) {
        Object id = mapper.getId(entity);
        Object encoded = mapper.toMongoObject(field, mapper.getMappedClass(entity), id);
        if (!entity.getClass().equals(field.getType())) {
            encoded = new DBRef(mapper.getCollectionName(entity), encoded);
        }
        return encoded;
    }

    public abstract T get();

    public abstract boolean isResolved();

    public abstract Object encode(Mapper var1, Object var2, MappedField var3);

    Datastore getDatastore() {
        return this.datastore;
    }

    MappedClass getMappedClass() {
        return this.mappedClass;
    }

    public static <V> MorphiaReference<V> wrap(V value) {
        if (value instanceof List) {
            return new ListReference((List)value);
        }
        if (value instanceof Set) {
            return new SetReference((Set)value);
        }
        if (value instanceof Map) {
            return new MapReference((Map)value);
        }
        return new SingleReference<V>(value);
    }
}

