/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.mapping;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.bson.types.Binary;

public final class Serializer {
    private Serializer() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] serialize(Object o, boolean zip) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        OutputStream os = baos;
        ObjectOutputStream oos = null;
        try {
            if (zip) {
                os = new GZIPOutputStream(os);
            }
            oos = new ObjectOutputStream(os);
            oos.writeObject(o);
            oos.flush();
        }
        finally {
            if (oos != null) {
                oos.close();
            }
            os.close();
        }
        return baos.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object deserialize(Object data, boolean zipped) throws IOException, ClassNotFoundException {
        ByteArrayInputStream bais = data instanceof Binary ? new ByteArrayInputStream(((Binary)data).getData()) : new ByteArrayInputStream((byte[])data);
        try (InputStream is = bais;){
            if (zipped) {
                is = new GZIPInputStream(is);
            }
            ObjectInputStream ois = new ObjectInputStream(is);
            Object object = ois.readObject();
            return object;
        }
    }
}

