/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.mapping;

import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import com.mongodb.DBRef;
import dev.morphia.Datastore;
import dev.morphia.Key;
import dev.morphia.annotations.Reference;
import dev.morphia.mapping.CustomMapper;
import dev.morphia.mapping.MappedClass;
import dev.morphia.mapping.MappedField;
import dev.morphia.mapping.Mapper;
import dev.morphia.mapping.MappingException;
import dev.morphia.mapping.cache.EntityCache;
import dev.morphia.mapping.experimental.CollectionReference;
import dev.morphia.mapping.experimental.MapReference;
import dev.morphia.mapping.experimental.MorphiaReference;
import dev.morphia.mapping.experimental.SingleReference;
import dev.morphia.mapping.lazy.LazyFeatureDependencies;
import dev.morphia.mapping.lazy.proxy.ProxiedEntityReference;
import dev.morphia.mapping.lazy.proxy.ProxiedEntityReferenceList;
import dev.morphia.mapping.lazy.proxy.ProxiedEntityReferenceMap;
import dev.morphia.mapping.lazy.proxy.ProxyHelper;
import dev.morphia.utils.IterHelper;
import dev.morphia.utils.ReflectionUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
class ReferenceMapper
implements CustomMapper {
    public static final Logger LOG = LoggerFactory.getLogger(ReferenceMapper.class);

    ReferenceMapper() {
    }

    @Override
    public void fromDBObject(Datastore datastore, DBObject dbObject, MappedField mf, Object entity, EntityCache cache, Mapper mapper) {
        Class fieldType = mf.getType();
        if (mf.getType().equals(MorphiaReference.class) && !mf.getTypeParameters().isEmpty()) {
            this.readMorphiaReferenceValues(mapper, datastore, mf, dbObject, entity);
        } else {
            Reference refAnn = mf.getAnnotation(Reference.class);
            if (mf.isMap()) {
                this.readMap(datastore, mapper, entity, refAnn, cache, mf, dbObject);
            } else if (mf.isMultipleValues()) {
                this.readCollection(datastore, mapper, dbObject, mf, entity, refAnn, cache);
            } else {
                this.readSingle(datastore, mapper, entity, fieldType, refAnn, cache, mf, dbObject);
            }
        }
    }

    @Override
    public void toDBObject(Object entity, MappedField mf, DBObject dbObject, Map<Object, DBObject> involvedObjects, Mapper mapper) {
        String name = mf.getNameToStore();
        Object fieldValue = mf.getFieldValue(entity);
        if (fieldValue == null && !mapper.getOptions().isStoreNulls()) {
            return;
        }
        if (fieldValue instanceof MorphiaReference && !mf.getTypeParameters().isEmpty()) {
            this.writeMorphiaReferenceValues(dbObject, mf, fieldValue, name, mapper);
        } else {
            Reference refAnn = mf.getAnnotation(Reference.class);
            if (mf.isMap()) {
                this.writeMap(mf, dbObject, name, fieldValue, refAnn, mapper);
            } else if (mf.isMultipleValues()) {
                this.writeCollection(mf, dbObject, name, fieldValue, refAnn, mapper);
            } else {
                this.writeSingle(dbObject, name, fieldValue, refAnn, mapper);
            }
        }
    }

    private void addValue(List values, Object o, Mapper mapper, boolean idOnly) {
        if (o == null && mapper.getOptions().isStoreNulls()) {
            values.add(null);
            return;
        }
        Key<?> key = o instanceof Key ? (Key<?>)o : this.getKey(o, mapper);
        values.add(idOnly ? mapper.keyToId(key) : mapper.keyToDBRef(key));
    }

    private Object createOrReuseProxy(Datastore datastore, Mapper mapper, Class referenceObjClass, Object ref, EntityCache cache, Reference anntotation) {
        Key key = anntotation.idOnly() ? mapper.manualRefToKey(referenceObjClass, ref) : mapper.refToKey((DBRef)ref);
        Object proxyAlreadyCreated = cache.getProxy(key);
        if (proxyAlreadyCreated != null) {
            return proxyAlreadyCreated;
        }
        Object newProxy = mapper.getProxyFactory().createProxy(datastore, referenceObjClass, key, anntotation.ignoreMissing());
        cache.putProxy(key, newProxy);
        return newProxy;
    }

    private Key<?> getKey(Object entity, Mapper mapper) {
        try {
            if (entity instanceof ProxiedEntityReference) {
                ProxiedEntityReference proxy = (ProxiedEntityReference)entity;
                return proxy.__getKey();
            }
            MappedClass mappedClass = mapper.getMappedClass(entity);
            Object id = mappedClass.getIdField().get(entity);
            if (id == null) {
                throw new MappingException("@Id field cannot be null!");
            }
            return new Key(mappedClass.getClazz(), mappedClass.getCollectionName(), id);
        }
        catch (IllegalAccessException iae) {
            throw new RuntimeException(iae);
        }
    }

    private void readCollection(final Datastore datastore, final Mapper mapper, DBObject dbObject, final MappedField mf, Object entity, final Reference refAnn, final EntityCache cache) {
        Collection references;
        Class referenceObjClass = mf.getSubClass();
        mapper.getMappedClass(referenceObjClass);
        Collection collection = references = mf.isSet() ? mapper.getOptions().getObjectFactory().createSet(mf) : mapper.getOptions().getObjectFactory().createList(mf);
        if (refAnn.lazy() && LazyFeatureDependencies.assertDependencyFullFilled()) {
            Object dbVal = mf.getDbObjectValue(dbObject);
            if (dbVal != null) {
                references = mapper.getProxyFactory().createListProxy(datastore, references, referenceObjClass, refAnn.ignoreMissing());
                ProxiedEntityReferenceList referencesAsProxy = (ProxiedEntityReferenceList)((Object)references);
                if (dbVal instanceof List) {
                    referencesAsProxy.__addAll(refAnn.idOnly() ? mapper.getKeysByManualRefs(referenceObjClass, (List)dbVal) : mapper.getKeysByRefs((List)dbVal));
                } else {
                    referencesAsProxy.__add(refAnn.idOnly() ? mapper.manualRefToKey(referenceObjClass, dbVal) : mapper.refToKey((DBRef)dbVal));
                }
            }
        } else {
            Object dbVal = mf.getDbObjectValue(dbObject);
            final Collection refs = references;
            new IterHelper().loopOrSingle(dbVal, new IterHelper.IterCallback<Object>(){

                @Override
                public void eval(Object val) {
                    Object ent = ReferenceMapper.this.resolveObject(datastore, mapper, cache, mf, refAnn.idOnly(), val);
                    if (ent == null) {
                        LOG.warn("Null reference found when retrieving value for " + mf.getFullName());
                    } else {
                        refs.add(ent);
                    }
                }
            });
        }
        if (mf.getType().isArray()) {
            mf.setFieldValue(entity, ReflectionUtils.convertToArray(mf.getSubClass(), ReflectionUtils.iterToList(references)));
        } else {
            mf.setFieldValue(entity, references);
        }
    }

    private void readMap(final Datastore datastore, final Mapper mapper, Object entity, final Reference refAnn, final EntityCache cache, final MappedField mf, DBObject dbObject) {
        final Class referenceObjClass = mf.getSubClass();
        Map m = mapper.getOptions().getObjectFactory().createMap(mf);
        DBObject dbVal = (DBObject)mf.getDbObjectValue(dbObject);
        if (dbVal != null) {
            if (refAnn.lazy() && LazyFeatureDependencies.assertDependencyFullFilled()) {
                m = mapper.getProxyFactory().createMapProxy(datastore, m, referenceObjClass, refAnn.ignoreMissing());
            }
            final Map map = m;
            new IterHelper<Object, Object>().loopMap(dbVal, new IterHelper.MapIterCallback<Object, Object>(){

                @Override
                public void eval(Object k, Object val) {
                    Object objKey = mapper.getConverters().decode(mf.getMapKeyClass(), k, mf);
                    if (refAnn.lazy() && LazyFeatureDependencies.assertDependencyFullFilled()) {
                        ProxiedEntityReferenceMap proxiedMap = (ProxiedEntityReferenceMap)((Object)map);
                        proxiedMap.__put(objKey, refAnn.idOnly() ? mapper.manualRefToKey(referenceObjClass, val) : mapper.refToKey((DBRef)val));
                    } else {
                        map.put(objKey, ReferenceMapper.this.resolveObject(datastore, mapper, cache, mf, refAnn.idOnly(), val));
                    }
                }
            });
        }
        mf.setFieldValue(entity, m);
    }

    private void readSingle(Datastore datastore, Mapper mapper, Object entity, Class fieldType, Reference annotation, EntityCache cache, MappedField mf, DBObject dbObject) {
        Object resolvedObject;
        Object ref = mf.getDbObjectValue(dbObject);
        if (ref != null && (resolvedObject = annotation.lazy() && LazyFeatureDependencies.assertDependencyFullFilled() ? this.createOrReuseProxy(datastore, mapper, fieldType, ref, cache, annotation) : this.resolveObject(datastore, mapper, cache, mf, annotation.idOnly(), ref)) != null) {
            mf.setFieldValue(entity, resolvedObject);
        }
    }

    private void writeCollection(MappedField mf, DBObject dbObject, String name, Object fieldValue, Reference refAnn, Mapper mapper) {
        if (fieldValue != null) {
            ArrayList values = new ArrayList();
            if (ProxyHelper.isProxy(fieldValue) && ProxyHelper.isUnFetched(fieldValue)) {
                ProxiedEntityReferenceList p = (ProxiedEntityReferenceList)fieldValue;
                List<Key<?>> getKeysAsList = p.__getKeysAsList();
                for (Key<?> key : getKeysAsList) {
                    this.addValue(values, key, mapper, refAnn.idOnly());
                }
            } else if (mf.getType().isArray()) {
                for (Object o : (Object[])fieldValue) {
                    this.addValue(values, o, mapper, refAnn.idOnly());
                }
            } else {
                for (Object o : (Iterable)fieldValue) {
                    this.addValue(values, o, mapper, refAnn.idOnly());
                }
            }
            if (!values.isEmpty() || mapper.getOptions().isStoreEmpties()) {
                dbObject.put(name, values);
            }
        }
    }

    private void writeMap(MappedField mf, DBObject dbObject, String name, Object fieldValue, Reference refAnn, Mapper mapper) {
        Map map = (Map)fieldValue;
        if (map != null) {
            Map values = mapper.getOptions().getObjectFactory().createMap(mf);
            if (ProxyHelper.isProxy(map) && ProxyHelper.isUnFetched(map)) {
                ProxiedEntityReferenceMap proxy = (ProxiedEntityReferenceMap)((Object)map);
                Map<Object, Key<?>> refMap = proxy.__getReferenceMap();
                for (Map.Entry<Object, Key<?>> entry : refMap.entrySet()) {
                    Object key = entry.getKey();
                    values.put(key, refAnn.idOnly() ? mapper.keyToId(entry.getValue()) : mapper.keyToDBRef(entry.getValue()));
                }
            } else {
                for (Map.Entry entry : map.entrySet()) {
                    String strKey = mapper.getConverters().encode(entry.getKey()).toString();
                    values.put(strKey, refAnn.idOnly() ? mapper.keyToId(this.getKey(entry.getValue(), mapper)) : mapper.keyToDBRef(this.getKey(entry.getValue(), mapper)));
                }
            }
            if (!values.isEmpty() || mapper.getOptions().isStoreEmpties()) {
                dbObject.put(name, (Object)values);
            }
        }
    }

    private void writeSingle(DBObject dbObject, String name, Object fieldValue, Reference refAnn, Mapper mapper) {
        if (fieldValue == null) {
            if (mapper.getOptions().isStoreNulls()) {
                dbObject.put(name, null);
            }
        } else {
            Key<?> key = this.getKey(fieldValue, mapper);
            if (refAnn.idOnly()) {
                Object id = mapper.keyToId(key);
                if (id != null && mapper.isMapped(id.getClass())) {
                    id = mapper.toMongoObject(id, true);
                }
                dbObject.put(name, id);
            } else {
                dbObject.put(name, (Object)mapper.keyToDBRef(key));
            }
        }
    }

    Object resolveObject(Datastore datastore, Mapper mapper, EntityCache cache, MappedField mf, boolean idOnly, Object ref) {
        boolean ignoreMissing;
        DBObject refDbObject;
        Object id;
        DBCollection collection;
        if (ref == null) {
            return null;
        }
        DBRef dbRef = idOnly ? null : (DBRef)ref;
        Key key = mapper.createKey(mf.isSingleValue() ? mf.getType() : mf.getSubClass(), idOnly ? ref : dbRef.getId());
        Object cached = cache.getEntity(key);
        if (cached != null) {
            return cached;
        }
        if (idOnly) {
            collection = datastore.getCollection(key.getType());
            id = ref;
        } else {
            collection = datastore.getDB().getCollection(dbRef.getCollectionName());
            id = dbRef.getId();
        }
        if (id instanceof DBObject) {
            ((DBObject)id).removeField(mapper.getOptions().getDiscriminatorField());
        }
        if ((refDbObject = collection.findOne(id)) != null) {
            Object refObj = mapper.getOptions().getObjectFactory().createInstance(mapper, mf, refDbObject);
            refObj = mapper.fromDb(datastore, refDbObject, refObj, cache);
            cache.putEntity(key, refObj);
            return refObj;
        }
        boolean bl = ignoreMissing = mf.getAnnotation(Reference.class) != null && mf.getAnnotation(Reference.class).ignoreMissing();
        if (!ignoreMissing) {
            throw new MappingException(String.format("The reference (%s) could not be fetched for %s", ref, mf.getFullName()));
        }
        return null;
    }

    void readMorphiaReferenceValues(Mapper mapper, Datastore datastore, MappedField mappedField, DBObject dbObject, Object entity) {
        Class paramType = mappedField.getTypeParameters().get(0).getType();
        MorphiaReference reference = Map.class.isAssignableFrom(paramType) ? MapReference.decode(datastore, mapper, mappedField, dbObject) : (Collection.class.isAssignableFrom(paramType) ? CollectionReference.decode(datastore, mapper, mappedField, paramType, dbObject) : SingleReference.decode(datastore, mapper, mappedField, paramType, dbObject));
        mappedField.setFieldValue(entity, reference);
    }

    void writeMorphiaReferenceValues(DBObject dbObject, MappedField mf, Object fieldValue, String name, Mapper mapper) {
        boolean notNull;
        Class paramType = mf.getTypeParameters().get(0).getType();
        boolean notEmpty = true;
        Object value = ((MorphiaReference)fieldValue).encode(mapper, fieldValue, mf);
        boolean bl = notNull = value != null;
        if (Map.class.isAssignableFrom(paramType)) {
            notEmpty = notNull && !((Map)value).isEmpty();
        } else if (Collection.class.isAssignableFrom(paramType)) {
            boolean bl2 = notEmpty = notNull && !((Collection)value).isEmpty();
        }
        if ((notNull || mapper.getOptions().isStoreNulls()) && (notEmpty || mapper.getOptions().isStoreEmpties())) {
            dbObject.put(name, value);
        }
    }
}

