/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.mapping;

import com.mongodb.DBObject;
import com.mongodb.DBRef;
import dev.morphia.Key;
import dev.morphia.annotations.AlsoLoad;
import dev.morphia.annotations.ConstructorArgs;
import dev.morphia.annotations.Embedded;
import dev.morphia.annotations.Id;
import dev.morphia.annotations.Indexed;
import dev.morphia.annotations.NotSaved;
import dev.morphia.annotations.Property;
import dev.morphia.annotations.Reference;
import dev.morphia.annotations.Serialized;
import dev.morphia.annotations.Text;
import dev.morphia.annotations.Transient;
import dev.morphia.annotations.Version;
import dev.morphia.mapping.EphemeralMappedField;
import dev.morphia.mapping.Mapper;
import dev.morphia.mapping.MappingException;
import dev.morphia.mapping.experimental.MorphiaReference;
import dev.morphia.utils.ReflectionUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MappedField {
    private static final Logger LOG = LoggerFactory.getLogger(MappedField.class);
    private static final List<Class<? extends Annotation>> INTERESTING = new ArrayList<Class<? extends Annotation>>();
    private final Map<Class<? extends Annotation>, Annotation> foundAnnotations = new HashMap<Class<? extends Annotation>, Annotation>();
    private final List<MappedField> typeParameters = new ArrayList<MappedField>();
    private Class persistedClass;
    private Field field;
    private Class realType;
    private Constructor constructor;
    private Type subType;
    private Type mapKeyType;
    private boolean isSingleValue = true;
    private boolean isMongoType;
    private boolean isMap;
    private boolean isSet;
    private boolean isArray;
    private boolean isCollection;
    private Type genericType;
    private String nameToStore;
    private List<String> loadNames;

    MappedField(Field f, Class<?> clazz, Mapper mapper) {
        f.setAccessible(true);
        this.field = f;
        this.persistedClass = clazz;
        this.realType = this.field.getType();
        this.genericType = this.field.getGenericType();
        this.discover(mapper);
        this.discoverNames();
    }

    MappedField(Field field, Type type, Mapper mapper) {
        this.field = field;
        this.genericType = type;
        this.discoverType(mapper);
        this.discoverNames();
    }

    private void discoverNames() {
        this.nameToStore = this.getMappedFieldName();
        this.loadNames = this.inferLoadNames();
    }

    public static void addInterestingAnnotation(Class<? extends Annotation> annotation) {
        INTERESTING.add(annotation);
    }

    public void addAnnotation(Class<? extends Annotation> clazz) {
        if (this.field.isAnnotationPresent(clazz)) {
            this.addAnnotation(clazz, this.field.getAnnotation(clazz));
        }
    }

    public void addAnnotation(Class<? extends Annotation> clazz, Annotation ann) {
        this.foundAnnotations.put(clazz, ann);
        this.discoverNames();
    }

    public <T extends Annotation> T getAnnotation(Class<T> clazz) {
        return (T)this.foundAnnotations.get(clazz);
    }

    public Map<Class<? extends Annotation>, Annotation> getAnnotations() {
        return Collections.unmodifiableMap(this.foundAnnotations);
    }

    public Constructor getCTor() {
        return this.constructor;
    }

    public Class getConcreteType() {
        Class<?> concrete;
        Class<?> concrete2;
        Embedded e = this.getAnnotation(Embedded.class);
        if (e != null && (concrete2 = e.concreteClass()) != Object.class) {
            return concrete2;
        }
        Property p = this.getAnnotation(Property.class);
        if (p != null && (concrete = p.concreteClass()) != Object.class) {
            return concrete;
        }
        return this.getType();
    }

    public Object getDbObjectValue(DBObject dbObj) {
        return dbObj.get(this.getFirstFieldName(dbObj));
    }

    public Class getDeclaringClass() {
        return this.field.getDeclaringClass();
    }

    public Field getField() {
        return this.field;
    }

    public Object getFieldValue(Object instance) {
        try {
            return this.field.get(instance);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public String getFirstFieldName(DBObject dbObj) {
        String fieldName = this.getNameToStore();
        boolean foundField = false;
        for (String n : this.getLoadNames()) {
            if (!dbObj.containsField(n)) continue;
            if (!foundField) {
                foundField = true;
                fieldName = n;
                continue;
            }
            throw new MappingException(String.format("Found more than one field from @AlsoLoad %s", this.getLoadNames()));
        }
        return fieldName;
    }

    public String getFullName() {
        return this.field.getDeclaringClass().getName() + "." + this.field.getName();
    }

    public String getJavaFieldName() {
        return this.field.getName();
    }

    public List<String> getLoadNames() {
        return this.loadNames;
    }

    protected List<String> inferLoadNames() {
        AlsoLoad al = (AlsoLoad)this.foundAnnotations.get(AlsoLoad.class);
        if (al != null && al.value() != null && al.value().length > 0) {
            ArrayList<String> names = new ArrayList<String>();
            names.add(this.getMappedFieldName());
            names.addAll(Arrays.asList(al.value()));
            return names;
        }
        return Collections.singletonList(this.getMappedFieldName());
    }

    public Class getMapKeyClass() {
        return this.toClass(this.mapKeyType);
    }

    public String getNameToStore() {
        return this.nameToStore;
    }

    public Class getSubClass() {
        return this.toClass(this.subType);
    }

    public Type getSubType() {
        return this.subType;
    }

    public boolean isTransient() {
        return this.hasAnnotation(Transient.class) || Modifier.isTransient(this.field.getModifiers());
    }

    void setSubType(Type subType) {
        this.subType = subType;
    }

    public Class getType() {
        return this.realType;
    }

    public List<MappedField> getTypeParameters() {
        return this.typeParameters;
    }

    public boolean hasAnnotation(Class ann) {
        return this.foundAnnotations.containsKey(ann);
    }

    public boolean isArray() {
        return this.isArray;
    }

    public boolean isMap() {
        return this.isMap;
    }

    public boolean isMultipleValues() {
        return !this.isSingleValue();
    }

    public boolean isReference() {
        return this.hasAnnotation(Reference.class) || Key.class == this.getConcreteType() || DBRef.class == this.getConcreteType() || MorphiaReference.class == this.getConcreteType();
    }

    public boolean isSet() {
        return this.isSet;
    }

    public boolean isSingleValue() {
        if (!(this.isSingleValue || this.isMap || this.isSet || this.isArray || this.isCollection)) {
            throw new RuntimeException("Not single, but none of the types that are not-single.");
        }
        return this.isSingleValue;
    }

    public boolean isTypeMongoCompatible() {
        return this.isMongoType;
    }

    @Deprecated
    public Annotation putAnnotation(Annotation ann) {
        Annotation put = this.foundAnnotations.put(ann.getClass(), ann);
        this.discoverNames();
        return put;
    }

    public void setFieldValue(Object instance, Object value) {
        try {
            this.field.set(instance, value);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getNameToStore()).append(" (");
        sb.append(" type:").append(this.realType.getSimpleName()).append(",");
        if (this.isSingleValue()) {
            sb.append(" single:true,");
        } else {
            sb.append(" multiple:true,");
            sb.append(" subtype:").append(this.getSubClass()).append(",");
        }
        if (this.isMap()) {
            sb.append(" map:true,");
            if (this.getMapKeyClass() != null) {
                sb.append(" map-key:").append(this.getMapKeyClass().getSimpleName());
            } else {
                sb.append(" map-key: class unknown! ");
            }
        }
        if (this.isSet()) {
            sb.append(" set:true,");
        }
        if (this.isCollection) {
            sb.append(" collection:true,");
        }
        if (this.isArray) {
            sb.append(" array:true,");
        }
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setLength(sb.length() - 1);
        }
        sb.append("); ").append(this.foundAnnotations.toString());
        return sb.toString();
    }

    protected void discover(Mapper mapper) {
        for (Class<? extends Annotation> clazz : INTERESTING) {
            this.addAnnotation(clazz);
        }
        this.discoverType(mapper);
        this.constructor = this.discoverConstructor();
        this.discoverMultivalued();
        this.isMongoType = ReflectionUtils.isPropertyType(this.realType);
        if (!this.isMongoType && this.subType != null) {
            this.isMongoType = ReflectionUtils.isPropertyType(this.subType);
        }
        if (!(this.isMongoType || this.isSingleValue || this.subType != null && this.subType != Object.class)) {
            if (LOG.isWarnEnabled() && !mapper.getConverters().hasDbObjectConverter(this)) {
                LOG.warn(String.format("The multi-valued field '%s' is a possible heterogeneous collection. It cannot be verified. Please declare a valid type to get rid of this warning. %s", this.getFullName(), this.subType));
            }
            this.isMongoType = true;
        }
    }

    protected void discoverType(Mapper mapper) {
        if (this.genericType instanceof TypeVariable) {
            this.realType = this.extractTypeVariable((TypeVariable)this.genericType);
        } else if (this.genericType instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)this.genericType;
            Type[] types = pt.getActualTypeArguments();
            this.realType = this.toClass(pt);
            this.collectTypeParameters(mapper, types);
        } else if (this.genericType instanceof WildcardType) {
            WildcardType wildcardType = (WildcardType)this.genericType;
            Type[] types = wildcardType.getUpperBounds();
            this.realType = this.toClass(types[0]);
        } else if (this.genericType instanceof Class) {
            this.realType = (Class)this.genericType;
        } else if (this.genericType instanceof GenericArrayType) {
            Type genericComponentType = ((GenericArrayType)this.genericType).getGenericComponentType();
            if (genericComponentType instanceof ParameterizedType) {
                ParameterizedType pt = (ParameterizedType)genericComponentType;
                this.realType = this.toClass(this.genericType);
                Type[] types = pt.getActualTypeArguments();
                this.collectTypeParameters(mapper, types);
            } else {
                this.realType = genericComponentType instanceof TypeVariable ? this.toClass(this.genericType) : (Class)genericComponentType;
            }
        }
        if ((Object.class.equals((Object)this.realType) || Object[].class.equals((Object)this.realType)) && LOG.isWarnEnabled()) {
            LOG.warn(String.format("Parameterized types are treated as untyped Objects. See field '%s' on %s", this.field.getName(), this.field.getDeclaringClass()));
        }
        if (this.realType == null) {
            throw new MappingException(String.format("A type could not be found for the field %s.%s", this.getType(), this.getField()));
        }
    }

    private void collectTypeParameters(Mapper mapper, Type[] types) {
        for (Type type : types) {
            if (type instanceof ParameterizedType) {
                this.typeParameters.add(new EphemeralMappedField((ParameterizedType)type, this, mapper));
                continue;
            }
            if (type instanceof WildcardType) {
                type = ((WildcardType)type).getUpperBounds()[0];
            }
            this.typeParameters.add(new EphemeralMappedField(type, this, mapper));
        }
    }

    private Class extractTypeVariable(TypeVariable<?> type) {
        Class<?> typeArgument = ReflectionUtils.getTypeArgument(this.persistedClass, type);
        return typeArgument != null ? typeArgument : Object.class;
    }

    public String getMappedFieldName() {
        Version me;
        if (this.hasAnnotation(Id.class)) {
            return "_id";
        }
        if (this.hasAnnotation(Property.class)) {
            Property mv = (Property)this.foundAnnotations.get(Property.class);
            if (!mv.value().equals(".")) {
                return mv.value();
            }
        } else if (this.hasAnnotation(Reference.class)) {
            Reference mr = (Reference)this.foundAnnotations.get(Reference.class);
            if (!mr.value().equals(".")) {
                return mr.value();
            }
        } else if (this.hasAnnotation(Embedded.class)) {
            Embedded me2 = (Embedded)this.foundAnnotations.get(Embedded.class);
            if (!me2.value().equals(".")) {
                return me2.value();
            }
        } else if (this.hasAnnotation(Serialized.class)) {
            Serialized me3 = (Serialized)this.foundAnnotations.get(Serialized.class);
            if (!me3.value().equals(".")) {
                return me3.value();
            }
        } else if (this.hasAnnotation(Version.class) && !(me = (Version)this.foundAnnotations.get(Version.class)).value().equals(".")) {
            return me.value();
        }
        return this.field.getName();
    }

    protected Class toClass(Type t) {
        if (t == null) {
            return null;
        }
        if (t instanceof Class) {
            return (Class)t;
        }
        if (t instanceof GenericArrayType) {
            Class<Object> aClass;
            Type type = ((GenericArrayType)t).getGenericComponentType();
            if (type instanceof ParameterizedType) {
                aClass = (Class<?>)((ParameterizedType)type).getRawType();
            } else if (type instanceof TypeVariable) {
                aClass = ReflectionUtils.getTypeArgument(this.persistedClass, (TypeVariable)type);
                if (aClass == null) {
                    aClass = Object.class;
                }
            } else {
                aClass = (Class)type;
            }
            return Array.newInstance(aClass, 0).getClass();
        }
        if (t instanceof ParameterizedType) {
            return (Class)((ParameterizedType)t).getRawType();
        }
        if (t instanceof WildcardType) {
            return (Class)((WildcardType)t).getUpperBounds()[0];
        }
        throw new RuntimeException("Generic TypeVariable not supported!");
    }

    private Constructor discoverConstructor() {
        block14: {
            Class type = null;
            for (Annotation an : this.foundAnnotations.values()) {
                try {
                    Method m = an.getClass().getMethod("concreteClass", new Class[0]);
                    m.setAccessible(true);
                    Object o = m.invoke((Object)an, new Object[0]);
                    if (o == null || o.equals(Object.class)) continue;
                    type = (Class)o;
                    break;
                }
                catch (NoSuchMethodException m) {
                }
                catch (IllegalArgumentException e) {
                    if (!LOG.isWarnEnabled()) continue;
                    LOG.warn("There should not be an argument", (Throwable)e);
                }
                catch (Exception e) {
                    if (!LOG.isWarnEnabled()) continue;
                    LOG.warn("", (Throwable)e);
                }
            }
            if (type != null) {
                try {
                    this.constructor = type.getDeclaredConstructor(new Class[0]);
                    this.constructor.setAccessible(true);
                }
                catch (NoSuchMethodException e) {
                    if (!this.hasAnnotation(ConstructorArgs.class) && LOG.isWarnEnabled()) {
                        LOG.warn("No usable constructor for " + type.getName(), (Throwable)e);
                    }
                    break block14;
                }
            }
            type = this.getType();
            if (type == List.class || type == Map.class) {
                return null;
            }
            if (type != null) {
                try {
                    this.constructor = type.getDeclaredConstructor(new Class[0]);
                    this.constructor.setAccessible(true);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
            }
        }
        return this.constructor;
    }

    private void discoverMultivalued() {
        this.isMap = Map.class.isAssignableFrom(this.realType);
        this.isSet = Set.class.isAssignableFrom(this.realType);
        this.isCollection = Collection.class.isAssignableFrom(this.realType);
        this.isArray = this.realType.isArray();
        if (this.isArray || this.isCollection || this.isMap || this.isSet || GenericArrayType.class.isAssignableFrom(this.genericType.getClass())) {
            this.isSingleValue = false;
            Type type = this.realType.isArray() ? this.realType.getComponentType() : (this.subType = ReflectionUtils.getParameterizedType(this.field, this.isMap ? 1 : 0));
            if (this.isMap) {
                this.mapKeyType = ReflectionUtils.getParameterizedType(this.field, 0);
            }
        }
    }

    void setIsMap(boolean isMap) {
        this.isMap = isMap;
    }

    void setIsMongoType(boolean isMongoType) {
        this.isMongoType = isMongoType;
    }

    void setIsSet(boolean isSet) {
        this.isSet = isSet;
    }

    void setMapKeyType(Class mapKeyType) {
        this.mapKeyType = mapKeyType;
    }

    static {
        INTERESTING.add(Serialized.class);
        INTERESTING.add(Indexed.class);
        INTERESTING.add(Property.class);
        INTERESTING.add(Reference.class);
        INTERESTING.add(Embedded.class);
        INTERESTING.add(Id.class);
        INTERESTING.add(Version.class);
        INTERESTING.add(ConstructorArgs.class);
        INTERESTING.add(AlsoLoad.class);
        INTERESTING.add(NotSaved.class);
        INTERESTING.add(Text.class);
    }
}

