/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.mapping;

import com.mongodb.DBObject;
import dev.morphia.ObjectFactory;
import dev.morphia.annotations.ConstructorArgs;
import dev.morphia.mapping.MappedField;
import dev.morphia.mapping.Mapper;
import dev.morphia.mapping.MapperOptions;
import dev.morphia.mapping.MappingException;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultCreator
implements ObjectFactory {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultCreator.class);
    private Map<String, Class> classNameCache = new ConcurrentHashMap<String, Class>();
    private final MapperOptions options;

    public DefaultCreator() {
        this.options = MapperOptions.builder().build();
    }

    public DefaultCreator(MapperOptions options) {
        this.options = options;
    }

    private static <T> Constructor<T> getNoArgsConstructor(Class<T> type) {
        try {
            Constructor<T> constructor = type.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            return constructor;
        }
        catch (NoSuchMethodException e) {
            throw new MappingException("No usable constructor for " + type.getName(), e);
        }
    }

    @Deprecated
    public <T> T createInst(Class<T> clazz) {
        return this.createInstance(clazz);
    }

    @Override
    public <T> T createInstance(Class<T> clazz) {
        try {
            return DefaultCreator.getNoArgsConstructor(clazz).newInstance(new Object[0]);
        }
        catch (Exception e) {
            if (Map.class.isAssignableFrom(clazz)) {
                return (T)this.createMap(null);
            }
            if (Set.class.isAssignableFrom(clazz)) {
                return (T)this.createSet(null);
            }
            if (Collection.class.isAssignableFrom(clazz)) {
                return (T)this.createList(null);
            }
            throw new MappingException("No usable constructor for " + clazz.getName(), e);
        }
    }

    @Override
    public <T> T createInstance(Class<T> clazz, DBObject dbObj) {
        Class<T> c = this.getClass(dbObj, this.options.getClassLoader());
        if (c == null) {
            c = clazz;
        }
        return this.createInstance(c);
    }

    @Override
    public Object createInstance(Mapper mapper, MappedField mf, DBObject dbObj) {
        Class c = this.getClass(dbObj, this.options.getClassLoader());
        if (c == null) {
            Class clazz = c = mf.isSingleValue() ? mf.getConcreteType() : mf.getSubClass();
            if (c.equals(Object.class)) {
                c = mf.getConcreteType();
            }
        }
        try {
            return this.createInstance(c, dbObj);
        }
        catch (RuntimeException e) {
            ConstructorArgs argAnn = mf.getAnnotation(ConstructorArgs.class);
            if (argAnn == null) {
                throw e;
            }
            Object[] args = new Object[argAnn.value().length];
            Class[] argTypes = new Class[argAnn.value().length];
            for (int i = 0; i < argAnn.value().length; ++i) {
                Object val;
                args[i] = val = dbObj.get(argAnn.value()[i]);
                argTypes[i] = val.getClass();
            }
            try {
                Constructor constructor = c.getDeclaredConstructor(argTypes);
                constructor.setAccessible(true);
                return constructor.newInstance(args);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    @Override
    public List createList(MappedField mf) {
        return this.newInstance(mf != null ? mf.getCTor() : null, ArrayList.class);
    }

    @Override
    public Map createMap(MappedField mf) {
        return this.newInstance(mf != null ? mf.getCTor() : null, HashMap.class);
    }

    @Override
    public Set createSet(MappedField mf) {
        return this.newInstance(mf != null ? mf.getCTor() : null, HashSet.class);
    }

    public Map<String, Class> getClassNameCache() {
        HashMap<String, Class> copy = new HashMap<String, Class>();
        copy.putAll(this.classNameCache);
        return copy;
    }

    private <T> Class<T> getClass(DBObject dbObj, ClassLoader classLoader) {
        Class<?> c;
        block6: {
            c = null;
            if (dbObj.containsField(this.options.getDiscriminatorField())) {
                String className = (String)dbObj.get(this.options.getDiscriminatorField());
                try {
                    if (this.options.isCacheClassLookups()) {
                        c = this.classNameCache.get(className);
                        if (c == null) {
                            c = Class.forName(className, true, classLoader);
                            this.classNameCache.put(className, c);
                        }
                    } else {
                        c = Class.forName(className, true, classLoader);
                    }
                }
                catch (ClassNotFoundException e) {
                    if (!LOG.isWarnEnabled()) break block6;
                    LOG.warn("Class not found defined in dbObj: ", (Throwable)e);
                }
            }
        }
        return c;
    }

    private <T> T newInstance(Constructor<T> tryMe, Class<T> fallbackType) {
        if (tryMe != null) {
            tryMe.setAccessible(true);
            try {
                return tryMe.newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return this.createInstance(fallbackType);
    }
}

