/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.mapping;

import dev.morphia.DatastoreImpl;
import java.time.ZoneId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum DateStorage {
    UTC{

        @Override
        public ZoneId getZone() {
            return ZoneId.of("UTC");
        }
    }
    ,
    SYSTEM_DEFAULT{

        @Override
        public ZoneId getZone() {
            if (!warningLogged) {
                warningLogged = true;
                LOG.warn("Currently using the system default zoneId for encoding.  This default will change in 2.0 to use UTC which will likely break your application.  Consult the migration guide for mitigation suggestions.");
            }
            return ZoneId.systemDefault();
        }
    };

    private static final Logger LOG;
    private static boolean warningLogged;

    public abstract ZoneId getZone();

    static {
        LOG = LoggerFactory.getLogger(DatastoreImpl.class);
    }
}

