/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.logging.jdk;

import dev.morphia.logging.Logger;
import java.util.logging.Level;

public class FastestJDKLogger
implements Logger {
    private final java.util.logging.Logger logger;
    private final transient String className;

    public FastestJDKLogger(Class c) {
        this.className = c.getName();
        this.logger = java.util.logging.Logger.getLogger(this.className);
    }

    @Override
    public void debug(String msg) {
        this.log(Level.FINE, msg, new Object[0]);
    }

    @Override
    public void debug(String format, Object ... arg) {
        this.log(Level.FINE, format, arg);
    }

    @Override
    public void debug(String msg, Throwable t) {
        this.log(Level.FINE, msg, t);
    }

    @Override
    public void error(String msg) {
        this.log(Level.SEVERE, msg, new Object[0]);
    }

    @Override
    public void error(String format, Object ... arg) {
        this.log(Level.SEVERE, format, arg);
    }

    @Override
    public void error(String msg, Throwable t) {
        this.log(Level.SEVERE, msg, t);
    }

    @Override
    public void info(String msg) {
        this.log(Level.INFO, msg, new Object[0]);
    }

    @Override
    public void info(String format, Object ... arg) {
        this.log(Level.INFO, format, arg);
    }

    @Override
    public void info(String msg, Throwable t) {
        this.log(Level.INFO, msg, t);
    }

    @Override
    public boolean isDebugEnabled() {
        return this.logger.isLoggable(Level.FINE);
    }

    @Override
    public boolean isErrorEnabled() {
        return this.logger.isLoggable(Level.SEVERE);
    }

    @Override
    public boolean isInfoEnabled() {
        return this.logger.isLoggable(Level.INFO);
    }

    @Override
    public boolean isTraceEnabled() {
        return this.logger.isLoggable(Level.FINER);
    }

    @Override
    public boolean isWarningEnabled() {
        return this.logger.isLoggable(Level.WARNING);
    }

    @Override
    public void trace(String msg) {
        this.log(Level.FINER, msg, new Object[0]);
    }

    @Override
    public void trace(String format, Object ... arg) {
        this.log(Level.FINER, format, arg);
    }

    @Override
    public void trace(String msg, Throwable t) {
        this.log(Level.FINER, msg, t);
    }

    @Override
    public void warning(String msg) {
        this.log(Level.WARNING, msg, new Object[0]);
    }

    @Override
    public void warning(String format, Object ... arg) {
        this.log(Level.WARNING, format, arg);
    }

    @Override
    public void warning(String msg, Throwable t) {
        this.log(Level.WARNING, msg, t);
    }

    public String getClassName() {
        return this.className;
    }

    public java.util.logging.Logger getLogger() {
        return this.logger;
    }

    protected void log(Level l, String m, Throwable t) {
        if (this.logger.isLoggable(l)) {
            this.logger.logp(l, this.className, null, m, t);
        }
    }

    protected void log(Level l, String f, Object ... a) {
        if (this.logger.isLoggable(l)) {
            this.logger.logp(l, this.className, (String)null, f, a);
        }
    }
}

